/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.jface.dialogs;

import org.eclipse.osgi.util.NLS;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.api.LicensingResult;
import org.eclipse.passage.lic.base.LicensingResults;
import org.eclipse.passage.lic.internal.jface.i18n.JFaceMessages;
import org.eclipse.passage.lic.jface.dialogs.LicensingPage;
import org.eclipse.passage.lic.jface.dialogs.LicensingPageContributor;

public class BasePageContributor
implements LicensingPageContributor {
    private final String pageIdentifier;
    private final String pageName;
    private final Class<? extends LicensingPage> pageClass;

    public BasePageContributor(String pageIdentifier, String pageName, Class<? extends LicensingPage> pageClass) {
        this.pageIdentifier = pageIdentifier;
        this.pageName = pageName;
        this.pageClass = pageClass;
    }

    @Override
    public String getPageIdentifier() {
        return this.pageIdentifier;
    }

    @Override
    public String getPageName() {
        return this.pageName;
    }

    @Override
    public LicensingPage createPage() throws LicensingException {
        try {
            return this.pageClass.newInstance();
        }
        catch (Exception e) {
            String message = NLS.bind((String)JFaceMessages.BasePageContributor_e_create_page_instance, this.pageClass);
            LicensingResult error = LicensingResults.createError((String)message, (String)this.pageIdentifier, (Throwable)e);
            throw new LicensingException(error);
        }
    }
}

