/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.equinox.requirements;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.passage.lic.api.LicensingConfiguration;
import org.eclipse.passage.lic.api.requirements.LicensingRequirement;
import org.eclipse.passage.lic.api.requirements.RequirementResolver;
import org.eclipse.passage.lic.base.LicensingProperties;
import org.eclipse.passage.lic.base.requirements.LicensingRequirements;
import org.eclipse.passage.lic.equinox.requirements.EquinoxRequirements;
import org.eclipse.passage.lic.internal.equinox.i18n.EquinoxMessages;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component
public class BundleCapabilityResolver
implements RequirementResolver {
    private Logger logger;
    private BundleContext bundleContext;

    @Activate
    public void activate(BundleContext context) {
        this.bundleContext = context;
    }

    @Deactivate
    public void deactivate() {
        this.bundleContext = null;
    }

    public Iterable<LicensingRequirement> resolveLicensingRequirements(LicensingConfiguration configuration) {
        Bundle[] bundles;
        String nameLicensing = LicensingProperties.LICENSING_FEATURE_NAME_DEFAULT;
        String providerLicensing = LicensingProperties.LICENSING_FEATURE_PROVIDER_DEFAULT;
        if (this.bundleContext == null) {
            this.logger.severe(EquinoxMessages.BundleCapabilityResolver_error_bundle_context);
            return LicensingRequirements.createErrorIterable((String)"licensing.management", (String)"0.0.0", (String)nameLicensing, (String)providerLicensing, (Object)configuration);
        }
        ArrayList<LicensingRequirement> result = new ArrayList<LicensingRequirement>();
        Bundle[] bundleArray = bundles = this.bundleContext.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            Iterable<BundleCapability> capabilities = EquinoxRequirements.extractLicensingFeatures(bundle);
            Dictionary headers = bundle.getHeaders();
            String name = (String)headers.get("Bundle-Name");
            String vendor = (String)headers.get("Bundle-Vendor");
            for (BundleCapability capability : capabilities) {
                BundleRevision resource;
                Map directives;
                Map attributes = capability.getAttributes();
                LicensingRequirement extracted = LicensingRequirements.extractFromCapability((String)name, (String)vendor, (Map)attributes, (Map)(directives = capability.getDirectives()), (Object)(resource = capability.getResource()));
                if (extracted != null) {
                    result.add(extracted);
                    continue;
                }
                this.logger.severe(String.format(EquinoxMessages.BundleCapabilityResolver_error, resource));
                result.add(LicensingRequirements.createError((String)"licensing.management", (String)"0.0.0", (String)name, (String)providerLicensing, (Object)resource));
                return result;
            }
            ++n2;
        }
        return result;
    }
}

