/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.values;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.MapTypeId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.values.BagImpl;
import org.eclipse.ocl.pivot.internal.values.ValueImpl;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.BagValue;
import org.eclipse.ocl.pivot.values.CollectionValue;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.MapEntry;
import org.eclipse.ocl.pivot.values.MapValue;
import org.eclipse.ocl.pivot.values.SetValue;
import org.eclipse.ocl.pivot.values.ValuesPackage;

public class MapValueImpl
extends ValueImpl
implements MapValue {
    protected @NonNull MapTypeId typeId;
    protected @NonNull Map<Object, Object> boxedValues;
    private int hashCode = 0;

    private <K, V> boolean checkElementsAreValues(Iterable<Map.Entry<K, V>> elements) {
        for (Map.Entry<K, V> element : elements) {
            assert (ValueUtil.isBoxed(element.getKey()));
            assert (ValueUtil.isBoxed(element.getValue()));
        }
        return true;
    }

    public static @NonNull MapValue createMapValueOfEach(@NonNull MapTypeId typeId, MapEntry[] mapEntries) {
        HashMap<Object, Object> boxedValues = new HashMap<Object, Object>();
        if (mapEntries != null) {
            MapEntry[] mapEntryArray = mapEntries;
            int n = mapEntries.length;
            int n2 = 0;
            while (n2 < n) {
                MapEntry mapEntry = mapEntryArray[n2];
                boxedValues.put(mapEntry.getKey(), mapEntry.getValue());
                ++n2;
            }
        }
        return new MapValueImpl(typeId, boxedValues);
    }

    @Override
    protected EClass eStaticClass() {
        return ValuesPackage.Literals.MAP_VALUE;
    }

    public MapValueImpl(@NonNull MapTypeId typeId, @NonNull Map<Object, Object> boxedValues) {
        this.typeId = typeId;
        this.boxedValues = boxedValues;
        assert (this.checkElementsAreValues(boxedValues.entrySet()));
    }

    @Override
    public @Nullable List<?> asEcoreObject(@NonNull IdResolver idResolver, @Nullable Class<?> instanceClass) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> @Nullable List<T> asEcoreObjects(@NonNull IdResolver idResolver, @Nullable Class<T> instanceClass) {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull Map<? extends Object, ? extends Object> asMap() {
        return this.boxedValues;
    }

    @Override
    public @NonNull MapValue asMapValue() {
        return this;
    }

    @Override
    public @NonNull Object asObject() {
        return this.boxedValues;
    }

    @Override
    public Object at(Object value) {
        if (value instanceof InvalidValueException) {
            throw (InvalidValueException)value;
        }
        Object object = this.boxedValues.get(value);
        if (object == null && !this.boxedValues.containsKey(value)) {
            throw new InvalidValueException(PivotMessages.IndexNotInUse, value);
        }
        return object;
    }

    @Override
    public @NonNull Set<Map.Entry<Object, Object>> entrySet() {
        return this.boxedValues.entrySet();
    }

    public boolean equals(Object obj) {
        Set<Object> thoseKeys;
        int thatSize;
        if (!(obj instanceof MapValue)) {
            return false;
        }
        MapValue that = (MapValue)obj;
        int thisSize = this.intSize();
        if (thisSize != (thatSize = that.intSize())) {
            return false;
        }
        Set<Object> theseKeys = this.keySet();
        if (!theseKeys.equals(thoseKeys = that.keySet())) {
            return false;
        }
        for (Object key : theseKeys) {
            Object thatValue;
            Object thisValue = this.at(key);
            if (ClassUtil.safeEquals(thisValue, thatValue = that.at(key))) continue;
            return false;
        }
        return true;
    }

    @Override
    public @NonNull Boolean excludes(@Nullable Object key) {
        if (key instanceof InvalidValueException) {
            throw (InvalidValueException)key;
        }
        if (this.boxedValues.containsKey(key)) {
            return false;
        }
        return true;
    }

    @Override
    public @NonNull Boolean excludes(@Nullable Object key, @Nullable Object value) {
        if (key instanceof InvalidValueException) {
            throw (InvalidValueException)key;
        }
        if (value instanceof InvalidValueException) {
            throw (InvalidValueException)value;
        }
        Object keyValue = this.boxedValues.get(key);
        if (keyValue == null) {
            if (!this.boxedValues.containsKey(value)) {
                return true;
            }
            if (value != null) {
                return true;
            }
            return false;
        }
        if (keyValue.equals(value)) {
            return false;
        }
        return true;
    }

    @Override
    public @NonNull Boolean excludesAll(@NonNull CollectionValue c) {
        Set<Object> keySet = this.boxedValues.keySet();
        for (Object object : c.iterable()) {
            if (object == null) {
                for (Object e2 : keySet) {
                    if (e2 != null) continue;
                    return false;
                }
                continue;
            }
            for (Object e2 : keySet) {
                if (!object.equals(e2)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public @NonNull Boolean excludesMap(@NonNull MapValue m) {
        Set<Object> keySet = this.boxedValues.keySet();
        for (Object e1 : m.getKeys()) {
            Object thatValue;
            Object thisValue;
            if (e1 == null) {
                for (Object e2 : keySet) {
                    if (e2 != null || !ClassUtil.safeEquals(thisValue = this.at(e2), thatValue = m.at(e2))) continue;
                    return false;
                }
                continue;
            }
            for (Object e2 : keySet) {
                if (!e1.equals(e2) || !ClassUtil.safeEquals(thisValue = this.at(e2), thatValue = m.at(e2))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public @NonNull Boolean excludesValue(@Nullable Object thatValue) {
        if (thatValue instanceof InvalidValueException) {
            throw (InvalidValueException)thatValue;
        }
        for (Object thisValue : this.boxedValues.values()) {
            if (!ClassUtil.safeEquals(thisValue, thatValue)) continue;
            return false;
        }
        return true;
    }

    @Override
    public @NonNull MapValue excluding(@Nullable Object key) {
        if (key instanceof InvalidValueException) {
            throw (InvalidValueException)key;
        }
        HashMap<Object, Object> newBoxedValues = new HashMap<Object, Object>(this.boxedValues);
        newBoxedValues.remove(key);
        return new MapValueImpl(this.typeId, newBoxedValues);
    }

    @Override
    public @NonNull MapValue excluding(@Nullable Object key, @Nullable Object value) {
        if (key instanceof InvalidValueException) {
            throw (InvalidValueException)key;
        }
        if (value instanceof InvalidValueException) {
            throw (InvalidValueException)value;
        }
        HashMap<Object, Object> newBoxedValues = new HashMap<Object, Object>(this.boxedValues);
        Object actualValue = newBoxedValues.get(key);
        if (ClassUtil.safeEquals(actualValue, value)) {
            newBoxedValues.remove(key);
        }
        return new MapValueImpl(this.typeId, newBoxedValues);
    }

    @Override
    public @NonNull MapValue excludingAll(@NonNull CollectionValue c) {
        HashMap<Object, Object> newBoxedValues = new HashMap<Object, Object>(this.boxedValues);
        for (Object key : c) {
            newBoxedValues.remove(key);
        }
        return new MapValueImpl(this.typeId, newBoxedValues);
    }

    @Override
    public @NonNull MapValue excludingMap(@NonNull MapValue map) {
        HashMap<Object, Object> newBoxedValues = new HashMap<Object, Object>(this.boxedValues);
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            Object key = entry.getKey();
            Object actualValue = newBoxedValues.get(key);
            if (!ClassUtil.safeEquals(actualValue, entry.getValue())) continue;
            newBoxedValues.remove(key);
        }
        return new MapValueImpl(this.typeId, newBoxedValues);
    }

    @Override
    public @NonNull Set<Map.Entry<Object, Object>> getElements() {
        return this.boxedValues.entrySet();
    }

    @Override
    public @NonNull SetValue getKeys() {
        CollectionTypeId setId = TypeId.SET.getSpecializedId(this.typeId.getValueTypeId());
        return ValueUtil.createSetValue(setId, this.keySet());
    }

    @Override
    public @NonNull MapTypeId getTypeId() {
        return this.typeId;
    }

    @Override
    public @NonNull BagValue getValues() {
        CollectionTypeId bagId = TypeId.BAG.getSpecializedId(this.typeId.getValueTypeId());
        return ValueUtil.createBagValue(bagId, new BagImpl<Object>(this.boxedValues.values()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int hashCode() {
        if (this.hashCode == 0) {
            MapValueImpl mapValueImpl = this;
            synchronized (mapValueImpl) {
                if (this.hashCode == 0) {
                    long hash = 0x3333333333333333L;
                    for (Map.Entry<Object, Object> entry : this.boxedValues.entrySet()) {
                        Object value;
                        if (entry == null) continue;
                        Object key = entry.getKey();
                        if (key != null) {
                            hash += (long)(3 * key.hashCode());
                        }
                        if ((value = entry.getValue()) == null) continue;
                        hash += (long)(5 * value.hashCode());
                    }
                    this.hashCode = (int)hash;
                    if (this.hashCode == 0) {
                        this.hashCode = (int)(hash >> 32);
                        if (this.hashCode == 0) {
                            this.hashCode = -2023406815;
                        }
                    }
                }
            }
        }
        return this.hashCode;
    }

    @Override
    public @NonNull Boolean includes(@Nullable Object key) {
        if (key instanceof InvalidValueException) {
            throw (InvalidValueException)key;
        }
        return this.boxedValues.containsKey(key);
    }

    @Override
    public @NonNull Boolean includes(@Nullable Object key, @Nullable Object value) {
        if (key instanceof InvalidValueException) {
            throw (InvalidValueException)key;
        }
        if (value instanceof InvalidValueException) {
            throw (InvalidValueException)value;
        }
        Object keyValue = this.boxedValues.get(key);
        if (keyValue == null) {
            if (!this.boxedValues.containsKey(value)) {
                return false;
            }
            if (value == null) {
                return true;
            }
            return false;
        }
        return keyValue.equals(value);
    }

    @Override
    public @NonNull Boolean includesAll(@NonNull CollectionValue c) {
        Set<Object> keySet = this.boxedValues.keySet();
        for (Object object : c.iterable()) {
            boolean gotIt = false;
            if (object == null) {
                for (Object e2 : keySet) {
                    if (e2 != null) continue;
                    gotIt = true;
                    break;
                }
            } else {
                for (Object e2 : keySet) {
                    if (!object.equals(e2)) continue;
                    gotIt = true;
                    break;
                }
            }
            if (gotIt) continue;
            return false;
        }
        return true;
    }

    @Override
    public @NonNull Boolean includesMap(@NonNull MapValue m) {
        Set<Object> keySet = this.boxedValues.keySet();
        for (Object e1 : m.getKeys()) {
            Object thatValue;
            Object thisValue;
            boolean gotIt = false;
            if (e1 == null) {
                for (Object e2 : keySet) {
                    if (e2 != null || !ClassUtil.safeEquals(thisValue = this.at(e2), thatValue = m.at(e2))) continue;
                    gotIt = true;
                    break;
                }
            } else {
                for (Object e2 : keySet) {
                    if (!e1.equals(e2) || !ClassUtil.safeEquals(thisValue = this.at(e2), thatValue = m.at(e2))) continue;
                    gotIt = true;
                    break;
                }
            }
            if (gotIt) continue;
            return false;
        }
        return true;
    }

    @Override
    public @NonNull Boolean includesValue(@Nullable Object thatValue) {
        if (thatValue instanceof InvalidValueException) {
            throw (InvalidValueException)thatValue;
        }
        for (Object thisValue : this.boxedValues.values()) {
            if (!ClassUtil.safeEquals(thisValue, thatValue)) continue;
            return true;
        }
        return false;
    }

    @Override
    public @NonNull MapValue including(@NonNull MapTypeId returnTypeId, @Nullable Object key, @Nullable Object value) {
        if (key instanceof InvalidValueException) {
            throw (InvalidValueException)key;
        }
        if (value instanceof InvalidValueException) {
            throw (InvalidValueException)value;
        }
        HashMap<Object, Object> newBoxedValues = new HashMap<Object, Object>(this.boxedValues);
        newBoxedValues.put(key, value);
        return new MapValueImpl(returnTypeId, newBoxedValues);
    }

    @Override
    public @NonNull MapValue includingMap(@NonNull MapTypeId returnTypeId, @NonNull MapValue map) {
        HashMap<Object, Object> newBoxedValues = new HashMap<Object, Object>(this.boxedValues);
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            newBoxedValues.put(entry.getKey(), entry.getValue());
        }
        return new MapValueImpl(returnTypeId, newBoxedValues);
    }

    @Override
    public int intSize() {
        return this.boxedValues.size();
    }

    @Override
    public @NonNull Boolean isEmpty() {
        if (this.intSize() == 0) {
            return true;
        }
        return false;
    }

    @Override
    public @NonNull Set<Object> keySet() {
        return this.boxedValues.keySet();
    }

    @Override
    public @NonNull Boolean notEmpty() {
        if (this.intSize() != 0) {
            return true;
        }
        return false;
    }

    @Override
    public @NonNull IntegerValue size() {
        return ValueUtil.integerValueOf(this.intSize());
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        this.toString(s, 100);
        return s.toString();
    }

    @Override
    public void toString(@NonNull StringBuilder s, int lengthLimit) {
        s.append("Map");
        s.append("{");
        boolean isFirst = true;
        for (Map.Entry<Object, Object> entry : this.boxedValues.entrySet()) {
            if (!isFirst) {
                s.append(",");
            }
            if (s.length() >= lengthLimit) {
                s.append("...");
                break;
            }
            ValueUtil.toString(entry.getKey(), s, lengthLimit - 1);
            s.append(" <- ");
            ValueUtil.toString(entry.getValue(), s, lengthLimit - 1);
            isFirst = false;
        }
        s.append("}");
    }
}

