/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.library;

import java.lang.reflect.Method;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.library.AbstractSimpleBinaryOperation;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.InvalidValueException;

public class JavaCompareToOperation
extends AbstractSimpleBinaryOperation {
    protected final @NonNull Method method;

    public JavaCompareToOperation(@NonNull Method method) {
        this.method = method;
    }

    @Override
    public @Nullable Object evaluate(@Nullable Object leftValue, @Nullable Object rightValue) {
        Object leftObject = JavaCompareToOperation.asObject(leftValue);
        Object rightObject = JavaCompareToOperation.asObject(rightValue);
        try {
            Object result = this.method.invoke(leftObject, rightObject);
            if (!(result instanceof Integer)) {
                throw new InvalidValueException(PivotMessages.TypedResultRequired, "Integer");
            }
            return ValueUtil.integerValueOf((Integer)result);
        }
        catch (Exception e) {
            throw new InvalidValueException(e, PivotMessages.TypedResultRequired, "Integer");
        }
    }
}

