/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.library;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.library.AbstractOperation;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;

public class ConstrainedOperation
extends AbstractOperation {
    protected final @NonNull ExpressionInOCL expressionInOCL;

    public ConstrainedOperation(@NonNull ExpressionInOCL expressionInOCL) {
        this.expressionInOCL = expressionInOCL;
    }

    @Override
    public @Nullable Object dispatch(@NonNull Executor executor, @NonNull OperationCallExp callExp, @Nullable Object sourceValue) {
        List<OCLExpression> arguments = callExp.getOwnedArguments();
        @Nullable Object[] argumentValues = new Object[arguments.size()];
        int i = 0;
        while (i < arguments.size()) {
            OCLExpression argument = arguments.get(i);
            assert (argument != null);
            argumentValues[i] = executor.evaluate(argument);
            ++i;
        }
        return this.evaluate(executor, callExp, sourceValue, argumentValues);
    }

    private @Nullable Object evaluate(@NonNull Executor executor, @NonNull OperationCallExp callExp, @Nullable Object sourceValue, Object ... argumentValues) {
        PivotUtil.checkExpression(this.expressionInOCL);
        EvaluationEnvironment nestedEvaluationEnvironment = executor.pushEvaluationEnvironment(this.expressionInOCL, callExp);
        nestedEvaluationEnvironment.add(ClassUtil.nonNullModel(this.expressionInOCL.getOwnedContext()), sourceValue);
        List<Variable> parameters = this.expressionInOCL.getOwnedParameters();
        if (!parameters.isEmpty()) {
            int i = 0;
            while (i < parameters.size()) {
                Object value = argumentValues[i];
                nestedEvaluationEnvironment.add(ClassUtil.nonNullModel(parameters.get(i)), value);
                ++i;
            }
        }
        try {
            OCLExpression bodyExpression = this.expressionInOCL.getOwnedBody();
            assert (bodyExpression != null);
            Object object = executor.evaluate(bodyExpression);
            return object;
        }
        finally {
            executor.popEvaluationEnvironment();
        }
    }
}

