/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.infra.ui.loadresource;

import org.eclipse.emf.cdo.dawn.ui.views.DawnExplorer;
import org.eclipse.emf.cdo.dawn.ui.wizards.dialogs.CDOResourceNodeSelectionDialog;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.ui.CommonUIPlugin;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.PlatformUI;

public class LoadResourceDialog
extends LoadResourceAction.LoadResourceDialog {
    public LoadResourceDialog(Shell parent) {
        super(parent, null);
    }

    public LoadResourceDialog(Shell parent, EditingDomain domain) {
        super(parent, domain);
    }

    protected Control createDialogArea(Composite parent) {
        FormData data;
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(1808));
        LoadResourceDialog.applyDialogFont((Control)composite);
        FormLayout formLayout = new FormLayout();
        composite.setLayout((Layout)formLayout);
        GridData data2 = new GridData();
        data2.verticalAlignment = 4;
        data2.grabExcessVerticalSpace = true;
        data2.horizontalAlignment = 4;
        data2.grabExcessHorizontalSpace = true;
        if (!EMFPlugin.IS_RESOURCES_BUNDLE_AVAILABLE) {
            data2.widthHint = 330;
        }
        composite.setLayoutData((Object)data2);
        Composite buttonComposite = new Composite(composite, 0);
        Label resourceURILabel = new Label(composite, 16384);
        resourceURILabel.setText(CommonUIPlugin.INSTANCE.getString(this.isMulti() ? "_UI_ResourceURIs_label" : "_UI_ResourceURI_label"));
        FormData data3 = new FormData();
        data3.left = new FormAttachment(0, 10);
        data3.top = new FormAttachment(0, 10);
        resourceURILabel.setLayoutData((Object)data3);
        data3 = new FormData();
        data3.top = new FormAttachment((Control)resourceURILabel, 10, 0x1000000);
        data3.left = new FormAttachment((Control)resourceURILabel, 10);
        data3.right = new FormAttachment(100, -10);
        buttonComposite.setLayoutData((Object)data3);
        buttonComposite.setLayout((Layout)new FormLayout());
        this.uriField = new Text(composite, 2048);
        data3 = new FormData();
        data3.top = new FormAttachment((Control)buttonComposite, 10);
        data3.left = new FormAttachment(0, 10);
        data3.right = new FormAttachment(100, -10);
        this.uriField.setLayoutData((Object)data3);
        Button browseFileSystemButton = new Button(buttonComposite, 8);
        browseFileSystemButton.setText("Browse Repository");
        this.prepareBrowseFileSystemButton(browseFileSystemButton);
        if (EMFPlugin.IS_RESOURCES_BUNDLE_AVAILABLE) {
            Button browseWorkspaceButton = new Button(buttonComposite, 8);
            data = new FormData();
            data.right = new FormAttachment(100);
            browseWorkspaceButton.setLayoutData((Object)data);
            data = new FormData();
            data.right = new FormAttachment((Control)browseWorkspaceButton, -10);
            browseFileSystemButton.setLayoutData((Object)data);
            browseWorkspaceButton.setText(CommonUIPlugin.INSTANCE.getString("_UI_BrowseWorkspace_label"));
            this.prepareBrowseWorkspaceButton(browseWorkspaceButton);
        } else {
            FormData data4 = new FormData();
            data4.right = new FormAttachment(100);
            browseFileSystemButton.setLayoutData((Object)data4);
        }
        Label separatorLabel = new Label(composite, 258);
        data = new FormData();
        data.top = new FormAttachment((Control)this.uriField, 15);
        data.left = new FormAttachment(0, -10);
        data.right = new FormAttachment(100, 10);
        separatorLabel.setLayoutData((Object)data);
        composite.setTabList(new Control[]{this.uriField, buttonComposite});
        return composite;
    }

    protected void prepareBrowseFileSystemButton(Button browseFileSystemButton) {
        browseFileSystemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DawnExplorer repoView = null;
                IViewReference[] viewReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getViewReferences();
                int i = 0;
                while (i < viewReferences.length) {
                    if ("org.eclipse.emf.cdo.dawn.ui.views.DawnExplorer".equals(viewReferences[i].getId())) {
                        repoView = (DawnExplorer)viewReferences[i].getView(false);
                        break;
                    }
                    ++i;
                }
                CDOResourceNodeSelectionDialog fileDialog = new CDOResourceNodeSelectionDialog(LoadResourceDialog.this.getShell(), repoView.getView(), true){

                    protected void initializeBounds() {
                        this.getShell().setSize(500, 700);
                    }
                };
                fileDialog.open();
                String fileName = fileDialog.getResults().toString();
                if (fileName != null && !fileName.equals("cdo://opencert/")) {
                    LoadResourceDialog.this.uriField.setText(fileName);
                }
            }
        });
    }
}

