/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.apm.assurproj.wizards.ui.wizards;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.dawn.preferences.PreferenceConstants;
import org.eclipse.emf.cdo.dawn.ui.views.DawnExplorer;
import org.eclipse.emf.cdo.dawn.util.connection.CDOConnectionUtil;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.opencert.apm.assurproj.wizards.WizardEMFContext;
import org.eclipse.opencert.apm.assurproj.wizards.ui.wizards.AssurProjInitializationHelper;
import org.eclipse.opencert.apm.assurproj.wizards.ui.wizards.AssurProjRefFrameworkSelectionWizardPage;
import org.eclipse.opencert.apm.assurproj.wizards.ui.wizards.SelectProjectWizardPage;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class NewBaselineWizard
extends Wizard
implements INewWizard {
    private static final String CREATE_PROJECT_BASELINE = "Create Project Baseline";
    private SelectProjectWizardPage projectSelection;
    private AssurProjRefFrameworkSelectionWizardPage refSelectionPage;
    protected String qrefDir;
    private WizardEMFContext wizardExecutionContext = new WizardEMFContext((IWizard)this);
    CDOTransaction transaction = null;
    private Button generateArgModel;

    public void addPages() {
        super.addPages();
        this.projectSelection = this.createProjSelectionPage();
        this.addPage((IWizardPage)this.projectSelection);
        this.refSelectionPage = this.createAssurProjSelectionPage();
        this.addPage((IWizardPage)this.refSelectionPage);
    }

    protected SelectProjectWizardPage createProjSelectionPage() {
        DawnExplorer repoView = null;
        IViewReference[] viewReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getViewReferences();
        int i = 0;
        while (i < viewReferences.length) {
            if ("org.eclipse.emf.cdo.dawn.ui.views.DawnExplorer".equals(viewReferences[i].getId())) {
                repoView = (DawnExplorer)viewReferences[i].getView(false);
                break;
            }
            ++i;
        }
        if (repoView != null) {
            this.transaction = repoView.getView().getSession().openTransaction();
            return new SelectProjectWizardPage("assuranceproject", true, repoView.getView());
        }
        CDOConnectionUtil.instance.init(PreferenceConstants.getRepositoryName(), PreferenceConstants.getProtocol(), PreferenceConstants.getServerName());
        CDOSession sessionCDO = CDOConnectionUtil.instance.openSession();
        CDOView view = sessionCDO.openView();
        this.transaction = sessionCDO.openTransaction();
        return new SelectProjectWizardPage("assuranceproject", true, view);
    }

    protected AssurProjRefFrameworkSelectionWizardPage createAssurProjSelectionPage() {
        return new AssurProjRefFrameworkSelectionWizardPage("Reference Framework Selection");
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean performFinish() {
        URI project = this.projectSelection.getURI();
        String confirmationText = "";
        if (project != null) {
            String path = project.path();
            CDOResourceFolder assuranceprojectFolder = this.transaction.getResourceFolder(path = path.substring(0, path.lastIndexOf("/")));
            CDOResource targetResource = this.transaction.getOrCreateResource(String.valueOf(assuranceprojectFolder.getPath()) + "/" + this.refSelectionPage.getBaselineName() + ".baseline");
            if (targetResource.isExisting()) {
                String argFolderPath;
                CDOResource argResource;
                confirmationText = "Selected Assurance Project already has a baseline model with the same name and will be replaced.\n";
                if (this.projectSelection.generateArgumentation() && (argResource = this.transaction.getOrCreateResource(String.valueOf(argFolderPath = assuranceprojectFolder.getPath().substring(0, assuranceprojectFolder.getPath().lastIndexOf("/"))) + "/ARGUMENTATION/" + this.refSelectionPage.getBaselineName() + ".arg")).isExisting()) {
                    confirmationText = String.valueOf(confirmationText) + "\nSelected Assurance Project already has an argumentation model with the same name and will be replaced.\n";
                }
                confirmationText = String.valueOf(confirmationText) + "\n\nDo you want to continue the process?\n";
                boolean confirmation = MessageDialog.openConfirm((Shell)this.getShell(), (String)"Updatation process", (String)confirmationText);
                if (!confirmation) {
                    return false;
                }
            }
        }
        confirmationText = "This process could take several minutes.\n\nDo you want to continue?";
        boolean confirmation = MessageDialog.openConfirm((Shell)this.getShell(), (String)"Baseline creation or updatation process", (String)confirmationText);
        if (!confirmation) {
            return false;
        }
        this.transaction.close();
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
        dialog.open();
        IProgressMonitor monitor = dialog.getProgressMonitor();
        monitor.beginTask(CREATE_PROJECT_BASELINE, 20);
        AssurProjInitializationHelper projectInitializer = new AssurProjInitializationHelper("Name", this.projectSelection.generateArgumentation());
        monitor.worked(1);
        Object[] refRequirements = this.refSelectionPage.getSelectedRefReq();
        this.qrefDir = this.refSelectionPage.getQRef();
        try {
            projectInitializer.createCreateCommands(monitor, this.getContainer(), refRequirements, this.qrefDir, this.refSelectionPage.getBaselineName(), project);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        monitor.worked(1);
        return true;
    }

    public static IProject getCurrentSelectedProject() {
        Object element;
        IProject project = null;
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        ISelection selection = selectionService.getSelection();
        if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof IResource) {
            project = ((IResource)element).getProject();
        }
        return project;
    }
}

