/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.syncing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.CDOCommonSession;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.commit.CDOChangeKind;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.commit.CDOCommitData;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoHandler;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.lob.CDOLob;
import org.eclipse.emf.cdo.common.lock.CDOLockChangeInfo;
import org.eclipse.emf.cdo.common.lock.CDOLockOwner;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.common.lock.CDOLockUtil;
import org.eclipse.emf.cdo.common.lock.IDurableLockingManager;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDOProtocol;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.common.util.CDOException;
import org.eclipse.emf.cdo.internal.common.commit.DelegatingCommitInfo;
import org.eclipse.emf.cdo.internal.common.revision.AbstractCDORevisionCache;
import org.eclipse.emf.cdo.internal.server.Repository;
import org.eclipse.emf.cdo.internal.server.TransactionCommitContext;
import org.eclipse.emf.cdo.internal.server.syncing.ReplicatorCommitContext;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchAdjustable;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.commit.CDOChangeKindCache;
import org.eclipse.emf.cdo.spi.common.commit.CDOCommitInfoUtil;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionCache;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.server.InternalCommitContext;
import org.eclipse.emf.cdo.spi.server.InternalLockManager;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalRepositorySynchronizer;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;
import org.eclipse.emf.cdo.spi.server.InternalStore;
import org.eclipse.emf.cdo.spi.server.InternalSynchronizableRepository;
import org.eclipse.emf.cdo.spi.server.InternalTransaction;
import org.eclipse.emf.cdo.spi.server.InternalView;
import org.eclipse.emf.cdo.spi.server.SyncingUtil;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.collection.IndexedList;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.concurrent.TimeoutRuntimeException;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.monitor.Monitor;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.transaction.TransactionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SynchronizableRepository
extends Repository.Default
implements InternalSynchronizableRepository {
    protected static final CDOCommonRepository.Type MASTER = CDOCommonRepository.Type.MASTER;
    protected static final CDOCommonRepository.Type BACKUP = CDOCommonRepository.Type.BACKUP;
    protected static final CDOCommonRepository.Type CLONE = CDOCommonRepository.Type.CLONE;
    protected static final CDOCommonRepository.State INITIAL = CDOCommonRepository.State.INITIAL;
    protected static final CDOCommonRepository.State OFFLINE = CDOCommonRepository.State.OFFLINE;
    protected static final CDOCommonRepository.State SYNCING = CDOCommonRepository.State.SYNCING;
    protected static final CDOCommonRepository.State ONLINE = CDOCommonRepository.State.ONLINE;
    private static final String PROP_LAST_REPLICATED_BRANCH_ID = "org.eclipse.emf.cdo.server.lastReplicatedBranchID";
    private static final String PROP_LAST_REPLICATED_COMMIT_TIME = "org.eclipse.emf.cdo.server.lastReplicatedCommitTime";
    private static final String PROP_GRACEFULLY_SHUT_DOWN = "org.eclipse.emf.cdo.server.gracefullyShutDown";
    private InternalRepositorySynchronizer synchronizer;
    private InternalSession replicatorSession;
    private int lastReplicatedBranchID = 0;
    private long lastReplicatedCommitTime = 0L;
    private int lastTransactionID;
    private ReentrantReadWriteLock.ReadLock writeThroughCommitLock;
    private ReentrantReadWriteLock.WriteLock handleCommitInfoLock;

    public SynchronizableRepository() {
        ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
        this.writeThroughCommitLock = rwLock.readLock();
        this.handleCommitInfoLock = rwLock.writeLock();
    }

    @Override
    public InternalRepositorySynchronizer getSynchronizer() {
        return this.synchronizer;
    }

    @Override
    public void setSynchronizer(InternalRepositorySynchronizer synchronizer) {
        this.checkInactive();
        this.synchronizer = synchronizer;
    }

    @Override
    public InternalSession getReplicatorSession() {
        return this.replicatorSession;
    }

    @Override
    public Object[] getElements() {
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(super.getElements()));
        list.add(this.synchronizer);
        return list.toArray();
    }

    @Override
    public boolean hasBeenReplicated() {
        return this.getLastReplicatedCommitTime() != 0L;
    }

    @Override
    public int getLastReplicatedBranchID() {
        return this.lastReplicatedBranchID;
    }

    @Override
    public void setLastReplicatedBranchID(int lastReplicatedBranchID) {
        if (this.lastReplicatedBranchID < lastReplicatedBranchID) {
            this.lastReplicatedBranchID = lastReplicatedBranchID;
        }
    }

    @Override
    public long getLastReplicatedCommitTime() {
        return this.lastReplicatedCommitTime;
    }

    @Override
    public void setLastReplicatedCommitTime(long lastReplicatedCommitTime) {
        if (this.lastReplicatedCommitTime < lastReplicatedCommitTime) {
            this.lastReplicatedCommitTime = lastReplicatedCommitTime;
        }
    }

    @Override
    public void setLastCommitTimeStamp(long lastCommitTimeStamp) {
        super.setLastCommitTimeStamp(lastCommitTimeStamp);
        if (this.getType() == MASTER) {
            this.setLastReplicatedCommitTime(lastCommitTimeStamp);
        }
    }

    public String[] getLockAreaIDs() {
        try {
            StoreThreadLocal.setSession(this.replicatorSession);
            final LinkedList areaIDs = new LinkedList();
            this.getLockingManager().getLockAreas(null, new IDurableLockingManager.LockArea.Handler(){

                public boolean handleLockArea(IDurableLockingManager.LockArea area) {
                    areaIDs.add(area.getDurableLockingID());
                    return true;
                }
            });
            String[] stringArray = areaIDs.toArray(new String[areaIDs.size()]);
            return stringArray;
        }
        finally {
            StoreThreadLocal.release();
        }
    }

    public void handleBranch(CDOBranch branch) {
        if (branch.isLocal()) {
            return;
        }
        int branchID = branch.getID();
        String name = branch.getName();
        CDOBranchPoint base = branch.getBase();
        InternalCDOBranch baseBranch = (InternalCDOBranch)base.getBranch();
        long baseTimeStamp = base.getTimeStamp();
        InternalCDOBranchManager branchManager = this.getBranchManager();
        branchManager.createBranch(branchID, name, baseBranch, baseTimeStamp);
        this.setLastReplicatedBranchID(branchID);
    }

    public void handleCommitInfo(final CDOCommitInfo commitInfo) {
        CDOBranchAdjustable branchAdjustable;
        CDOBranch branch = commitInfo.getBranch();
        if (branch.isLocal()) {
            return;
        }
        InternalCDOBranchManager newBranchManager = this.getBranchManager();
        for (CDOIDAndVersion key : commitInfo.getNewObjects()) {
            if (!(key instanceof CDOBranchAdjustable)) continue;
            branchAdjustable = (CDOBranchAdjustable)key;
            branchAdjustable.adjustBranches((CDOBranchManager)newBranchManager);
        }
        for (CDOIDAndVersion key : commitInfo.getChangedObjects()) {
            if (!(key instanceof CDOBranchAdjustable)) continue;
            branchAdjustable = (CDOBranchAdjustable)key;
            branchAdjustable.adjustBranches((CDOBranchManager)newBranchManager);
        }
        for (CDOIDAndVersion key : commitInfo.getDetachedObjects()) {
            if (!(key instanceof CDOBranchAdjustable)) continue;
            branchAdjustable = (CDOBranchAdjustable)key;
            branchAdjustable.adjustBranches((CDOBranchManager)newBranchManager);
        }
        final InternalCDOBranch newBranch = newBranchManager.getBranch(branch.getID());
        DelegatingCommitInfo newCommitInfo = new DelegatingCommitInfo(){

            protected CDOCommitInfo getDelegate() {
                return commitInfo;
            }

            public CDOBranch getBranch() {
                return newBranch;
            }
        };
        long timeStamp = newCommitInfo.getTimeStamp();
        CDOBranchPoint head = newBranch.getHead();
        InternalTransaction transaction = this.replicatorSession.openTransaction(++this.lastTransactionID, head);
        ReplicatorCommitContext commitContext = new ReplicatorCommitContext(transaction, (CDOCommitInfo)newCommitInfo);
        commitContext.preWrite();
        boolean success = false;
        try {
            this.handleCommitInfoLock.lock();
            commitContext.write((OMMonitor)new Monitor());
            commitContext.commit((OMMonitor)new Monitor());
            this.setLastCommitTimeStamp(timeStamp);
            this.setLastReplicatedCommitTime(timeStamp);
            success = true;
        }
        finally {
            this.handleCommitInfoLock.unlock();
            commitContext.postCommit(success);
            transaction.close();
        }
    }

    public void handleLockChangeInfo(CDOLockChangeInfo lockChangeInfo) {
        InternalView view;
        block6: {
            CDOLockOwner owner = lockChangeInfo.getLockOwner();
            if (owner == null) {
                return;
            }
            String durableLockingID = owner.getDurableLockingID();
            CDOBranch viewedBranch = lockChangeInfo.getBranch();
            InternalLockManager lockManager = this.getLockingManager();
            IRWLockManager.LockType lockType = lockChangeInfo.getLockType();
            view = null;
            try {
                view = SyncingUtil.openViewWithLockArea(this.replicatorSession, lockManager, viewedBranch, durableLockingID);
                LinkedList<Object> lockables = new LinkedList<Object>();
                CDOLockState[] cDOLockStateArray = lockChangeInfo.getLockStates();
                int n = cDOLockStateArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CDOLockState lockState = cDOLockStateArray[n2];
                    lockables.add(lockState.getLockedObject());
                    ++n2;
                }
                if (lockChangeInfo.getOperation() == CDOLockChangeInfo.Operation.LOCK) {
                    long timeout = 0L;
                    super.lock(view, lockType, lockables, null, false, timeout);
                    break block6;
                }
                if (lockChangeInfo.getOperation() == CDOLockChangeInfo.Operation.UNLOCK) {
                    super.doUnlock(view, lockType, lockables, false);
                    break block6;
                }
                throw new IllegalStateException("Unexpected: " + lockChangeInfo.getOperation());
            }
            catch (Throwable throwable) {
                LifecycleUtil.deactivate(view);
                throw throwable;
            }
        }
        LifecycleUtil.deactivate((Object)view);
    }

    public boolean handleLockArea(IDurableLockingManager.LockArea area) {
        try {
            StoreThreadLocal.setSession(this.replicatorSession);
            this.getLockingManager().updateLockArea(area);
            this.getSessionManager().sendLockNotification(null, CDOLockUtil.createLockChangeInfo());
            return true;
        }
        finally {
            StoreThreadLocal.release();
        }
    }

    public void replicateRaw(CDODataInput in, OMMonitor monitor) throws IOException {
        try {
            long previousCommitTime = this.getLastCommitTimeStamp();
            int fromBranchID = this.lastReplicatedBranchID + 1;
            int toBranchID = in.readInt();
            long fromCommitTime = this.lastReplicatedCommitTime + 1L;
            long toCommitTime = in.readLong();
            StoreThreadLocal.setSession(this.replicatorSession);
            IStoreAccessor.Raw accessor = (IStoreAccessor.Raw)StoreThreadLocal.getAccessor();
            accessor.rawImport(in, fromBranchID, toBranchID, fromCommitTime, toCommitTime, monitor);
            this.replicateRawReviseRevisions();
            this.replicateRawReloadLocks();
            this.replicateRawNotifyClients(this.lastReplicatedCommitTime, toCommitTime, previousCommitTime);
            this.setLastReplicatedBranchID(toBranchID);
            this.setLastReplicatedCommitTime(toCommitTime);
            this.setLastCommitTimeStamp(toCommitTime);
        }
        finally {
            StoreThreadLocal.release();
        }
    }

    @Override
    public void goOnline() {
        if (this.getState() == OFFLINE) {
            LifecycleUtil.activate((Object)this.synchronizer);
        }
    }

    @Override
    public void goOffline() {
        if (this.getState() != OFFLINE) {
            LifecycleUtil.deactivate((Object)this.synchronizer);
            this.setState(OFFLINE);
        }
    }

    private void replicateRawReviseRevisions() {
        InternalCDORevisionCache cache = this.getRevisionManager().getCache();
        for (CDORevision revision : cache.getCurrentRevisions()) {
            cache.removeRevision(revision.getID(), (CDOBranchVersion)revision);
        }
    }

    private void replicateRawReloadLocks() {
        this.getLockingManager().reloadLocks();
    }

    private void replicateRawNotifyClients(long fromCommitTime, long toCommitTime, long previousCommitTime) {
        InternalCDOCommitInfoManager manager = this.getCommitInfoManager();
        InternalSessionManager sessionManager = this.getSessionManager();
        Map<CDOBranch, TimeRange> branches = this.replicateRawGetBranches(fromCommitTime, toCommitTime);
        for (Map.Entry<CDOBranch, TimeRange> entry : branches.entrySet()) {
            CDOBranch branch = entry.getKey();
            TimeRange range = entry.getValue();
            fromCommitTime = range.getTime1();
            toCommitTime = range.getTime2();
            CDOBranchPoint startPoint = branch.getPoint(fromCommitTime);
            CDOBranchPoint endPoint = branch.getPoint(toCommitTime);
            CDOChangeSetData changeSet = this.getChangeSet(startPoint, endPoint);
            List newPackages = Collections.emptyList();
            List newObjects = changeSet.getNewObjects();
            List changedObjects = changeSet.getChangedObjects();
            List detachedObjects = changeSet.getDetachedObjects();
            CDOCommitData data = CDOCommitInfoUtil.createCommitData(newPackages, (List)newObjects, (List)changedObjects, (List)detachedObjects);
            String comment = "<replicate raw commits>";
            CDOCommitInfo commitInfo = manager.createCommitInfo(branch, toCommitTime, previousCommitTime, "CDO_SYSTEM", comment, data);
            CDOProtocol.CommitNotificationInfo info = new CDOProtocol.CommitNotificationInfo();
            info.setSender((CDOCommonSession)this.replicatorSession);
            info.setCommitInfo(commitInfo);
            info.setClearResourcePathCache(true);
            sessionManager.sendCommitNotification(info);
        }
        CDOLockChangeInfo lockChangeInfo = CDOLockUtil.createLockChangeInfo();
        sessionManager.sendLockNotification(this.replicatorSession, lockChangeInfo);
    }

    private Map<CDOBranch, TimeRange> replicateRawGetBranches(long fromCommitTime, long toCommitTime) {
        final HashMap<CDOBranch, TimeRange> branches = new HashMap<CDOBranch, TimeRange>();
        CDOCommitInfoHandler handler = new CDOCommitInfoHandler(){

            public void handleCommitInfo(CDOCommitInfo commitInfo) {
                CDOBranch branch = commitInfo.getBranch();
                long timeStamp = commitInfo.getTimeStamp();
                TimeRange range = (TimeRange)branches.get(branch);
                if (range == null) {
                    branches.put(branch, new TimeRange(timeStamp));
                } else {
                    range.update(timeStamp);
                }
            }
        };
        this.getCommitInfoManager().getCommitInfos(null, fromCommitTime, toCommitTime, handler);
        return branches;
    }

    @Override
    public void notifyWriteAccessHandlers(ITransaction transaction, IStoreAccessor.CommitContext commitContext, boolean beforeCommit, OMMonitor monitor) {
        if (beforeCommit && commitContext.getNewPackageUnits().length != 0) {
            throw new IllegalStateException("Synchronizable repositories don't support dynamic addition of new packages. Use IRepository.setInitialPackages() instead.");
        }
        super.notifyWriteAccessHandlers(transaction, commitContext, beforeCommit, monitor);
    }

    @Override
    public abstract InternalCommitContext createCommitContext(InternalTransaction var1);

    protected InternalCommitContext createNormalCommitContext(InternalTransaction transaction) {
        return super.createCommitContext(transaction);
    }

    protected InternalCommitContext createWriteThroughCommitContext(InternalTransaction transaction) {
        return new WriteThroughCommitContext(transaction);
    }

    @Override
    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.synchronizer, "synchronizer");
    }

    @Override
    protected void doActivate() throws Exception {
        InternalStore store;
        super.doActivate();
        InternalCDORevisionCache cache = this.getRevisionManager().getCache();
        if (cache instanceof AbstractCDORevisionCache) {
            ((AbstractCDORevisionCache)cache).setBranchManager((CDOBranchManager)this.getBranchManager());
        }
        if (!(store = this.getStore()).isFirstStart()) {
            Map<String, String> map = store.getPersistentProperties(Collections.singleton(PROP_GRACEFULLY_SHUT_DOWN));
            if (!map.containsKey(PROP_GRACEFULLY_SHUT_DOWN)) {
                this.setReplicationCountersToLatest();
            } else {
                HashSet<String> names = new HashSet<String>();
                names.add(PROP_LAST_REPLICATED_BRANCH_ID);
                names.add(PROP_LAST_REPLICATED_COMMIT_TIME);
                map = store.getPersistentProperties(names);
                this.setLastReplicatedBranchID(Integer.valueOf(map.get(PROP_LAST_REPLICATED_BRANCH_ID)));
                this.setLastReplicatedCommitTime(Long.valueOf(map.get(PROP_LAST_REPLICATED_COMMIT_TIME)));
            }
        }
        store.removePersistentProperties(Collections.singleton(PROP_GRACEFULLY_SHUT_DOWN));
        CDOCommonRepository.Type type = this.getType();
        if (type == MASTER) {
            this.setState(ONLINE);
        } else {
            if (this.hasBeenReplicated()) {
                this.setState(OFFLINE);
            } else if (type == BACKUP && this.getLastReplicatedCommitTime() == 0L) {
                boolean usedToBeMaster;
                boolean bl = usedToBeMaster = this.getRootResourceID() != null;
                if (usedToBeMaster) {
                    this.setLastReplicatedCommitTime(this.getLastCommitTimeStamp());
                }
            }
            this.startSynchronization();
        }
    }

    @Override
    protected void doDeactivate() throws Exception {
        this.stopSynchronization();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(PROP_LAST_REPLICATED_BRANCH_ID, Integer.toString(this.lastReplicatedBranchID));
        map.put(PROP_LAST_REPLICATED_COMMIT_TIME, Long.toString(this.lastReplicatedCommitTime));
        map.put(PROP_GRACEFULLY_SHUT_DOWN, Boolean.TRUE.toString());
        InternalStore store = this.getStore();
        store.setPersistentProperties(map);
        super.doDeactivate();
    }

    protected void startSynchronization() {
        this.replicatorSession = this.getSessionManager().openSession(null);
        this.replicatorSession.options().setPassiveUpdateEnabled(false);
        this.replicatorSession.options().setLockNotificationMode(CDOCommonSession.Options.LockNotificationMode.OFF);
        this.synchronizer.setLocalRepository(this);
        this.synchronizer.activate();
    }

    protected void stopSynchronization() {
        if (this.synchronizer != null) {
            this.synchronizer.deactivate();
        }
    }

    @Override
    protected void setPostActivateState() {
    }

    protected void setReplicationCountersToLatest() {
        this.setLastReplicatedBranchID(this.getStore().getLastBranchID());
        this.setLastReplicatedCommitTime(this.getStore().getLastNonLocalCommitTime());
    }

    @Override
    protected void initRootResource() {
        if (this.getType() == MASTER) {
            super.initRootResource();
        }
    }

    @Override
    public CDOSessionProtocol.LockObjectsResult lock(InternalView view, IRWLockManager.LockType lockType, List<CDORevisionKey> revisionKeys, boolean recursive, long timeout) {
        if (view.getBranch().isLocal()) {
            return super.lock(view, lockType, revisionKeys, recursive, timeout);
        }
        if (this.getState() != ONLINE) {
            throw new CDOException("Cannot lock in a non-local branch when clone is not connected to master");
        }
        return this.lockThrough(view, lockType, revisionKeys, false, timeout);
    }

    private CDOSessionProtocol.LockObjectsResult lockOnMaster(InternalView view, IRWLockManager.LockType type, List<CDORevisionKey> revKeys, boolean recursive, long timeout) throws InterruptedException {
        InternalCDOSession remoteSession = this.getSynchronizer().getRemoteSession();
        CDOSessionProtocol sessionProtocol = remoteSession.getSessionProtocol();
        String areaID = view.getDurableLockingID();
        if (areaID == null) {
            throw new IllegalStateException("Durable locking is not enabled for view " + view);
        }
        CDOSessionProtocol.LockObjectsResult masterLockingResult = sessionProtocol.delegateLockObjects(areaID, revKeys, view.getBranch(), type, recursive, timeout);
        if (masterLockingResult.isSuccessful() && masterLockingResult.isWaitForUpdate()) {
            if (!this.getSynchronizer().getRemoteSession().options().isPassiveUpdateEnabled()) {
                throw new AssertionError((Object)"Master lock result requires clone to wait, but clone does not have passiveUpdates enabled.");
            }
            long requiredTimestamp = masterLockingResult.getRequiredTimestamp();
            if (!remoteSession.waitForUpdate(requiredTimestamp, 10000L)) {
                throw new TimeoutRuntimeException();
            }
        }
        return masterLockingResult;
    }

    private CDOSessionProtocol.LockObjectsResult lockThrough(InternalView view, IRWLockManager.LockType type, List<CDORevisionKey> keys, boolean recursive, long timeout) {
        try {
            CDOSessionProtocol.LockObjectsResult masterLockingResult = this.lockOnMaster(view, type, keys, recursive, timeout);
            if (!masterLockingResult.isSuccessful()) {
                return masterLockingResult;
            }
            CDOSessionProtocol.LockObjectsResult localLockingResult = super.lock(view, type, keys, recursive, timeout);
            return localLockingResult;
        }
        catch (InterruptedException ex) {
            throw WrappedException.wrap((Exception)ex);
        }
    }

    @Override
    public CDOSessionProtocol.UnlockObjectsResult unlock(InternalView view, IRWLockManager.LockType lockType, List<CDOID> objectIDs, boolean recursive) {
        if (view.getBranch().isLocal()) {
            super.unlock(view, lockType, objectIDs, recursive);
        }
        if (this.getState() != ONLINE) {
            throw new CDOException("Cannot unlock in a non-local branch when clone is not connected to master");
        }
        return this.unlockThrough(view, lockType, objectIDs, recursive);
    }

    private void unlockOnMaster(InternalView view, IRWLockManager.LockType lockType, List<CDOID> objectIDs, boolean recursive) {
        InternalCDOSession remoteSession = this.getSynchronizer().getRemoteSession();
        CDOSessionProtocol sessionProtocol = remoteSession.getSessionProtocol();
        String lockAreaID = view.getDurableLockingID();
        if (lockAreaID == null) {
            throw new IllegalStateException("Durable locking is not enabled for view " + view);
        }
        sessionProtocol.delegateUnlockObjects(lockAreaID, objectIDs, lockType, recursive);
    }

    private CDOSessionProtocol.UnlockObjectsResult unlockThrough(InternalView view, IRWLockManager.LockType lockType, List<CDOID> objectIDs, boolean recursive) {
        this.unlockOnMaster(view, lockType, objectIDs, recursive);
        return super.unlock(view, lockType, objectIDs, recursive);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class CommitContextData
    implements CDOCommitData {
        private InternalCommitContext commitContext;
        private CDOChangeKindCache changeKindCache;

        public CommitContextData(InternalCommitContext commitContext) {
            this.commitContext = commitContext;
        }

        public boolean isEmpty() {
            return false;
        }

        public CDOChangeSetData copy() {
            throw new UnsupportedOperationException();
        }

        public void merge(CDOChangeSetData changeSetData) {
            throw new UnsupportedOperationException();
        }

        public List<CDOPackageUnit> getNewPackageUnits() {
            final InternalCDOPackageUnit[] newPackageUnits = this.commitContext.getNewPackageUnits();
            return new IndexedList<CDOPackageUnit>(){

                public CDOPackageUnit get(int index) {
                    return newPackageUnits[index];
                }

                public int size() {
                    return newPackageUnits.length;
                }
            };
        }

        public List<CDOIDAndVersion> getNewObjects() {
            final InternalCDORevision[] newObjects = this.commitContext.getNewObjects();
            return new IndexedList<CDOIDAndVersion>(){

                public CDOIDAndVersion get(int index) {
                    return newObjects[index];
                }

                public int size() {
                    return newObjects.length;
                }
            };
        }

        public List<CDORevisionKey> getChangedObjects() {
            final InternalCDORevisionDelta[] changedObjects = this.commitContext.getDirtyObjectDeltas();
            return new IndexedList<CDORevisionKey>(){

                public CDORevisionKey get(int index) {
                    return changedObjects[index];
                }

                public int size() {
                    return changedObjects.length;
                }
            };
        }

        public List<CDOIDAndVersion> getDetachedObjects() {
            final CDOID[] detachedObjects = this.commitContext.getDetachedObjects();
            return new IndexedList<CDOIDAndVersion>(){

                public CDOIDAndVersion get(int index) {
                    return CDOIDUtil.createIDAndVersion((CDOID)detachedObjects[index], (int)0);
                }

                public int size() {
                    return detachedObjects.length;
                }
            };
        }

        public synchronized Map<CDOID, CDOChangeKind> getChangeKinds() {
            if (this.changeKindCache == null) {
                this.changeKindCache = new CDOChangeKindCache((CDOChangeSetData)this);
            }
            return this.changeKindCache;
        }

        public CDOChangeKind getChangeKind(CDOID id) {
            return this.getChangeKinds().get(id);
        }
    }

    private static final class TimeRange {
        private long time1;
        private long time2;

        public TimeRange(long time) {
            this.time1 = time;
            this.time2 = time;
        }

        public void update(long time) {
            if (time < this.time1) {
                this.time1 = time;
            }
            if (time > this.time2) {
                this.time2 = time;
            }
        }

        public long getTime1() {
            return this.time1;
        }

        public long getTime2() {
            return this.time2;
        }

        public String toString() {
            return "[" + CDOCommonUtil.formatTimeStamp((long)this.time1) + " - " + CDOCommonUtil.formatTimeStamp((long)this.time1) + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class WriteThroughCommitContext
    extends TransactionCommitContext {
        private static final int ARTIFICIAL_VIEW_ID = 0;
        private CDOSessionProtocol.CommitTransactionResult result;

        public WriteThroughCommitContext(InternalTransaction transaction) {
            super(transaction);
        }

        @Override
        public void preWrite() {
        }

        @Override
        public void write(OMMonitor monitor) {
        }

        @Override
        public void commit(OMMonitor monitor) {
            final CommitContextData commitData = new CommitContextData(this);
            InternalCDOTransaction.InternalCDOCommitContext ctx = new InternalCDOTransaction.InternalCDOCommitContext(){

                public boolean isPartialCommit() {
                    return false;
                }

                public Map<CDOID, CDORevisionDelta> getRevisionDeltas() {
                    throw new UnsupportedOperationException();
                }

                public List<CDOPackageUnit> getNewPackageUnits() {
                    return commitData.getNewPackageUnits();
                }

                public Map<CDOID, CDOObject> getNewObjects() {
                    throw new UnsupportedOperationException();
                }

                public Collection<CDOLockState> getLocksOnNewObjects() {
                    CDOLockState[] locksOnNewObjectsArr = WriteThroughCommitContext.this.getLocksOnNewObjects();
                    List<CDOLockState> locksOnNewObjects = Arrays.asList(locksOnNewObjectsArr);
                    return locksOnNewObjects;
                }

                public Collection<CDOLob<?>> getLobs() {
                    return Collections.emptySet();
                }

                public Map<CDOID, CDOObject> getDirtyObjects() {
                    throw new UnsupportedOperationException();
                }

                public Map<CDOID, CDOObject> getDetachedObjects() {
                    throw new UnsupportedOperationException();
                }

                public void preCommit() {
                    throw new UnsupportedOperationException();
                }

                public void postCommit(CDOSessionProtocol.CommitTransactionResult result) {
                    throw new UnsupportedOperationException();
                }

                public InternalCDOTransaction getTransaction() {
                    return null;
                }

                public CDOCommitData getCommitData() {
                    return commitData;
                }

                public int getViewID() {
                    return 0;
                }

                public String getUserID() {
                    return WriteThroughCommitContext.this.getUserID();
                }

                public boolean isAutoReleaseLocks() {
                    return WriteThroughCommitContext.this.isAutoReleaseLocksEnabled();
                }

                public String getCommitComment() {
                    return WriteThroughCommitContext.this.getCommitComment();
                }

                public CDOBranch getBranch() {
                    return WriteThroughCommitContext.this.getTransaction().getBranch();
                }
            };
            CDOSessionProtocol sessionProtocol = SynchronizableRepository.this.getSynchronizer().getRemoteSession().getSessionProtocol();
            this.result = sessionProtocol.commitDelegation(ctx, monitor);
            String rollbackMessage = this.result.getRollbackMessage();
            if (rollbackMessage != null) {
                throw new TransactionException(rollbackMessage);
            }
            long timeStamp = this.result.getTimeStamp();
            this.addIDMappings(this.result.getIDMappings());
            this.applyIDMappings((OMMonitor)new Monitor());
            try {
                SynchronizableRepository.this.writeThroughCommitLock.lock();
                super.preWrite();
                super.write((OMMonitor)new Monitor());
                super.commit((OMMonitor)new Monitor());
            }
            finally {
                SynchronizableRepository.this.writeThroughCommitLock.unlock();
            }
            SynchronizableRepository.this.setLastCommitTimeStamp(timeStamp);
            SynchronizableRepository.this.setLastReplicatedCommitTime(timeStamp);
            SynchronizableRepository.this.getSynchronizer().getRemoteSession().setLastUpdateTime(timeStamp);
        }

        @Override
        protected long[] createTimeStamp(OMMonitor monitor) {
            long timeStamp = this.result.getTimeStamp();
            long previousTimeStamp = this.result.getPreviousTimeStamp();
            this.result = null;
            InternalRepository repository = this.getTransaction().getSession().getManager().getRepository();
            repository.forceCommitTimeStamp(timeStamp, monitor);
            return new long[]{timeStamp, previousTimeStamp};
        }

        @Override
        protected void lockObjects() throws InterruptedException {
        }

        private void addIDMappings(Map<CDOID, CDOID> idMappings) {
            for (Map.Entry<CDOID, CDOID> idMapping : idMappings.entrySet()) {
                CDOID oldID = idMapping.getKey();
                CDOID newID = idMapping.getValue();
                this.addIDMapping(oldID, newID);
            }
        }
    }
}

