/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.service.types.helper.advice;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.papyrus.sysml.service.types.element.SysMLElementTypes;
import org.eclipse.papyrus.uml.service.types.utils.EMFUtil;
import org.eclipse.uml2.uml.Actor;
import org.eclipse.uml2.uml.Association;

public class PackageEditHelperAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getBeforeCreateRelationshipCommand(CreateRelationshipRequest request) {
        IElementType type = request.getElementType();
        if (this.hasSuperType(type, (IElementType)SysMLElementTypes.ASSOCIATION)) {
            EObject target = request.getTarget();
            if (target instanceof Association || target == null) {
                return UnexecutableCommand.INSTANCE;
            }
            if (!(this.hasSuperType(type, (IElementType)SysMLElementTypes.ASSOCIATION_NONE_DIRECTED) || this.hasSuperType(type, (IElementType)SysMLElementTypes.ASSOCIATION_COMPOSITE_DIRECTED) || this.hasSuperType(type, (IElementType)SysMLElementTypes.ASSOCIATION_SHARED_DIRECTED))) {
                if (EMFUtil.isReadOnly((EObject)target)) {
                    return UnexecutableCommand.INSTANCE;
                }
                if (target instanceof Actor) {
                    return UnexecutableCommand.INSTANCE;
                }
            }
        }
        return super.getBeforeCreateRelationshipCommand(request);
    }

    protected boolean hasSuperType(IElementType elementType, IElementType typeToTest) {
        if (elementType == null || typeToTest == null) {
            return false;
        }
        if (elementType.equals(typeToTest)) {
            return true;
        }
        List<IElementType> superTypes = Arrays.asList(elementType.getAllSuperTypes());
        return superTypes.contains(typeToTest);
    }
}

