/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.service.types.helper.advice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.sysml.blocks.NestedConnectorEnd;
import org.eclipse.papyrus.sysml.service.types.command.SetNestedPathCommand;
import org.eclipse.papyrus.sysml.service.types.element.SysMLElementTypes;
import org.eclipse.papyrus.sysml.service.types.utils.ConnectorUtils;
import org.eclipse.papyrus.uml.service.types.utils.RequestParameterUtils;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ConnectorEditHelperAdvice
extends AbstractEditHelperAdvice {
    private ConnectorUtils utils = new ConnectorUtils();

    protected ICommand getBeforeReorientRelationshipCommand(ReorientRelationshipRequest request) {
        CompositeCommand compositeCommand = new CompositeCommand("Destroy Connector View Command");
        EObject editedElement = request.getRelationship();
        if (editedElement instanceof Connector && this.applySysMLRules(((Connector)editedElement).getOwner())) {
            Connector connector = (Connector)editedElement;
            int reorientDirection = request.getDirection();
            Edge reorientedEdgeView = RequestParameterUtils.getReconnectedEdge((IEditCommandRequest)request);
            View newEndView = RequestParameterUtils.getReconnectedEndView((IEditCommandRequest)request);
            View oppositeEndView = null;
            if (reorientedEdgeView != null) {
                oppositeEndView = reorientDirection == 1 ? reorientedEdgeView.getTarget() : reorientedEdgeView.getSource();
            }
            List<Property> newNestedPath = null;
            newNestedPath = reorientedEdgeView != null && newEndView != null ? this.utils.getNestedPropertyPath(newEndView, oppositeEndView) : (List<Property>)request.getParameter(ConnectorUtils.NESTED_CONNECTOR_END_PATH);
            Set viewsToDestroy = this.utils.getViewsRepresentingConnector(connector);
            for (Edge current : viewsToDestroy) {
                List<Property> oldNestedPath;
                if (current == reorientedEdgeView) continue;
                View oldEndView = null;
                if (reorientDirection == 1) {
                    oldEndView = current.getSource();
                } else if (reorientDirection == 2) {
                    oldEndView = current.getTarget();
                }
                if (oppositeEndView == null || newNestedPath.equals(oldNestedPath = this.utils.getNestedPropertyPath(oldEndView, oppositeEndView))) continue;
                DestroyElementRequest destroyRequest = new DestroyElementRequest(request.getEditingDomain(), (EObject)current, false);
                IElementEditService commandProvider = ElementEditServiceUtils.getCommandProvider((Object)current);
                compositeCommand.add((IUndoableOperation)commandProvider.getEditCommand((IEditCommandRequest)destroyRequest));
            }
            if (!compositeCommand.isEmpty()) {
                return compositeCommand;
            }
        }
        return null;
    }

    protected boolean applySysMLRules(Element connectorOwner) {
        return connectorOwner.getApplicableStereotype("SysML::Blocks::Block") != null;
    }

    protected ICommand getAfterReorientRelationshipCommand(ReorientRelationshipRequest request) {
        ICommand defaultCommand = super.getAfterReorientRelationshipCommand(request);
        int reorientDirection = request.getDirection();
        Connector connector = (Connector)request.getRelationship();
        if (((ISpecializationType)SysMLElementTypes.BLOCK).getMatcher().matches(connector.eContainer())) {
            List<Property> tmpNestedPath = null;
            Edge reorientedEdgeView = RequestParameterUtils.getReconnectedEdge((IEditCommandRequest)request);
            View newEndView = RequestParameterUtils.getReconnectedEndView((IEditCommandRequest)request);
            View oppositeEndView = null;
            if (reorientedEdgeView != null) {
                oppositeEndView = reorientDirection == 1 ? reorientedEdgeView.getTarget() : reorientedEdgeView.getSource();
                Assert.isNotNull((Object)oppositeEndView);
                Assert.isNotNull((Object)newEndView);
                if (newEndView != null && oppositeEndView != null) {
                    if (this.utils.isCrossingEncapsulation(newEndView, oppositeEndView) || this.utils.isCrossingEncapsulation(oppositeEndView, newEndView)) {
                        return UnexecutableCommand.INSTANCE;
                    }
                    tmpNestedPath = this.utils.getNestedPropertyPath(newEndView, oppositeEndView);
                }
            } else {
                tmpNestedPath = (List<Property>)request.getParameter(ConnectorUtils.NESTED_CONNECTOR_END_PATH);
                if (ConnectorUtils.isCrossingEncapuslation(tmpNestedPath)) {
                    return UnexecutableCommand.INSTANCE;
                }
            }
            ArrayList<ConnectableElement> oppositeFullNestedPath = new ArrayList<ConnectableElement>();
            ArrayList<Property> newFullNestedPath = new ArrayList<Property>(tmpNestedPath);
            Property newRole = (Property)request.getNewRelationshipEnd();
            ConnectorEnd oppositeEnd = reorientDirection == 1 ? (ConnectorEnd)((Connector)request.getRelationship()).getEnds().get(1) : (ConnectorEnd)((Connector)request.getRelationship()).getEnds().get(0);
            NestedConnectorEnd nestedConnectorEnd = (NestedConnectorEnd)UMLUtil.getStereotypeApplication((Element)oppositeEnd, NestedConnectorEnd.class);
            if (nestedConnectorEnd != null) {
                oppositeFullNestedPath.addAll((Collection<ConnectableElement>)nestedConnectorEnd.getPropertyPath());
            }
            oppositeFullNestedPath.add(oppositeEnd.getRole());
            newFullNestedPath.add(newRole);
            int tmpNestedPathDirection = reorientDirection == 1 ? 1 : 2;
            defaultCommand = CompositeCommand.compose((ICommand)defaultCommand, (ICommand)new SetNestedPathCommand("Set connector nested source path", request.getRelationship(), (IEditCommandRequest)request, tmpNestedPath, tmpNestedPathDirection));
        }
        return defaultCommand;
    }
}

