/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.sam.arg.arg.diagram.providers;

import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.opencert.sam.arg.arg.diagram.part.ArgDiagramEditorPlugin;
import org.eclipse.opencert.sam.arg.arg.diagram.part.ArgVisualIDRegistry;

public class ArgValidationProvider {
    private static boolean constraintsActive = false;

    public static boolean shouldConstraintsBePrivate() {
        return false;
    }

    public static void runWithConstraints(TransactionalEditingDomain editingDomain, Runnable operation) {
        final Runnable op = operation;
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    constraintsActive = true;
                    op.run();
                }
                finally {
                    constraintsActive = false;
                }
            }
        };
        if (editingDomain != null) {
            try {
                editingDomain.runExclusive(task);
            }
            catch (Exception e) {
                ArgDiagramEditorPlugin.getInstance().logError("Validation failed", e);
            }
        } else {
            task.run();
        }
    }

    static boolean isInDefaultEditorContext(Object object) {
        if (ArgValidationProvider.shouldConstraintsBePrivate() && !constraintsActive) {
            return false;
        }
        if (object instanceof View) {
            return constraintsActive && "Arg".equals(ArgVisualIDRegistry.getModelID((View)object));
        }
        return true;
    }
}

