/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.providers;

import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.widgets.editors.AbstractEditor;
import org.eclipse.papyrus.infra.widgets.editors.ICommitListener;
import org.eclipse.papyrus.infra.widgets.editors.StringEditor;
import org.eclipse.papyrus.infra.widgets.providers.EncapsulatedContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.PatternViewerFilter;
import org.eclipse.swt.widgets.Composite;

public class FilteredContentProvider
extends EncapsulatedContentProvider {
    protected StructuredViewer viewer;
    private StringEditor filterPattern;
    private PatternViewerFilter filter;
    public static final String BASE_PATTERN = "*";
    protected boolean showIfHasVisibleParent = false;

    public FilteredContentProvider(IStructuredContentProvider encapsulated) {
        super(encapsulated);
    }

    public FilteredContentProvider() {
    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        if (viewer instanceof StructuredViewer) {
            this.viewer = (StructuredViewer)viewer;
            this.updateFilter();
        }
    }

    private void updateFilter() {
        if (this.viewer != null && this.filterPattern != null) {
            this.addViewerFilter(this.viewer, this.filter);
        }
    }

    @Override
    public void createBefore(Composite parent) {
        super.createBefore(parent);
        this.filterPattern = new StringEditor(parent, 0, "Filter: ");
        this.filterPattern.setValidateOnDelay(true);
        this.filterPattern.setValue(BASE_PATTERN);
        this.filter = this.getViewerFilter();
        this.filterPattern.addCommitListener(new ICommitListener(){

            @Override
            public void commit(AbstractEditor editor) {
                FilteredContentProvider.this.filter.setPattern((String)FilteredContentProvider.this.filterPattern.getValue());
                if (FilteredContentProvider.this.viewer != null) {
                    FilteredContentProvider.this.viewer.refresh();
                }
            }
        });
        this.updateFilter();
    }

    protected PatternViewerFilter getViewerFilter() {
        PatternViewerFilter filter = new PatternViewerFilter();
        filter.setStrict(false);
        filter.setPattern(BASE_PATTERN);
        filter.setShowIfHasVisibleParent(this.showIfHasVisibleParent);
        return filter;
    }
}

