/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooling.runtime.linklf;

import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;

public abstract class AbsoluteBendpointsConvention {
    private static AbsoluteBendpointsConvention ourInstance;

    public static AbsoluteBendpointsConvention getInstance() {
        if (ourInstance == null) {
            ourInstance = new ForAllLinks();
        }
        return ourInstance;
    }

    public abstract RelativeBendpoint createAbsoluteBendpointStoredAsRelative(Point var1);

    public abstract boolean isAbsoluteStoredAsRelative(RelativeBendpoint var1);

    public abstract Bendpoint d2dBendpoint(RelativeBendpoint var1, Connection var2, float var3);

    public abstract boolean hasAbsoluteStoredAsRelativeBendpoints(Edge var1);

    public abstract PointList getPointList(Edge var1, Object var2);

    private static abstract class ConventionBase
    extends AbsoluteBendpointsConvention {
        private static final int MAGIC = -643984;

        private ConventionBase() {
        }

        @Override
        public RelativeBendpoint createAbsoluteBendpointStoredAsRelative(Point point) {
            return new RelativeBendpoint(point.x, point.y, -643984, -643984);
        }

        @Override
        public boolean isAbsoluteStoredAsRelative(RelativeBendpoint modelBP) {
            return modelBP.getTargetX() == -643984 && modelBP.getTargetY() == -643984;
        }

        @Override
        public Bendpoint d2dBendpoint(RelativeBendpoint modelBP, Connection connection, float weight) {
            if (this.isAbsoluteStoredAsRelative(modelBP)) {
                return new AbsoluteBendpoint(modelBP.getSourceX(), modelBP.getSourceY());
            }
            return null;
        }

        @Override
        public PointList getPointList(Edge edge, Object linkConstraint) {
            PointList result = new PointList();
            List d2dBendpoints = linkConstraint instanceof List ? (List)linkConstraint : Collections.emptyList();
            RelativeBendpoints allModelBendpoints = (RelativeBendpoints)edge.getBendpoints();
            List modelBendpoints = allModelBendpoints.getPoints();
            int i = 0;
            while (i < modelBendpoints.size()) {
                Object nextD2d;
                RelativeBendpoint nextModel = (RelativeBendpoint)modelBendpoints.get(i);
                Point nextPoint = this.getLocation(nextModel, nextD2d = d2dBendpoints.size() > i ? d2dBendpoints.get(i) : null);
                if (nextPoint == null) {
                    throw new IllegalStateException("Can't extract location: modelBP: " + nextModel + ", d2dBP: " + nextD2d);
                }
                result.addPoint(nextPoint);
                ++i;
            }
            return result;
        }

        protected static org.eclipse.draw2d.RelativeBendpoint newRelativeBendpointD2d(RelativeBendpoint modelBP, Connection connection, float weight) {
            org.eclipse.draw2d.RelativeBendpoint rbp = new org.eclipse.draw2d.RelativeBendpoint(connection);
            rbp.setRelativeDimensions(new Dimension(modelBP.getSourceX(), modelBP.getSourceY()), new Dimension(modelBP.getTargetX(), modelBP.getTargetY()));
            rbp.setWeight(weight);
            return rbp;
        }

        protected abstract Point getLocation(RelativeBendpoint var1, Object var2);
    }

    protected static class ForAllLinks
    extends ConventionBase {
        protected ForAllLinks() {
        }

        @Override
        public Bendpoint d2dBendpoint(RelativeBendpoint modelBP, Connection connection, float weight) {
            Object result = super.d2dBendpoint(modelBP, connection, weight);
            if (result == null) {
                org.eclipse.draw2d.RelativeBendpoint rbp = ForAllLinks.newRelativeBendpointD2d(modelBP, connection, weight);
                result = new RelativeBendpointWrapper(rbp, connection);
            }
            return result;
        }

        @Override
        public boolean hasAbsoluteStoredAsRelativeBendpoints(Edge edge) {
            List bendpoints = ((RelativeBendpoints)edge.getBendpoints()).getPoints();
            return !bendpoints.isEmpty();
        }

        @Override
        protected Point getLocation(RelativeBendpoint modelBendpoint, Object d2dBendpoint) {
            if (this.isAbsoluteStoredAsRelative(modelBendpoint)) {
                return new Point(modelBendpoint.getSourceX(), modelBendpoint.getSourceY());
            }
            if (d2dBendpoint instanceof AbsoluteBendpoint) {
                AbsoluteBendpoint wrapper = (AbsoluteBendpoint)d2dBendpoint;
                return wrapper.getLocation();
            }
            throw new IllegalStateException("I had to create AbsoluteBendpointWrapper for this: " + modelBendpoint + ", " + d2dBendpoint);
        }

        private static class RelativeBendpointWrapper
        extends AbsoluteBendpoint {
            private Point myLocation = null;
            private org.eclipse.draw2d.RelativeBendpoint myRelativeBendpoint;
            private Connection myConnection;

            public RelativeBendpointWrapper(org.eclipse.draw2d.RelativeBendpoint relativeBendpoint, Connection conn) {
                super(new Point());
                this.myRelativeBendpoint = relativeBendpoint;
                this.myConnection = conn;
            }

            public Point getLocation() {
                if (this.myLocation == null && this.isReadyToComputeLocation()) {
                    this.myLocation = new Point(this.myRelativeBendpoint.getLocation());
                    this.myRelativeBendpoint = null;
                    this.myConnection = null;
                }
                return this.myLocation != null ? this.myLocation : this.myRelativeBendpoint.getLocation();
            }

            private boolean isReadyToComputeLocation() {
                if (this.myConnection == null) {
                    return false;
                }
                ConnectionAnchor source = this.myConnection.getSourceAnchor();
                ConnectionAnchor target = this.myConnection.getTargetAnchor();
                if (source == null || target == null) {
                    return false;
                }
                return this.hasLocation(source.getReferencePoint()) && this.hasLocation(target.getReferencePoint());
            }

            private boolean hasLocation(Point point) {
                return point != null && (point.x() != 0 || point.y() != 0);
            }

            public int x() {
                return this.getLocation().x();
            }

            public int y() {
                return this.getLocation().y();
            }
        }
    }

    protected static class OnlyForNewLinks
    extends ConventionBase {
        protected OnlyForNewLinks() {
        }

        @Override
        public Bendpoint d2dBendpoint(RelativeBendpoint modelBP, Connection connection, float weight) {
            Bendpoint result = super.d2dBendpoint(modelBP, connection, weight);
            if (result == null) {
                result = OnlyForNewLinks.newRelativeBendpointD2d(modelBP, connection, weight);
            }
            return result;
        }

        @Override
        public boolean hasAbsoluteStoredAsRelativeBendpoints(Edge edge) {
            List bendpoints = ((RelativeBendpoints)edge.getBendpoints()).getPoints();
            for (Object o : bendpoints) {
                if (!(o instanceof RelativeBendpoint) || !this.isAbsoluteStoredAsRelative((RelativeBendpoint)o)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected Point getLocation(RelativeBendpoint modelBendpoint, Object d2dbendpoint) {
            if (this.isAbsoluteStoredAsRelative(modelBendpoint)) {
                return new Point(modelBendpoint.getSourceX(), modelBendpoint.getSourceY());
            }
            if (d2dbendpoint instanceof Bendpoint) {
                return ((Bendpoint)d2dbendpoint).getLocation();
            }
            return null;
        }
    }
}

