/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.core.controlmode;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDExternal;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.spi.cdo.CDOStore;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.IdentityCommand;
import org.eclipse.papyrus.cdo.internal.core.Activator;
import org.eclipse.papyrus.cdo.internal.core.CDOUtils;
import org.eclipse.papyrus.cdo.internal.core.controlmode.CDOProxyManager;
import org.eclipse.papyrus.cdo.internal.core.l10n.Messages;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequest;
import org.eclipse.papyrus.infra.services.controlmode.commands.AbstractControlCommand;
import org.eclipse.papyrus.infra.services.controlmode.participants.IControlCommandParticipant;
import org.eclipse.papyrus.infra.services.controlmode.participants.IUncontrolCommandParticipant;

public class CDOControlModeParticipant
implements IControlCommandParticipant,
IUncontrolCommandParticipant {
    private static final Set<CDOState> TEMPORARY_ID_STATES = EnumSet.of(CDOState.TRANSIENT, CDOState.NEW);
    private List<EObject> objectsToClearResource;

    public String getID() {
        return CDOControlModeParticipant.class.getName();
    }

    public int getPriority() {
        return 255;
    }

    public boolean provideControlCommand(ControlModeRequest request) {
        return this.isCDOResource(request);
    }

    private boolean isCDOResource(ControlModeRequest request) {
        return CDOUtils.isCDOURI(request.getSourceURI());
    }

    public boolean provideUnControlCommand(ControlModeRequest request) {
        return this.isCDOResource(request);
    }

    public ICommand getPreControlCommand(ControlModeRequest request) {
        return IdentityCommand.INSTANCE;
    }

    public ICommand getPostControlCommand(ControlModeRequest request) {
        return new AbstractCDOControlCommand(request){

            @Override
            protected void buildUpdates(ControlModeRequest request, IUpdate.Collector updates) {
                CDOControlModeParticipant.this.collectProxyCrossReferenceUpdates(updates, (ResourceSet)request.getModelSet(), request.getNewURI());
            }
        };
    }

    public IUpdate getProxyCrossReferencesUpdate(Resource resource) {
        CompoundUpdate result = new CompoundUpdate();
        this.collectProxyCrossReferenceUpdates(result, resource.getResourceSet(), resource.getURI());
        return result;
    }

    private void collectProxyCrossReferenceUpdates(IUpdate.Collector updates, ResourceSet resourceSet, URI unitURI) {
        for (EObject object : CDOControlModeParticipant.getAllPersistentSubunitContents(resourceSet, unitURI)) {
            CDOIDExternal proxy = null;
            for (EStructuralFeature.Setting next : this.getExternalCrossReferences(object)) {
                if (proxy == null) {
                    proxy = CDOIDUtil.createExternal((String)CDOProxyManager.createPapyrusCDOURI(object));
                }
                updates.add(new ControlUpdate(next, object, (CDOID)proxy));
            }
        }
    }

    public IUpdate getProxyCrossReferencesUpdate(final EObject owner, final EReference crossReference) {
        IUpdate result = IUpdate.EMPTY;
        final CDOStore[] store = new CDOStore[1];
        EContentsEList.FeatureListIterator xrefs = CDOUtils.iterator(owner, (EStructuralFeature)crossReference, false);
        while (xrefs.hasNext()) {
            final int index = xrefs.nextIndex();
            final EObject referent = (EObject)xrefs.next();
            if (referent.eIsProxy() || CDOControlModeParticipant.inSameUnit(owner, referent) || !CDOControlModeParticipant.inSameModel(owner, referent)) continue;
            if (store[0] == null) {
                store[0] = ((InternalCDOView)CDOUtils.getCDOObject(owner).cdoView()).getStore();
            }
            result = result.chain(new OneWayUpdate(){

                @Override
                public void apply() {
                    store[0].set((InternalEObject)owner, (EStructuralFeature)crossReference, index, (Object)CDOIDUtil.createExternal((String)CDOProxyManager.createPapyrusCDOURI(referent)));
                }
            });
        }
        return result;
    }

    public ICommand getPreUncontrolCommand(ControlModeRequest request) {
        return new AbstractCDOControlCommand(request){

            @Override
            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                CDOControlModeParticipant.this.objectsToClearResource = Lists.newArrayList();
                return super.doExecuteWithResult(monitor, info);
            }

            @Override
            protected void buildUpdates(ControlModeRequest request, IUpdate.Collector updates) {
                URI sourceURI = this.getRequest().getSourceURI();
                IUpdate resolveProxies = IUpdate.EMPTY;
                for (final EObject object : CDOControlModeParticipant.getAllPersistentSubunitContents((ResourceSet)this.getRequest().getModelSet(), sourceURI)) {
                    CDOIDExternal sourceProxy = null;
                    URI destinationResourceURI = null;
                    CDOIDExternal proxy = null;
                    for (final EStructuralFeature.Setting next : CDOControlModeParticipant.this.getExternalCrossReferences(object)) {
                        if (next.getEObject().eIsProxy()) {
                            resolveProxies = resolveProxies.chain(new OneWayUpdate(){

                                @Override
                                public void apply() {
                                    CDOControlModeParticipant.this.resolve(object, (EReference)next.getEStructuralFeature(), next.getEObject());
                                }
                            });
                            continue;
                        }
                        if (sourceProxy == null) {
                            sourceProxy = CDOIDUtil.createExternal((String)CDOProxyManager.createPapyrusCDOURI(object));
                            destinationResourceURI = request.getTargetResource(object.eResource().getURI().fileExtension()).getURI();
                            String proxyURI = CDOProxyManager.createPapyrusCDOURI(destinationResourceURI, object);
                            proxy = CDOIDUtil.createExternal((String)proxyURI);
                        }
                        updates.add(new UncontrolUpdate(next, object, (CDOID)sourceProxy, destinationResourceURI, (CDOID)proxy));
                    }
                    if (((InternalEObject)object).eDirectResource() == null) continue;
                    CDOControlModeParticipant.this.objectsToClearResource.add(object);
                }
                resolveProxies.apply();
                for (final EObject object : CDOControlModeParticipant.getAllPersistentSubunitContents((ResourceSet)this.getRequest().getModelSet(), this.getRequest().getNewURI())) {
                    CDOIDExternal targetProxy = null;
                    for (EStructuralFeature.Setting next : CDOControlModeParticipant.this.getExternalCrossReferences(object)) {
                        if (!CDOControlModeParticipant.inUnit(next.getEObject(), sourceURI)) continue;
                        if (targetProxy == null) {
                            targetProxy = CDOIDUtil.createExternal((String)CDOProxyManager.createPapyrusCDOURI(object));
                        }
                        updates.add(new UncontrolUpdate(next, object, (CDOID)targetProxy));
                    }
                }
            }
        };
    }

    void resolve(EObject object, EReference reference, EObject proxy) {
        EReference opposite = reference.getEOpposite();
        if (opposite != null) {
            if (opposite.isMany()) {
                InternalEList list = (InternalEList)object.eGet((EStructuralFeature)opposite, false);
                int index = list.basicIndexOf((Object)proxy);
                if (index >= 0) {
                    list.get(index);
                }
            } else {
                object.eGet((EStructuralFeature)opposite, true);
            }
        }
    }

    public ICommand getPostUncontrolCommand(ControlModeRequest request) {
        return new AbstractCDOControlCommand(request){

            @Override
            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                CommandResult result = super.doExecuteWithResult(monitor, info);
                CDOControlModeParticipant.this.objectsToClearResource = null;
                return result;
            }

            @Override
            protected void buildUpdates(ControlModeRequest request, IUpdate.Collector updates) {
                for (EObject next : CDOControlModeParticipant.this.objectsToClearResource) {
                    if (CDOUtil.getCDOObject((EObject)next).cdoState() == CDOState.TRANSIENT) continue;
                    updates.add(new ClearResourceUpdate(next));
                }
            }
        };
    }

    Iterable<EStructuralFeature.Setting> getExternalCrossReferences(final EObject object) {
        return Iterables.filter(CDOUtils.crossReference(object), (Predicate)new Predicate<EStructuralFeature.Setting>(){

            public boolean apply(EStructuralFeature.Setting input) {
                boolean result = false;
                EStructuralFeature ref = input.getEStructuralFeature();
                if (ref != EresourcePackage.Literals.CDO_RESOURCE__CONTENTS && ref.isChangeable() && !ref.isDerived()) {
                    result = !CDOControlModeParticipant.inSameUnit(input.getEObject(), object) && CDOControlModeParticipant.inSameModel(input.getEObject(), object);
                }
                return result;
            }
        });
    }

    static boolean isPersistentObject(EObject object) {
        boolean result;
        boolean bl = result = !object.eIsProxy();
        if (result) {
            CDOObject cdo = CDOUtils.getCDOObject(object);
            result = cdo != null && !TEMPORARY_ID_STATES.contains(cdo.cdoState());
        }
        return result;
    }

    private static boolean inSameModel(EObject object, EObject other) {
        URI model1 = CDOControlModeParticipant.getResourceURI(EcoreUtil.getRootContainer((EObject)object));
        URI model2 = CDOControlModeParticipant.getResourceURI(EcoreUtil.getRootContainer((EObject)other));
        return model1 != null && model2 != null && model1.trimFileExtension().equals(model2.trimFileExtension());
    }

    private static URI getResourceURI(EObject object) {
        Resource res;
        URI result = object.eIsProxy() ? ((InternalEObject)object).eProxyURI().trimFragment() : ((res = object.eResource()) == null ? null : res.getURI());
        return result;
    }

    private static boolean inSameUnit(EObject object, EObject other) {
        URI uri = CDOControlModeParticipant.getResourceURI(other);
        return CDOControlModeParticipant.inUnit(object, uri);
    }

    private static boolean inUnit(EObject object, URI unit) {
        URI uri;
        boolean result = false;
        if (unit != null && (uri = CDOControlModeParticipant.getResourceURI(object)) != null) {
            uri = uri.trimFileExtension();
            URI otherURI = unit.trimFileExtension();
            result = uri.equals(otherURI);
        }
        return result;
    }

    static Iterable<EObject> getAllPersistentSubunitContents(ResourceSet rset, URI unitURI) {
        final URI base = unitURI.trimFileExtension();
        Iterable resources = Iterables.filter((Iterable)rset.getResources(), (Predicate)new Predicate<Resource>(){

            public boolean apply(Resource input) {
                return input.getURI().trimFileExtension().equals(base);
            }
        });
        Iterable result = Iterables.concat((Iterable)Iterables.transform((Iterable)resources, (Function)new Function<Resource, Iterable<EObject>>(){

            public Iterable<EObject> apply(final Resource input) {
                return new Iterable<EObject>(){

                    @Override
                    public Iterator<EObject> iterator() {
                        return EcoreUtil.getAllProperContents((Resource)input, (boolean)false);
                    }
                };
            }
        }));
        result = Iterables.filter((Iterable)result, (Predicate)new Predicate<EObject>(){

            public boolean apply(EObject input) {
                return CDOControlModeParticipant.isPersistentObject(input);
            }
        });
        return result;
    }

    private static abstract class AbstractCDOControlCommand
    extends AbstractControlCommand
    implements IUpdate.Compound {
        private List<IUpdate> updates;

        AbstractCDOControlCommand(ControlModeRequest request) {
            super(Messages.CDOControlModeParticipant_commandLabel, Collections.emptyList(), request);
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            ImmutableListCollector collector = new ImmutableListCollector();
            this.buildUpdates(this.getRequest(), collector);
            this.updates = collector.close();
            this.apply();
            return CommandResult.newOKCommandResult();
        }

        protected abstract void buildUpdates(ControlModeRequest var1, IUpdate.Collector var2);

        protected IStatus doUndo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            IStatus result = super.doUndo(monitor, info);
            if (result.isOK()) {
                this.revert();
            }
            return result;
        }

        protected IStatus doRedo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            IStatus result = super.doRedo(monitor, info);
            if (result.isOK()) {
                this.apply();
            }
            return result;
        }

        @Override
        public boolean isEmpty() {
            return this.updates == null || this.updates.isEmpty();
        }

        @Override
        public void apply() {
            for (IUpdate next : this.updates) {
                next.apply();
            }
        }

        @Override
        public void revert() {
            ListIterator<IUpdate> iter = this.updates.listIterator(this.updates.size());
            while (iter.hasPrevious()) {
                iter.previous().revert();
            }
        }

        @Override
        public void add(IUpdate update) {
            throw new UnsupportedOperationException("AbtsractCDOControlCommand is not externally modifiable");
        }

        @Override
        public IUpdate.Compound chain(IUpdate update) {
            throw new UnsupportedOperationException("AbtsractCDOControlCommand is not externally modifiable");
        }
    }

    private static final class ClearResourceUpdate
    extends Update {
        private CDOObject object;

        ClearResourceUpdate(EObject object) {
            super(object);
            this.object = CDOUtil.getCDOObject((EObject)object);
        }

        @Override
        public void apply() {
            InternalEObject object = (InternalEObject)CDOUtil.getEObject((EObject)this.object);
            this.store.setContainer(object, null, object.eInternalContainer(), object.eContainerFeatureID());
        }

        @Override
        public void revert() {
        }
    }

    static final class CompoundUpdate
    implements IUpdate.Compound {
        private final List<IUpdate> updates = Lists.newArrayList();

        CompoundUpdate() {
        }

        @Override
        public void add(IUpdate update) {
            this.updates.add(update);
        }

        @Override
        public IUpdate.Compound chain(IUpdate update) {
            if (update != null && !update.isEmpty()) {
                this.add(update);
            }
            return this;
        }

        @Override
        public boolean isEmpty() {
            return this.updates.isEmpty();
        }

        @Override
        public void apply() {
            for (IUpdate next : this.updates) {
                next.apply();
            }
        }

        @Override
        public void revert() {
            ListIterator<IUpdate> iter = this.updates.listIterator(this.updates.size());
            while (iter.hasPrevious()) {
                iter.previous().revert();
            }
        }

        static IUpdate compose(IUpdate first, IUpdate second) {
            IUpdate result;
            if (second == null || second.isEmpty()) {
                result = first == null ? IUpdate.EMPTY : first;
            } else if (first == null || first.isEmpty()) {
                result = second;
            } else {
                CompoundUpdate compound = new CompoundUpdate();
                compound.add(first);
                compound.add(second);
                result = compound;
            }
            return result;
        }
    }

    private static final class ControlUpdate
    extends Update {
        final EObject originalObject;
        final CDOID proxy;
        final int index;

        ControlUpdate(EStructuralFeature.Setting setting, EObject originalObject, CDOID proxy) {
            super(setting);
            this.originalObject = originalObject;
            this.proxy = proxy;
            EStructuralFeature feature = setting.getEStructuralFeature();
            InternalEObject owner = (InternalEObject)setting.getEObject();
            if (!feature.isMany()) {
                this.index = -1;
            } else {
                this.index = ((EList)owner.eGet(feature)).indexOf((Object)originalObject);
                if (this.index < 0) {
                    Activator.log.error("Setting does not include the object being replaced by a proxy.", null);
                }
            }
        }

        @Override
        public void apply() {
            EStructuralFeature feature = this.setting.getEStructuralFeature();
            if (this.index >= 0 || !feature.isMany()) {
                InternalEObject owner = (InternalEObject)this.setting.getEObject();
                this.store.set(owner, feature, this.index, (Object)this.proxy);
            }
        }

        @Override
        public void revert() {
            EStructuralFeature feature = this.setting.getEStructuralFeature();
            if (this.index >= 0 || !feature.isMany()) {
                InternalEObject owner = (InternalEObject)this.setting.getEObject();
                this.store.set(owner, feature, this.index, (Object)CDOUtils.getCDOID(this.originalObject));
            }
        }
    }

    public static interface IUpdate {
        public static final IUpdate EMPTY = new IUpdate(){

            @Override
            public boolean isEmpty() {
                return true;
            }

            @Override
            public void apply() {
            }

            @Override
            public void revert() {
            }

            @Override
            public IUpdate chain(IUpdate update) {
                return update == null ? this : update;
            }
        };

        public boolean isEmpty();

        public void apply();

        public void revert();

        public IUpdate chain(IUpdate var1);

        public static interface Collector {
            public void add(IUpdate var1);
        }

        public static interface Compound
        extends IUpdate,
        Collector {
        }
    }

    private static final class ImmutableListCollector
    implements IUpdate.Collector {
        private final ImmutableList.Builder<IUpdate> builder = ImmutableList.builder();

        private ImmutableListCollector() {
        }

        @Override
        public void add(IUpdate update) {
            this.builder.add((Object)update);
        }

        List<IUpdate> close() {
            return this.builder.build();
        }
    }

    private static abstract class OneWayUpdate
    implements IUpdate {
        private OneWayUpdate() {
        }

        @Override
        public void revert() {
            throw new UnsupportedOperationException("OneWayUpdate cannot be reverted");
        }

        @Override
        public IUpdate chain(IUpdate update) {
            return CompoundUpdate.compose(this, update);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }

    private static final class UncontrolUpdate
    extends Update {
        final EObject originalObject;
        final CDOID originalProxy;
        final URI destinationURI;
        final CDOID destinationProxy;
        final int index;

        UncontrolUpdate(EStructuralFeature.Setting setting, EObject originalObject, CDOID originalProxy, URI destinationURI, CDOID destinationProxy) {
            super(setting);
            this.originalObject = originalObject;
            this.originalProxy = originalProxy;
            this.destinationURI = destinationURI;
            this.destinationProxy = destinationProxy;
            EStructuralFeature feature = setting.getEStructuralFeature();
            InternalEObject owner = (InternalEObject)setting.getEObject();
            if (!feature.isMany()) {
                this.index = -1;
            } else {
                this.index = ((EList)owner.eGet(feature)).indexOf((Object)originalObject);
                if (this.index < 0) {
                    Activator.log.error("Setting does not include the object being replaced by a proxy.", null);
                }
            }
        }

        UncontrolUpdate(EStructuralFeature.Setting setting, EObject originalObject, CDOID originalProxy) {
            this(setting, originalObject, originalProxy, null, null);
        }

        @Override
        public void apply() {
            EStructuralFeature feature = this.setting.getEStructuralFeature();
            if (this.index >= 0 || !feature.isMany()) {
                InternalEObject owner = (InternalEObject)this.setting.getEObject();
                if (this.destinationURI == null || CDOControlModeParticipant.inUnit((EObject)owner, this.destinationURI)) {
                    this.store.set(owner, feature, this.index, (Object)CDOUtils.getCDOID(this.originalObject));
                } else {
                    this.store.set(owner, feature, this.index, (Object)this.destinationProxy);
                }
            }
        }

        @Override
        public void revert() {
            EStructuralFeature feature = this.setting.getEStructuralFeature();
            if (this.index >= 0 || !feature.isMany()) {
                InternalEObject owner = (InternalEObject)this.setting.getEObject();
                this.store.set(owner, feature, this.index, (Object)this.originalProxy);
            }
        }
    }

    private static abstract class Update
    implements IUpdate {
        final EStructuralFeature.Setting setting;
        final CDOStore store;

        Update(EStructuralFeature.Setting setting) {
            this.setting = setting;
            InternalEObject owner = (InternalEObject)setting.getEObject();
            CDOObject cdoOwner = CDOUtil.getCDOObject((EObject)owner);
            InternalCDOView view = (InternalCDOView)cdoOwner.cdoView();
            this.store = view.getStore();
        }

        Update(EObject object) {
            this.setting = null;
            CDOObject cdo = CDOUtil.getCDOObject((EObject)object);
            CDOView view = cdo.cdoView();
            this.store = view instanceof InternalCDOView ? ((InternalCDOView)view).getStore() : null;
        }

        @Override
        public IUpdate chain(IUpdate update) {
            return CompoundUpdate.compose(this, update);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }
}

