/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.vocabulary.generatefrommodel.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.opencert.apm.assuranceassets.assuranceasset.AssuranceassetPackage;
import org.eclipse.opencert.apm.assurproj.assuranceproject.AssuranceprojectPackage;
import org.eclipse.opencert.apm.baseline.baseline.BaselinePackage;
import org.eclipse.opencert.evm.evidspec.evidence.EvidencePackage;
import org.eclipse.opencert.infra.mappings.mapping.MappingPackage;
import org.eclipse.opencert.pam.procspec.process.ProcessPackage;
import org.eclipse.opencert.pkm.refframework.refframework.RefframeworkPackage;
import org.eclipse.opencert.sam.arg.arg.ArgPackage;
import org.eclipse.opencert.sam.arg.arg.Claim;
import org.eclipse.opencert.vocabulary.Category;
import org.eclipse.opencert.vocabulary.SourceOfDefinition;
import org.eclipse.opencert.vocabulary.Term;
import org.eclipse.opencert.vocabulary.Vocabulary;
import org.eclipse.opencert.vocabulary.VocabularyFactory;
import org.eclipse.opencert.vocabulary.generatefrommodel.util.FileUtil;

public class VocabularyCreator {
    private List<Category> packageCategories = new ArrayList<Category>();
    private Set<EObject> processedElements = new HashSet<EObject>();

    public void createVocabulary(IProject iProject, Resource targetResource) {
        Vocabulary vocabulary = VocabularyFactory.eINSTANCE.createVocabulary();
        List<EPackage> ePackages = this.getCclEPackages();
        Map<EClass, Category> termCategories = this.createTermCategories(ePackages);
        List<EObject> modelElements = FileUtil.getModels(iProject);
        this.createTerms(vocabulary, modelElements, termCategories);
        this.addCategories(vocabulary, this.packageCategories, termCategories);
        this.addSourceOfDefinition(vocabulary, iProject);
        targetResource.getContents().add((Object)vocabulary);
    }

    private void addSourceOfDefinition(Vocabulary vocabulary, IProject iProject) {
        if (!vocabulary.getTerms().isEmpty()) {
            SourceOfDefinition source = VocabularyFactory.eINSTANCE.createSourceOfDefinition();
            source.setUri(iProject.getLocationURI().toASCIIString());
            source.setName("Vocabulary data extracted from the CCL model");
            for (Term term : vocabulary.getTerms()) {
                term.setDefinedBy(source);
            }
            vocabulary.getSourcesOfDefinition().add((Object)source);
        }
    }

    private void addCategories(Vocabulary vocabulary, List<Category> packageCategories, Map<EClass, Category> termCategories) {
        ArrayList<Category> forDeletion = new ArrayList<Category>();
        for (Category termCategory : termCategories.values()) {
            if (termCategory.getTerms().isEmpty()) continue;
            vocabulary.getCategories().add((Object)termCategory);
        }
        for (Category packageCategory : packageCategories) {
            for (Category subCategory : packageCategory.getSubCategories()) {
                if (!vocabulary.getCategories().contains((Object)subCategory)) continue;
                vocabulary.getCategories().add((Object)packageCategory);
                break;
            }
            if (!packageCategory.getSubCategories().isEmpty()) continue;
            forDeletion.add(packageCategory);
        }
        for (Category category : forDeletion) {
            EcoreUtil.delete((EObject)category);
        }
    }

    private List<EPackage> getCclEPackages() {
        ArrayList<EPackage> ePackages = new ArrayList<EPackage>();
        ePackages.add((EPackage)AssuranceassetPackage.eINSTANCE);
        ePackages.add((EPackage)AssuranceprojectPackage.eINSTANCE);
        ePackages.add((EPackage)BaselinePackage.eINSTANCE);
        ePackages.add((EPackage)EvidencePackage.eINSTANCE);
        ePackages.add((EPackage)MappingPackage.eINSTANCE);
        ePackages.add((EPackage)ProcessPackage.eINSTANCE);
        ePackages.add((EPackage)RefframeworkPackage.eINSTANCE);
        ePackages.add((EPackage)ArgPackage.eINSTANCE);
        return ePackages;
    }

    private Map<EClass, Category> createTermCategories(List<EPackage> ePackages) {
        HashMap<EClass, Category> result = new HashMap<EClass, Category>();
        for (EPackage ePackage : ePackages) {
            Category packageCategory = VocabularyFactory.eINSTANCE.createCategory();
            packageCategory.setName(ePackage.getName());
            packageCategory.setDescription("Contains the model elements of the " + ePackage.getName() + " package.");
            boolean hasSubCategories = false;
            for (EObject obj : ePackage.eContents()) {
                if (!(obj instanceof EClass)) continue;
                EClass eClass = (EClass)obj;
                if (eClass.getName().equals("Claim")) {
                    System.out.println();
                }
                if (eClass.isAbstract() || eClass.isInterface()) continue;
                Category termCategory = VocabularyFactory.eINSTANCE.createCategory();
                termCategory.setName(eClass.getName());
                termCategory.setDescription("Contains model elements of the type " + eClass.getName());
                packageCategory.getSubCategories().add((Object)termCategory);
                result.put(eClass, termCategory);
                hasSubCategories = true;
            }
            if (!hasSubCategories) continue;
            this.packageCategories.add(packageCategory);
        }
        return result;
    }

    private void createTerms(Vocabulary vocabulary, List<EObject> modelElements, Map<EClass, Category> categories) {
        for (EObject modelElement : modelElements) {
            Category category;
            if (this.processedElements.contains(modelElement)) continue;
            this.processedElements.add(modelElement);
            EClass eClass = modelElement.eClass();
            if (modelElement instanceof Claim) {
                System.out.println();
            }
            if ((category = categories.get(eClass)) == null) continue;
            String name = this.getStringPropertyValue(modelElement, "name");
            if (name == null) {
                name = this.getStringPropertyValue(modelElement, "id");
            }
            String description = this.getStringPropertyValue(modelElement, "description");
            if (name != null) {
                Term term = VocabularyFactory.eINSTANCE.createTerm();
                term.setName(name);
                if (description != null) {
                    term.getDefinitions().add((Object)description);
                }
                category.getTerms().add((Object)term);
                vocabulary.getTerms().add((Object)term);
            }
            for (EReference eReference : eClass.getEReferences()) {
                EClassifier eClassifier = eReference.getEType();
                if (!(eClassifier instanceof EClass)) continue;
                Object referenceContent = modelElement.eGet((EStructuralFeature)eReference);
                if (referenceContent instanceof EList) {
                    this.createTerms(vocabulary, (List)referenceContent, categories);
                    continue;
                }
                if (!(referenceContent instanceof EObject)) continue;
                this.createTerms(vocabulary, Collections.singletonList((EObject)referenceContent), categories);
            }
        }
    }

    private String getStringPropertyValue(EObject eObject, String propertyName) {
        String result = null;
        Object propertyValue = null;
        EAttribute eAttribute = this.getAttributeByName(eObject.eClass(), propertyName);
        if (eAttribute != null) {
            propertyValue = eObject.eGet((EStructuralFeature)eAttribute);
        }
        if (eAttribute != null && propertyValue instanceof String) {
            result = (String)propertyValue;
        }
        return result;
    }

    private EAttribute getAttributeByName(EClass eClass, String name) {
        EAttribute result = null;
        for (EAttribute eAttribute : eClass.getEAllAttributes()) {
            if (!eAttribute.getName().equalsIgnoreCase(name)) continue;
            result = eAttribute;
            break;
        }
        return result;
    }
}

