/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.component.edit.policies;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.diagram.component.edit.commands.AbstractionCreateCommand;
import org.eclipse.papyrus.uml.diagram.component.edit.commands.CommentAnnotatedElementCreateCommand;
import org.eclipse.papyrus.uml.diagram.component.edit.commands.CommentAnnotatedElementReorientCommand;
import org.eclipse.papyrus.uml.diagram.component.edit.commands.ComponentRealizationCreateCommand;
import org.eclipse.papyrus.uml.diagram.component.edit.commands.ConstraintConstrainedElementCreateCommand;
import org.eclipse.papyrus.uml.diagram.component.edit.commands.ConstraintConstrainedElementReorientCommand;
import org.eclipse.papyrus.uml.diagram.component.edit.commands.DependencyBranchCreateCommand;
import org.eclipse.papyrus.uml.diagram.component.edit.commands.DependencyCreateCommand;
import org.eclipse.papyrus.uml.diagram.component.edit.commands.InterfaceRealizationCreateCommand;
import org.eclipse.papyrus.uml.diagram.component.edit.commands.ManifestationCreateCommand;
import org.eclipse.papyrus.uml.diagram.component.edit.commands.SubstitutionCreateCommand;
import org.eclipse.papyrus.uml.diagram.component.edit.commands.UsageCreateCommand;
import org.eclipse.papyrus.uml.diagram.component.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.papyrus.uml.diagram.component.providers.UMLElementTypes;

public class DependencyBranchItemSemanticEditPolicy
extends UMLBaseItemSemanticEditPolicy {
    public DependencyBranchItemSemanticEditPolicy() {
        super(UMLElementTypes.Dependency_BranchEdge);
    }

    @Override
    protected Command getDestroyElementCommand(DestroyElementRequest req) {
        ICommand deleteCommand;
        EObject selectedEObject = req.getElementToDestroy();
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)selectedEObject);
        if (provider != null && (deleteCommand = provider.getEditCommand((IEditCommandRequest)req)) != null) {
            return new ICommandProxy(deleteCommand);
        }
        return UnexecutableCommand.INSTANCE;
    }

    @Override
    protected Command getCreateRelationshipCommand(CreateRelationshipRequest req) {
        Command command = req.getTarget() == null ? this.getStartCreateRelationshipCommand(req) : this.getCompleteCreateRelationshipCommand(req);
        return command != null ? command : super.getCreateRelationshipCommand(req);
    }

    protected Command getStartCreateRelationshipCommand(CreateRelationshipRequest req) {
        IElementType requestElementType = req.getElementType();
        if (requestElementType == null) {
            return null;
        }
        IElementType baseElementType = requestElementType;
        if (UMLElementTypes.Usage_Edge == baseElementType) {
            return this.getGEFWrapper((ICommand)new UsageCreateCommand(req, req.getSource(), req.getTarget()));
        }
        if (UMLElementTypes.InterfaceRealization_Edge == baseElementType) {
            return this.getGEFWrapper((ICommand)new InterfaceRealizationCreateCommand(req, req.getSource(), req.getTarget()));
        }
        if (UMLElementTypes.Substitution_Edge == baseElementType) {
            return this.getGEFWrapper((ICommand)new SubstitutionCreateCommand(req, req.getSource(), req.getTarget()));
        }
        if (UMLElementTypes.Manifestation_Edge == baseElementType) {
            return this.getGEFWrapper((ICommand)new ManifestationCreateCommand(req, req.getSource(), req.getTarget()));
        }
        if (UMLElementTypes.ComponentRealization_Edge == baseElementType) {
            return this.getGEFWrapper((ICommand)new ComponentRealizationCreateCommand(req, req.getSource(), req.getTarget()));
        }
        if (UMLElementTypes.Abstraction_Edge == baseElementType) {
            return this.getGEFWrapper((ICommand)new AbstractionCreateCommand(req, req.getSource(), req.getTarget()));
        }
        if (UMLElementTypes.Comment_AnnotatedElementEdge == baseElementType) {
            return null;
        }
        if (UMLElementTypes.Constraint_ConstrainedElementEdge == baseElementType) {
            return null;
        }
        if (UMLElementTypes.Dependency_Edge == baseElementType) {
            return this.getGEFWrapper((ICommand)new DependencyCreateCommand(req, req.getSource(), req.getTarget()));
        }
        if (UMLElementTypes.Dependency_BranchEdge == baseElementType) {
            return this.getGEFWrapper((ICommand)new DependencyBranchCreateCommand(req, req.getSource(), req.getTarget()));
        }
        return null;
    }

    protected Command getCompleteCreateRelationshipCommand(CreateRelationshipRequest req) {
        IElementType requestElementType = req.getElementType();
        if (requestElementType == null) {
            return null;
        }
        IElementType baseElementType = requestElementType;
        if (UMLElementTypes.Usage_Edge == baseElementType) {
            return this.getGEFWrapper((ICommand)new UsageCreateCommand(req, req.getSource(), req.getTarget()));
        }
        if (UMLElementTypes.InterfaceRealization_Edge == baseElementType) {
            return null;
        }
        if (UMLElementTypes.Substitution_Edge == baseElementType) {
            return this.getGEFWrapper((ICommand)new SubstitutionCreateCommand(req, req.getSource(), req.getTarget()));
        }
        if (UMLElementTypes.Manifestation_Edge == baseElementType) {
            return this.getGEFWrapper((ICommand)new ManifestationCreateCommand(req, req.getSource(), req.getTarget()));
        }
        if (UMLElementTypes.ComponentRealization_Edge == baseElementType) {
            return this.getGEFWrapper((ICommand)new ComponentRealizationCreateCommand(req, req.getSource(), req.getTarget()));
        }
        if (UMLElementTypes.Abstraction_Edge == baseElementType) {
            return this.getGEFWrapper((ICommand)new AbstractionCreateCommand(req, req.getSource(), req.getTarget()));
        }
        if (UMLElementTypes.Comment_AnnotatedElementEdge == baseElementType) {
            return this.getGEFWrapper((ICommand)new CommentAnnotatedElementCreateCommand(req, req.getSource(), req.getTarget()));
        }
        if (UMLElementTypes.Constraint_ConstrainedElementEdge == baseElementType) {
            return this.getGEFWrapper((ICommand)new ConstraintConstrainedElementCreateCommand(req, req.getSource(), req.getTarget()));
        }
        if (UMLElementTypes.Dependency_Edge == baseElementType) {
            return this.getGEFWrapper((ICommand)new DependencyCreateCommand(req, req.getSource(), req.getTarget()));
        }
        if (UMLElementTypes.Dependency_BranchEdge == baseElementType) {
            return this.getGEFWrapper((ICommand)new DependencyBranchCreateCommand(req, req.getSource(), req.getTarget()));
        }
        return null;
    }

    @Override
    protected Command getReorientRelationshipCommand(ReorientRelationshipRequest req) {
        switch (this.getVisualID((IEditCommandRequest)req)) {
            case "ComponentRealization_Edge": 
            case "Manifestation_Edge": 
            case "Substitution_Edge": 
            case "Abstraction_Edge": 
            case "Usage_Edge": 
            case "Dependency_Edge": 
            case "InterfaceRealization_Edge": 
            case "Dependency_BranchEdge": {
                IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)req.getRelationship());
                if (provider == null) {
                    return UnexecutableCommand.INSTANCE;
                }
                ICommand reorientCommand = provider.getEditCommand((IEditCommandRequest)req);
                if (reorientCommand == null) {
                    return UnexecutableCommand.INSTANCE;
                }
                return this.getGEFWrapper(reorientCommand.reduce());
            }
        }
        return super.getReorientRelationshipCommand(req);
    }

    @Override
    protected Command getReorientReferenceRelationshipCommand(ReorientReferenceRelationshipRequest req) {
        switch (this.getVisualID((IEditCommandRequest)req)) {
            case "Comment_AnnotatedElementEdge": {
                return this.getGEFWrapper((ICommand)new CommentAnnotatedElementReorientCommand(req));
            }
            case "Constraint_ConstrainedElementEdge": {
                return this.getGEFWrapper((ICommand)new ConstraintConstrainedElementReorientCommand(req));
            }
        }
        return super.getReorientReferenceRelationshipCommand(req);
    }
}

