/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.core.views;

import java.util.ArrayList;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.polarsys.chess.chessmlprofile.Core.Domain;
import org.polarsys.chess.core.internal.views.InternalViewUtils;
import org.polarsys.chess.core.internal.views.permissions.EntryId;
import org.polarsys.chess.core.profiles.CHESSProfileManager;
import org.polarsys.chess.core.util.CHESSProjectSupport;
import org.polarsys.chess.core.views.DiagramStatus;

public class ViewUtils {
    public static Package getView(EObject element) {
        if (element == null) {
            return null;
        }
        Package pkg = null;
        if (element instanceof Package && InternalViewUtils.hasViewStereotypeApplied(pkg = (Package)element)) {
            return pkg;
        }
        return ViewUtils.getView(element.eContainer());
    }

    @Deprecated
    public static boolean isDeploymentView(DiagramStatus.DesignView view) {
        return view == null ? false : view.isEnabled("DeploymentView");
    }

    public static boolean isDesignView(DiagramStatus.DesignView view, String name) {
        if (view == null) {
            return false;
        }
        if (!CHESSProfileManager.CHESS_VIEWS_LIST.contains(name)) {
            throw new IllegalArgumentException("Invalid design view name");
        }
        return view.isEnabled(name);
    }

    public static boolean isDesignView(Package pkg, String name) {
        EList list = pkg.getAppliedStereotypes();
        for (Stereotype stereotype : list) {
            if (!stereotype.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean isDeploymentView(Package pkg) {
        EList list = pkg.getAppliedStereotypes();
        for (Stereotype stereotype : list) {
            if (!stereotype.getName().equals("DeploymentView")) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean isRTAnalysisView(Package pkg) {
        EList list = pkg.getAppliedStereotypes();
        for (Stereotype stereotype : list) {
            if (!stereotype.getName().equals("RTAnalysisView")) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean isDependabilityAnalysisView(DiagramStatus.DesignView view) {
        return view == null ? false : view.isEnabled("DependabilityAnalysisView");
    }

    public static boolean isElementWritable_(EObject element, Object feature, DiagramStatus.DesignView currentView, Domain theDomain) {
        if (currentView != null) {
            ArrayList<EntryId> ids = EntryId.computeEntryIds_(element, feature);
            return ViewUtils.checkIdPermission(ids, currentView, (byte)0, theDomain);
        }
        return false;
    }

    public static boolean isElementWritable_(EObject element, Object feature, String viewName, DiagramStatus.DesignView currentView, Domain theDomain) {
        if (viewName != null) {
            ArrayList<EntryId> ids = EntryId.computeEntryIds_(element, feature);
            return ViewUtils.checkIdPermission(ids, viewName, (byte)0, currentView, theDomain);
        }
        return false;
    }

    public static boolean isElementInstantiable(EObject element, Object feature, DiagramStatus.DesignView currentView, Domain theDomain) {
        if (currentView != null) {
            ArrayList<EntryId> ids = EntryId.computeEntryIds_(element, feature);
            return ViewUtils.checkIdPermission(ids, currentView, (byte)1, theDomain);
        }
        return false;
    }

    public static boolean isStereotypeWritable(EObject element, Object feature, Object stereotype, DiagramStatus.DesignView currentView, Domain theDomain) {
        if (currentView != null) {
            ArrayList<EntryId> ids = EntryId.computeStereotypeEntryIds(element, feature, stereotype);
            return ViewUtils.checkIdPermission(ids, currentView, (byte)0, theDomain);
        }
        return false;
    }

    public static boolean isStereotypeInstantiable(EObject element, Object feature, Object stereotype, DiagramStatus.DesignView currentView, Domain theDomain) {
        if (currentView != null) {
            ArrayList<EntryId> ids = EntryId.computeStereotypeEntryIds(element, feature, stereotype);
            return ViewUtils.checkIdPermission(ids, currentView, (byte)1, theDomain);
        }
        return false;
    }

    private static boolean checkIdPermission(ArrayList<EntryId> ids, DiagramStatus.DesignView currentView, byte permission, Domain theDomain) {
        if (ids.isEmpty()) {
            return true;
        }
        boolean res4Stereo = false;
        for (EntryId entryId : ids) {
            CHESSProjectSupport.printlnToCHESSConsole(entryId.toString());
            boolean perm = InternalViewUtils.checkPermission(currentView, entryId, permission, theDomain);
            if (entryId.getStereotype().equals(EntryId.NONE) && !perm) {
                return false;
            }
            boolean bl = res4Stereo = res4Stereo || perm;
        }
        return res4Stereo;
    }

    private static boolean checkIdPermission(ArrayList<EntryId> ids, String viewName, byte permission, DiagramStatus.DesignView currentView, Domain theDomain) {
        if (ids.isEmpty()) {
            return true;
        }
        boolean res4Stereo = false;
        for (EntryId entryId : ids) {
            CHESSProjectSupport.printlnToCHESSConsole(entryId.toString());
            boolean perm = InternalViewUtils.checkPermission(viewName, entryId, permission, currentView, theDomain);
            if (entryId.getStereotype().equals(EntryId.NONE) && !perm) {
                return false;
            }
            boolean bl = res4Stereo = res4Stereo || perm;
        }
        return res4Stereo;
    }

    public static boolean isExtraFunctionalView(DiagramStatus.DesignView view) {
        return view == null ? false : view.isEnabled("ExtraFunctionalView");
    }

    public static boolean isExtraFunctionalView(Package pkg) {
        EList list = pkg.getAppliedStereotypes();
        for (Stereotype stereotype : list) {
            if (!stereotype.getName().equals("ExtraFunctionalView")) continue;
            return true;
        }
        return false;
    }

    public static boolean isComponentView(DiagramStatus.DesignView view) {
        return view == null ? false : view.isEnabled("ComponentView");
    }

    public static boolean isComponentView(Package pkg) {
        if (pkg != null) {
            EList list = pkg.getAppliedStereotypes();
            for (Stereotype stereotype : list) {
                if (!stereotype.getName().equals("ComponentView")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isRequirementView(Package pkg) {
        if (pkg != null) {
            EList list = pkg.getAppliedStereotypes();
            for (Stereotype stereotype : list) {
                if (!stereotype.getName().equals("RequirementView")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isSystemView(Package pkg) {
        if (pkg != null) {
            EList list = pkg.getAppliedStereotypes();
            for (Stereotype stereotype : list) {
                if (!stereotype.getName().equals("SystemView")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPSMView(Package pkg) {
        if (pkg != null) {
            EList list = pkg.getAppliedStereotypes();
            for (Stereotype stereotype : list) {
                if (!stereotype.getName().equals("PSMView")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isViewModifiedOrRemoved(Notification notification) {
        Object o;
        Object el = notification.getNotifier();
        if (notification.getEventType() == 20 || notification.getEventType() == 21 || notification.getEventType() == 22) {
            Object st = notification.getNewValue();
            if (el instanceof EObject && st instanceof EObject) {
                String viewName = ((EObject)st).eClass().getName();
                return CHESSProfileManager.CHESS_VIEWS_LIST.contains(viewName);
            }
        }
        if (notification.getEventType() == 4 && (o = notification.getOldValue()) instanceof EObject) {
            return InternalViewUtils.isView((EObject)o);
        }
        if (el instanceof DynamicEObjectImpl) {
            DynamicEObjectImpl d = (DynamicEObjectImpl)el;
            Stereotype stereo = UMLUtil.getStereotype((EObject)d);
            return ViewUtils.isViewStereotype(stereo);
        }
        if (notification.getEventType() == 1 && el instanceof EObject) {
            return InternalViewUtils.isView((EObject)el);
        }
        return false;
    }

    public static boolean isViewStereotype(Stereotype stereotype) {
        return CHESSProfileManager.CHESS_VIEWS_LIST.contains(stereotype.getName());
    }

    public static boolean isConcurrentView(DiagramStatus.DesignView currentView) {
        if (currentView == null) {
            return false;
        }
        for (String view : CHESSProfileManager.CONCURRENT_VIEWS) {
            if (!currentView.isEnabled(view)) continue;
            return true;
        }
        return false;
    }

    public static boolean isOnView(DiagramStatus.DesignView currentView, String view) {
        if (currentView == null) {
            return false;
        }
        for (String v : CHESSProfileManager.CONCURRENT_VIEWS_ASSOCIATION.get(view)) {
            if (!currentView.isEnabled(v)) continue;
            return true;
        }
        return false;
    }

    public static Package getCHESSRtAnalysisPackage(Model theModel) {
        for (Element p : theModel.allOwnedElements()) {
            if (!(p instanceof Package) || !ViewUtils.isRTAnalysisView((Package)p)) continue;
            return (Package)p;
        }
        return theModel;
    }

    public static Package getCHESSDeploymentPackage(Model theModel) {
        for (Element p : theModel.allOwnedElements()) {
            if (!(p instanceof Package) || !ViewUtils.isDeploymentView((Package)p)) continue;
            return (Package)p;
        }
        return theModel;
    }

    public static Package getCHESSPSMPackage(Model theModel) {
        for (Element p : theModel.allOwnedElements()) {
            if (!(p instanceof Package) || !ViewUtils.isPSMView((Package)p)) continue;
            return (Package)p;
        }
        return theModel;
    }

    public static boolean hasConcurrentViews(DiagramStatus.DesignView currentView) {
        for (String v : CHESSProfileManager.CONCURRENT_VIEWS_ASSOCIATION.keySet()) {
            if (!currentView.isEnabled(v)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasConcurrentViews(String viewName) {
        return CHESSProfileManager.CONCURRENT_VIEWS_ASSOCIATION.keySet().contains(viewName);
    }

    public static String getBaseViewName(DiagramStatus.DesignView currentView) {
        return currentView.getName();
    }
}

