/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.editor.hierarchy;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import javax.inject.Provider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.findReferences.IReferenceFinder;
import org.eclipse.xtext.findReferences.TargetURICollector;
import org.eclipse.xtext.findReferences.TargetURIs;
import org.eclipse.xtext.ide.editor.hierarchy.IHierarchyBuilder;
import org.eclipse.xtext.ide.editor.hierarchy.IHierarchyNodeLocationProvider;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

@Accessors(value={AccessorType.PUBLIC_SETTER, AccessorType.PROTECTED_GETTER})
public abstract class AbstractHierarchyBuilder
implements IHierarchyBuilder {
    private IReferenceFinder.IResourceAccess resourceAccess;
    private IResourceDescriptions indexData;
    @Inject
    private IReferenceFinder referenceFinder;
    @Inject
    private TargetURICollector targetURICollector;
    @Inject
    private Provider<TargetURIs> targetURIProvider;
    @Inject
    private IHierarchyNodeLocationProvider hierarchyNodeLocationProvider;
    @Inject
    private IResourceServiceProvider.Registry resourceServiceProviderRegistry;

    protected <R> R readOnly(final URI objectURI, final IUnitOfWork<R, EObject> work) {
        IReferenceFinder.IResourceAccess _resourceAccess = this.getResourceAccess();
        IUnitOfWork _function = new IUnitOfWork<R, ResourceSet>(){

            public R exec(ResourceSet resourceSet) throws Exception {
                EObject targetObject = resourceSet.getEObject(objectURI, true);
                return work.exec((Object)targetObject);
            }
        };
        return (R)_resourceAccess.readOnly(objectURI, _function);
    }

    protected IEObjectDescription getDescription(final URI objectURI) {
        URI _trimFragment;
        IResourceDescriptions _indexData = this.getIndexData();
        IResourceDescription resourceDescription = _indexData.getResourceDescription(_trimFragment = objectURI.trimFragment());
        if (resourceDescription == null) {
            return null;
        }
        Iterable _exportedObjects = resourceDescription.getExportedObjects();
        Functions.Function1<IEObjectDescription, Boolean> _function = new Functions.Function1<IEObjectDescription, Boolean>(){

            public Boolean apply(IEObjectDescription it) {
                URI _eObjectURI = it.getEObjectURI();
                return Objects.equal((Object)_eObjectURI, (Object)objectURI);
            }
        };
        return (IEObjectDescription)IterableExtensions.findFirst((Iterable)_exportedObjects, (Functions.Function1)_function);
    }

    protected IEObjectDescription getDescription(EObject object) {
        if (object == null) {
            return null;
        }
        IResourceDescriptions _indexData = this.getIndexData();
        Iterable _exportedObjectsByObject = _indexData.getExportedObjectsByObject(object);
        return (IEObjectDescription)IterableExtensions.head((Iterable)_exportedObjectsByObject);
    }

    protected boolean isAssignable(EClass superType, EClassifier type) {
        if (type instanceof EClass) {
            return EcoreUtil2.isAssignableFrom((EClass)superType, (EClass)((EClass)type));
        }
        return false;
    }

    @Pure
    protected IReferenceFinder.IResourceAccess getResourceAccess() {
        return this.resourceAccess;
    }

    public void setResourceAccess(IReferenceFinder.IResourceAccess resourceAccess) {
        this.resourceAccess = resourceAccess;
    }

    @Pure
    protected IResourceDescriptions getIndexData() {
        return this.indexData;
    }

    public void setIndexData(IResourceDescriptions indexData) {
        this.indexData = indexData;
    }

    @Pure
    protected IReferenceFinder getReferenceFinder() {
        return this.referenceFinder;
    }

    public void setReferenceFinder(IReferenceFinder referenceFinder) {
        this.referenceFinder = referenceFinder;
    }

    @Pure
    protected TargetURICollector getTargetURICollector() {
        return this.targetURICollector;
    }

    public void setTargetURICollector(TargetURICollector targetURICollector) {
        this.targetURICollector = targetURICollector;
    }

    @Pure
    protected Provider<TargetURIs> getTargetURIProvider() {
        return this.targetURIProvider;
    }

    public void setTargetURIProvider(Provider<TargetURIs> targetURIProvider) {
        this.targetURIProvider = targetURIProvider;
    }

    @Pure
    protected IHierarchyNodeLocationProvider getHierarchyNodeLocationProvider() {
        return this.hierarchyNodeLocationProvider;
    }

    public void setHierarchyNodeLocationProvider(IHierarchyNodeLocationProvider hierarchyNodeLocationProvider) {
        this.hierarchyNodeLocationProvider = hierarchyNodeLocationProvider;
    }

    @Pure
    protected IResourceServiceProvider.Registry getResourceServiceProviderRegistry() {
        return this.resourceServiceProviderRegistry;
    }

    public void setResourceServiceProviderRegistry(IResourceServiceProvider.Registry resourceServiceProviderRegistry) {
        this.resourceServiceProviderRegistry = resourceServiceProviderRegistry;
    }
}

