/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.internalblock.provider;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.papyrus.gmf.diagram.common.provider.IGraphicalTypeRegistry;
import org.eclipse.papyrus.sysml.diagram.internalblock.provider.ElementTypes;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Constraint;

public class GraphicalTypeRegistry
implements IGraphicalTypeRegistry {
    protected Set<String> knownNodes = new HashSet<String>();
    protected Set<String> knownEdges = new HashSet<String>();

    public GraphicalTypeRegistry() {
        this.knownEdges.add(ElementTypes.COMMENT_ANNOTATED_ELEMENT.getSemanticHint());
        this.knownEdges.add(ElementTypes.CONSTRAINT_CONSTRAINED_ELEMENT.getSemanticHint());
        this.knownNodes.add(UMLElementTypes.CONSTRAINT.getSemanticHint());
        this.knownNodes.add(UMLElementTypes.COMMENT.getSemanticHint());
        this.knownNodes.add(ElementTypes.CONSTRAINT.getSemanticHint());
        this.knownNodes.add(ElementTypes.COMMENT_CN.getSemanticHint());
        this.knownNodes.add(ElementTypes.COMMENT.getSemanticHint());
        this.knownNodes.add(ElementTypes.CONSTRAINT_CN.getSemanticHint());
    }

    public String getEdgeGraphicalType(EObject domainElement) {
        String graphicalType = "undefined_type";
        if (domainElement == null) {
            return "undefined_type";
        }
        return graphicalType;
    }

    public String getEdgeGraphicalType(IElementType elementType) {
        if (elementType instanceof IHintedType) {
            String semanticHint = ((IHintedType)elementType).getSemanticHint();
            return this.getEdgeGraphicalType(semanticHint);
        }
        return "undefined_type";
    }

    public String getEdgeGraphicalType(String proposedType) {
        if (this.isKnownEdgeType(proposedType)) {
            return proposedType;
        }
        return "undefined_type";
    }

    public String getNodeGraphicalType(EObject domainElement, String containerType) {
        String graphicalType = "undefined_type";
        if (containerType == null || domainElement == null) {
            return "undefined_type";
        }
        if (domainElement instanceof Constraint) {
            if ("InternalBlock".equals(containerType)) {
                graphicalType = ElementTypes.CONSTRAINT.getSemanticHint();
            }
            if ("compartment_sysml_structure".equals(containerType)) {
                graphicalType = ElementTypes.CONSTRAINT_CN.getSemanticHint();
            }
        }
        if (domainElement instanceof Comment) {
            if ("InternalBlock".equals(containerType)) {
                graphicalType = ElementTypes.COMMENT.getSemanticHint();
            }
            if ("compartment_sysml_structure".equals(containerType)) {
                graphicalType = ElementTypes.COMMENT_CN.getSemanticHint();
            }
            if ("compartment_sysml_blockproperty_structure".equals(containerType)) {
                graphicalType = ElementTypes.COMMENT_CN.getSemanticHint();
            }
        }
        return graphicalType;
    }

    public String getNodeGraphicalType(IElementType elementType, String containerType) {
        if (elementType instanceof IHintedType) {
            String semanticHint = ((IHintedType)elementType).getSemanticHint();
            return this.getNodeGraphicalType(semanticHint, containerType);
        }
        return "undefined_type";
    }

    public String getNodeGraphicalType(String proposedType, String containerType) {
        if (UMLElementTypes.COMMENT.getSemanticHint().equals(proposedType)) {
            if ("InternalBlock".equals(containerType)) {
                return ElementTypes.COMMENT.getSemanticHint();
            }
            if ("compartment_sysml_structure".equals(containerType)) {
                return ElementTypes.COMMENT_CN.getSemanticHint();
            }
            if ("compartment_sysml_blockproperty_structure".equals(containerType)) {
                return ElementTypes.COMMENT_CN.getSemanticHint();
            }
            return "undefined_type";
        }
        if (UMLElementTypes.CONSTRAINT.getSemanticHint().equals(proposedType)) {
            if ("InternalBlock".equals(containerType)) {
                return ElementTypes.CONSTRAINT.getSemanticHint();
            }
            if ("compartment_sysml_structure".equals(containerType)) {
                return ElementTypes.CONSTRAINT_CN.getSemanticHint();
            }
            return "undefined_type";
        }
        if (this.isKnownNodeType(proposedType)) {
            return proposedType;
        }
        return "undefined_type";
    }

    public boolean isKnownEdgeType(String type) {
        return this.knownEdges.contains(type);
    }

    public boolean isKnownNodeType(String type) {
        return this.knownNodes.contains(type);
    }
}

