/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.utils;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.ISlaveAxisProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.DisplayStyle;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.LabelConfigurationManagementUtils;
import org.eclipse.papyrus.infra.nattable.utils.TableHelper;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class NattableWidgetPropertyTester
extends PropertyTester {
    public static final String IS_NATTABLE_WIDGET = "isNattableWidget";
    private static final String HAS_FEATURE_ROW_HEADER_CONFIGURATION = "hasFeatureRowHeaderConfiguration";
    private static final String HAS_FEATURE_COLUMN_HEADER_CONFIGURATION = "hasFeatureColumnHeaderConfiguration";
    private static final String HAS_SLAVE_ROWS_AXIS_PROVIDER = "hasSlaveRowAxisProvider";
    private static final String HAS_SLAVE_COLUMNS_AXIS_PROVIDER = "hasSlaveColumnAxisProvider";
    private static final String CAN_INVERT_AXIS = "canInvertAxis";
    private static final String IS_HIERARCHIC_TABLE = "isHierarchicTable";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        INattableModelManager manager = this.getNattableModelManager();
        if (IS_NATTABLE_WIDGET.equals(property) && expectedValue instanceof Boolean) {
            return expectedValue.equals(manager != null);
        }
        if (manager != null && expectedValue instanceof Boolean) {
            if (HAS_FEATURE_ROW_HEADER_CONFIGURATION.equals(property)) {
                LabelConfigurationManagementUtils.getRowFeatureLabelConfigurationInTable(manager.getTable());
                return expectedValue.equals(LabelConfigurationManagementUtils.hasRowFeatureLabelConfiguration(manager.getTable()));
            }
            if (HAS_FEATURE_COLUMN_HEADER_CONFIGURATION.equals(property)) {
                return expectedValue.equals(LabelConfigurationManagementUtils.hasColumnFeatureLabelConfiguration(manager.getTable()));
            }
            if (HAS_SLAVE_COLUMNS_AXIS_PROVIDER.equals(property)) {
                return expectedValue.equals(AxisUtils.getAxisProviderUsedForColumns(manager) instanceof ISlaveAxisProvider);
            }
            if (HAS_SLAVE_ROWS_AXIS_PROVIDER.equals(property)) {
                return expectedValue.equals(AxisUtils.getAxisProviderUsedForRows(manager) instanceof ISlaveAxisProvider);
            }
            if (CAN_INVERT_AXIS.equals(property)) {
                return expectedValue.equals(manager.canInvertAxis());
            }
            if (IS_HIERARCHIC_TABLE.equals(property)) {
                return expectedValue.equals(NattableWidgetPropertyTester.isHierarchicTable(manager));
            }
        }
        return false;
    }

    public static final boolean isHierarchicTable(INattableModelManager tableManager) {
        DisplayStyle style = TableHelper.getTableDisplayStyle(tableManager);
        return DisplayStyle.HIERARCHIC_SINGLE_TREE_COLUMN.equals((Object)style) || DisplayStyle.HIERARCHIC_MULTI_TREE_COLUMN.equals((Object)style);
    }

    protected INattableModelManager getNattableModelManager() {
        IWorkbenchPage activePage;
        IWorkbenchWindow activeWorkbench;
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchPart current = null;
        if (workbench != null && (activeWorkbench = workbench.getActiveWorkbenchWindow()) != null && (activePage = activeWorkbench.getActivePage()) != null) {
            current = activePage.getActivePart();
        }
        if (current != null) {
            return (INattableModelManager)current.getAdapter(INattableModelManager.class);
        }
        return null;
    }
}

