/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.provider;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.EMFCommandOperation;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.hideshow.ColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.RowHideShowLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.command.SelectCellCommand;
import org.eclipse.nebula.widgets.nattable.selection.command.SelectColumnCommand;
import org.eclipse.nebula.widgets.nattable.selection.command.SelectRowsCommand;
import org.eclipse.papyrus.infra.emf.gmf.command.CheckedOperationHistory;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.command.ErrorTransactionalCommand;
import org.eclipse.papyrus.infra.nattable.manager.cell.CellManagerFactory;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.messages.Messages;
import org.eclipse.papyrus.infra.nattable.model.nattable.NattablePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.IAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.IPasteConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.LocalTableHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.NattableaxisconfigurationPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.PasteEObjectConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TreeFillingConfiguration;
import org.eclipse.papyrus.infra.nattable.parsers.CSVParser;
import org.eclipse.papyrus.infra.nattable.parsers.CellIterator;
import org.eclipse.papyrus.infra.nattable.parsers.RowIterator;
import org.eclipse.papyrus.infra.nattable.paste.IValueSetter;
import org.eclipse.papyrus.infra.nattable.paste.PastePostActionRegistry;
import org.eclipse.papyrus.infra.nattable.provider.PasteNattableCommandProvider;
import org.eclipse.papyrus.infra.nattable.utils.AxisConfigurationUtils;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.CSVPasteHelper;
import org.eclipse.papyrus.infra.nattable.utils.ExtendedCompoundCommand;
import org.eclipse.papyrus.infra.nattable.utils.FillingConfigurationUtils;
import org.eclipse.papyrus.infra.nattable.utils.InsertedElementInNattable;
import org.eclipse.papyrus.infra.nattable.utils.TableEditingDomainUtils;
import org.eclipse.papyrus.infra.nattable.utils.TableSelectionWrapper;
import org.eclipse.papyrus.infra.ui.converter.AbstractStringValueConverter;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;

public abstract class AbstractPasteInSelectionNattableCommandProvider
implements PasteNattableCommandProvider {
    private static final String PASTE_ROWS_JOB_NAME = Messages.PasteEObjectAxisInTableCommandProvider_PasteRows;
    private static final String PASTE_ACTION_TASK_NAME = Messages.PasteEObjectAxisInTableCommandProvider_PasteAction;
    private static final String PASTE_COMMAND_HAS_BEEN_CANCELLED = Messages.PasteEObjectAxisInTableCommandProvider_CommandCreationHasBeenCancelled;
    private static final String PASTE_COMMAND_CANT_BE_EXECUTED = Messages.AbstractPasteInSelectionNattableCommandProvider_TheCommandCantBeExecuted;
    private static final String PASTE_COMMAND_NAME = Messages.PasteEObjectAxisInTableCommandProvider_PasteFromStringCommand;
    protected INattableModelManager tableManager;
    protected List<String> postActions;
    protected final CSVPasteHelper pasteHelper;
    protected final Map<Class<? extends AbstractStringValueConverter>, AbstractStringValueConverter> existingConverters;
    private final int refreshEachReadChar = 1000;
    protected final Reader reader;
    protected final CSVParser parser;
    protected boolean detachedMode;
    private boolean isDisposed = false;
    protected final Table table;
    protected final TransactionalEditingDomain tableEditingDomain;
    protected final TransactionalEditingDomain contextEditingDomain;
    protected final EObject tableContext;
    private final int nbOperationsToDo;
    protected TableSelectionWrapper tableSelectionWrapper;
    protected boolean isSingleAxisPasted = false;
    protected long numberSelectedAxis = 0L;
    protected Map<Object, List<String>> pastedValues = null;
    private int firstRowPosition = 0;
    private int firstColumnPosition = 0;
    private int lastRowPosition = 0;
    private int lastColumnPosition = 0;
    protected IStatus statusResult = null;
    protected boolean pasteColumn;
    protected boolean isInsert;
    protected int currentUserAction = -1;
    protected int userAction = -1;

    public AbstractPasteInSelectionNattableCommandProvider(INattableModelManager tableManager, boolean pasteColumn, boolean isInsert, Reader reader, CSVPasteHelper pasteHelper, TableSelectionWrapper tableSelectionWrapper, int preferredUserAction, long totalSize) {
        this.tableManager = tableManager;
        this.existingConverters = new HashMap<Class<? extends AbstractStringValueConverter>, AbstractStringValueConverter>();
        this.pasteHelper = pasteHelper;
        this.reader = reader;
        this.table = tableManager.getTable();
        this.tableContext = this.table.getContext();
        this.tableEditingDomain = TableEditingDomainUtils.getTableEditingDomain(this.table);
        this.contextEditingDomain = TableEditingDomainUtils.getTableContextEditingDomain(this.table);
        this.tableSelectionWrapper = tableSelectionWrapper;
        this.numberSelectedAxis = 0L;
        this.isSingleAxisPasted = false;
        this.pastedValues = new LinkedHashMap<Object, List<String>>();
        this.pasteColumn = pasteColumn;
        this.isInsert = isInsert;
        this.userAction = preferredUserAction;
        long div = -1L;
        if (totalSize > Integer.MAX_VALUE) {
            div = totalSize / Integer.MAX_VALUE;
            if (div > Integer.MAX_VALUE) {
                div *= 2L;
            }
            this.nbOperationsToDo = (int)(totalSize / div);
        } else {
            this.nbOperationsToDo = (int)totalSize;
        }
        this.parser = this.pasteHelper.createParser(reader);
        this.init();
    }

    protected abstract void init();

    protected List<IPasteConfiguration> getPasteConfigurationFor(int depth) {
        ArrayList<IPasteConfiguration> pasteConfs = new ArrayList<IPasteConfiguration>();
        if (depth == 0 && FillingConfigurationUtils.hasTreeFillingConfigurationForDepth(this.table, depth)) {
            IPasteConfiguration conf = (IPasteConfiguration)AxisConfigurationUtils.getIAxisConfigurationUsedInTable(this.tableManager.getTable(), NattableaxisconfigurationPackage.eINSTANCE.getPasteEObjectConfiguration(), false);
            pasteConfs.add(conf);
        }
        if (pasteConfs.isEmpty()) {
            for (TreeFillingConfiguration current : FillingConfigurationUtils.getAllTreeFillingConfiguration(this.table)) {
                if (current.getDepth() != depth) continue;
                PasteEObjectConfiguration pasteConf = current.getPasteConfiguration();
                Assert.isNotNull((Object)pasteConf);
                pasteConfs.add((IPasteConfiguration)pasteConf);
            }
        }
        return pasteConfs;
    }

    protected IPasteConfiguration getPasteConfigurationsFor(int depth, String categoryName) {
        if (depth == 0 && !FillingConfigurationUtils.hasTreeFillingConfigurationForDepth(this.table, 0)) {
            LocalTableHeaderAxisConfiguration conf = this.table.getLocalRowHeaderAxisConfiguration();
            if (conf != null) {
                conf = this.table.getTableConfiguration().getRowHeaderAxisConfiguration();
            }
            List<TreeFillingConfiguration> filling = FillingConfigurationUtils.getAllTreeFillingConfigurationForDepth(this.table, depth);
            ArrayList<PasteEObjectConfiguration> referencedPasteConf = new ArrayList<PasteEObjectConfiguration>();
            for (TreeFillingConfiguration tmp : filling) {
                if (tmp.getPasteConfiguration() == null) continue;
                referencedPasteConf.add(tmp.getPasteConfiguration());
            }
            for (IAxisConfiguration axisConf : conf.getOwnedAxisConfigurations()) {
                if (!(axisConf instanceof IPasteConfiguration) || referencedPasteConf.contains(axisConf)) continue;
                return (IPasteConfiguration)axisConf;
            }
        }
        for (TreeFillingConfiguration curr : FillingConfigurationUtils.getAllTreeFillingConfiguration(this.table)) {
            Object element;
            if (curr.getDepth() != depth) continue;
            if (categoryName == null || categoryName.isEmpty()) {
                return curr.getPasteConfiguration();
            }
            String featureName = curr.getAxisUsedAsAxisProvider().getAlias();
            if ((featureName == null || "".equals(featureName)) && (element = curr.getAxisUsedAsAxisProvider().getElement()) instanceof EStructuralFeature) {
                featureName = ((EStructuralFeature)element).getName();
            }
            if (!categoryName.equals(featureName)) continue;
            return curr.getPasteConfiguration();
        }
        return null;
    }

    protected boolean isPasteInDetachedMode(Table table) {
        List<IPasteConfiguration> confs = this.getPasteConfigurationFor(0);
        for (IPasteConfiguration current : confs) {
            if (current == null || !current.isDetachedMode()) continue;
            return true;
        }
        return false;
    }

    @Override
    public IStatus executePasteFromStringCommand(boolean useProgressMonitor, boolean openDialog) {
        IStatus resultStatus = Status.OK_STATUS;
        if (this.isDisposed) {
            throw new RuntimeException("The command provider is disposed");
        }
        String pasteJobName = PASTE_ROWS_JOB_NAME;
        resultStatus = this.detachedMode ? this.executePasteFromStringCommand(useProgressMonitor, openDialog, pasteJobName, false) : this.executePasteFromStringCommand(useProgressMonitor, openDialog, pasteJobName, true);
        return resultStatus;
    }

    protected IStatus executePasteFromStringCommand(boolean useProgressMonitor, final boolean openDialog, String pasteJobName, final boolean attachedMode) {
        IStatus resultStatus = Status.OK_STATUS;
        HashMap<Object, Object> currentSharedMap = null;
        if (!attachedMode) {
            currentSharedMap = new HashMap<Object, Object>();
            currentSharedMap.put("pastedElementContainer", this.tableContext);
            currentSharedMap.put("referencesToSet", new ArrayList());
            currentSharedMap.put("cellsToAdd", new ArrayList());
            currentSharedMap.put("additionnal_post_actions_to_conclude_paste", new ArrayList());
        }
        final HashMap<Object, Object> sharedMap = currentSharedMap;
        if (!useProgressMonitor) {
            ICommand pasteCommand = this.getPasteFromStringCommand(this.contextEditingDomain, this.tableEditingDomain, openDialog, (IProgressMonitor)new NullProgressMonitor(), sharedMap, attachedMode);
            try {
                CheckedOperationHistory.getInstance().execute((IUndoableOperation)pasteCommand, (IProgressMonitor)new NullProgressMonitor(), null);
                resultStatus = pasteCommand.getCommandResult().getStatus();
            }
            catch (ExecutionException e) {
                resultStatus = new Status(4, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteInSelectionNattableCommandProvider_AnExceptionOccuredDuringThePaste, (Throwable)e);
            }
            if (sharedMap != null) {
                sharedMap.clear();
            }
        } else {
            UIJob job = new UIJob(pasteJobName){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    AbstractPasteInSelectionNattableCommandProvider.this.statusResult = Status.OK_STATUS;
                    ICommand pasteCommand = AbstractPasteInSelectionNattableCommandProvider.this.getPasteFromStringCommand(AbstractPasteInSelectionNattableCommandProvider.this.contextEditingDomain, AbstractPasteInSelectionNattableCommandProvider.this.tableEditingDomain, openDialog, monitor, sharedMap, attachedMode);
                    if (pasteCommand == null) {
                        AbstractPasteInSelectionNattableCommandProvider.this.statusResult = new Status(8, "org.eclipse.papyrus.infra.nattable", PASTE_COMMAND_HAS_BEEN_CANCELLED);
                    } else if (pasteCommand.canExecute()) {
                        block25: {
                            try {
                                try {
                                    if (attachedMode) {
                                        EMFCommandOperation op = new EMFCommandOperation(AbstractPasteInSelectionNattableCommandProvider.this.contextEditingDomain, (Command)new GMFtoEMFCommandWrapper(pasteCommand));
                                        CheckedOperationHistory.getInstance().execute((IUndoableOperation)op, monitor, null);
                                    } else {
                                        CheckedOperationHistory.getInstance().execute((IUndoableOperation)pasteCommand, monitor, null);
                                    }
                                    AbstractPasteInSelectionNattableCommandProvider.this.statusResult = pasteCommand.getCommandResult().getStatus();
                                }
                                catch (ExecutionException e) {
                                    AbstractPasteInSelectionNattableCommandProvider.this.statusResult = new Status(4, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteInSelectionNattableCommandProvider_AnExceptionOccuredDuringThePaste, (Throwable)e);
                                    if (sharedMap != null) {
                                        sharedMap.clear();
                                    }
                                    break block25;
                                }
                            }
                            catch (Throwable throwable) {
                                if (sharedMap != null) {
                                    sharedMap.clear();
                                }
                                throw throwable;
                            }
                            if (sharedMap != null) {
                                sharedMap.clear();
                            }
                        }
                        monitor.done();
                    } else {
                        if (sharedMap != null) {
                            sharedMap.clear();
                        }
                        AbstractPasteInSelectionNattableCommandProvider.this.statusResult = new Status(4, "org.eclipse.papyrus.infra.nattable", PASTE_COMMAND_CANT_BE_EXECUTED);
                    }
                    if (AbstractPasteInSelectionNattableCommandProvider.this.canContinue(AbstractPasteInSelectionNattableCommandProvider.this.statusResult)) {
                        AbstractPasteInSelectionNattableCommandProvider abstractPasteInSelectionNattableCommandProvider = AbstractPasteInSelectionNattableCommandProvider.this;
                        abstractPasteInSelectionNattableCommandProvider.lastColumnPosition = abstractPasteInSelectionNattableCommandProvider.lastColumnPosition - 1;
                        AbstractPasteInSelectionNattableCommandProvider abstractPasteInSelectionNattableCommandProvider2 = AbstractPasteInSelectionNattableCommandProvider.this;
                        abstractPasteInSelectionNattableCommandProvider2.lastRowPosition = abstractPasteInSelectionNattableCommandProvider2.lastRowPosition - 1;
                        SelectionLayer selectionLayer = AbstractPasteInSelectionNattableCommandProvider.this.tableManager.getBodyLayerStack().getSelectionLayer();
                        if (AbstractPasteInSelectionNattableCommandProvider.this.tableSelectionWrapper != null) {
                            if (!AbstractPasteInSelectionNattableCommandProvider.this.tableSelectionWrapper.getFullySelectedRows().isEmpty()) {
                                selectionLayer.doCommand((ILayerCommand)new SelectRowsCommand((ILayer)selectionLayer, 0, AbstractPasteInSelectionNattableCommandProvider.this.firstRowPosition, false, false));
                                if (AbstractPasteInSelectionNattableCommandProvider.this.firstRowPosition != AbstractPasteInSelectionNattableCommandProvider.this.lastRowPosition) {
                                    selectionLayer.doCommand((ILayerCommand)new SelectRowsCommand((ILayer)selectionLayer, 0, AbstractPasteInSelectionNattableCommandProvider.this.lastRowPosition, true, false));
                                }
                            } else if (!AbstractPasteInSelectionNattableCommandProvider.this.tableSelectionWrapper.getFullySelectedColumns().isEmpty() && AbstractPasteInSelectionNattableCommandProvider.this.pasteColumn) {
                                selectionLayer.doCommand((ILayerCommand)new SelectColumnCommand((ILayer)selectionLayer, AbstractPasteInSelectionNattableCommandProvider.this.firstColumnPosition, 0, false, false));
                                if (AbstractPasteInSelectionNattableCommandProvider.this.firstColumnPosition != AbstractPasteInSelectionNattableCommandProvider.this.lastColumnPosition) {
                                    selectionLayer.doCommand((ILayerCommand)new SelectColumnCommand((ILayer)selectionLayer, AbstractPasteInSelectionNattableCommandProvider.this.lastColumnPosition, 0, true, false));
                                }
                            } else {
                                selectionLayer.doCommand((ILayerCommand)new SelectCellCommand((ILayer)selectionLayer, AbstractPasteInSelectionNattableCommandProvider.this.firstColumnPosition, AbstractPasteInSelectionNattableCommandProvider.this.firstRowPosition, false, false));
                                if (AbstractPasteInSelectionNattableCommandProvider.this.firstColumnPosition != AbstractPasteInSelectionNattableCommandProvider.this.lastColumnPosition || AbstractPasteInSelectionNattableCommandProvider.this.firstRowPosition != AbstractPasteInSelectionNattableCommandProvider.this.lastRowPosition) {
                                    selectionLayer.doCommand((ILayerCommand)new SelectCellCommand((ILayer)selectionLayer, AbstractPasteInSelectionNattableCommandProvider.this.lastColumnPosition, AbstractPasteInSelectionNattableCommandProvider.this.lastRowPosition, true, false));
                                }
                            }
                        }
                    }
                    AbstractPasteInSelectionNattableCommandProvider.this.tableManager = null;
                    AbstractPasteInSelectionNattableCommandProvider.this.tableSelectionWrapper = null;
                    if (openDialog) {
                        AbstractPasteInSelectionNattableCommandProvider.this.displayDialog(AbstractPasteInSelectionNattableCommandProvider.this.statusResult);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
            resultStatus = this.statusResult;
        }
        return resultStatus;
    }

    protected void displayDialog(IStatus result) {
        if (result != null && result.getSeverity() != 0) {
            String messageDialog = null;
            switch (result.getSeverity()) {
                case 1: {
                    messageDialog = Messages.PasteInTableHandler_PasteInformation;
                    break;
                }
                case 2: {
                    messageDialog = Messages.PasteInTableHandler_PasteWarning;
                    break;
                }
                case 4: {
                    messageDialog = Messages.PasteInTableHandler_PasteError;
                    break;
                }
                case 8: {
                    messageDialog = Messages.PasteInTableHandler_PasteCancelled;
                }
            }
            ErrorDialog errorDialog = new ErrorDialog(Display.getDefault().getActiveShell(), Messages.PasteImportStatusDialog_ImportPasteDialogTitle, messageDialog, result, 7){

                protected void configureShell(Shell shell) {
                    super.configureShell(shell);
                    shell.setImage(org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("/icons/papyrus.png"));
                }
            };
            errorDialog.open();
        }
    }

    protected ICommand getPasteFromStringCommand(TransactionalEditingDomain contextEditingDomain, TransactionalEditingDomain tableEditingDomain, boolean openDialog, IProgressMonitor progressMonitor, Map<Object, Object> sharedMap, boolean attachedMode) {
        ErrorTransactionalCommand resultCommand = null;
        if (this.tableSelectionWrapper == null) {
            IStatus canPasteStatus = this.canPasteWithoutSelection();
            resultCommand = 4 != canPasteStatus.getSeverity() ? this.getPasteRowsFromStringCommand(contextEditingDomain, tableEditingDomain, null, openDialog, progressMonitor, sharedMap, attachedMode) : new ErrorTransactionalCommand(contextEditingDomain, PASTE_COMMAND_NAME, null, canPasteStatus);
        } else {
            Map<Integer, Object> fullySelectedRows = this.tableSelectionWrapper.getFullySelectedRows();
            if (!fullySelectedRows.isEmpty()) {
                IStatus canPasteStatus = this.canPasteRows(fullySelectedRows);
                resultCommand = 4 != canPasteStatus.getSeverity() ? this.getPasteRowsFromStringCommand(contextEditingDomain, tableEditingDomain, fullySelectedRows, openDialog, progressMonitor, sharedMap, attachedMode) : new ErrorTransactionalCommand(contextEditingDomain, PASTE_COMMAND_NAME, null, canPasteStatus);
            } else {
                Map<Integer, Object> fullySelectedColumns = this.tableSelectionWrapper.getFullySelectedColumns();
                if (!fullySelectedColumns.isEmpty() && this.pasteColumn) {
                    IStatus canPasteStatus = this.canPasteColumns(fullySelectedColumns);
                    if (4 != canPasteStatus.getSeverity()) {
                        resultCommand = this.getPasteColumnsFromStringCommand(contextEditingDomain, tableEditingDomain, fullySelectedColumns, openDialog, progressMonitor, sharedMap, attachedMode);
                    } else {
                        LinkedHashMap<Object, List<String>> returnedPastedValues = new LinkedHashMap<Object, List<String>>();
                        if (!this.pastedValues.isEmpty()) {
                            for (Object o : this.pastedValues.keySet()) {
                                int i = 0;
                                for (String s : this.pastedValues.get(o)) {
                                    if (returnedPastedValues.get(i) == null) {
                                        returnedPastedValues.put(i, new ArrayList());
                                    }
                                    ((List)returnedPastedValues.get(i)).add(s);
                                    ++i;
                                }
                            }
                            this.pastedValues = returnedPastedValues;
                            if (this.pastedValues.size() == 1 && fullySelectedColumns.size() == this.pastedValues.get(this.pastedValues.keySet().iterator().next()).size()) {
                                this.isSingleAxisPasted = true;
                                this.numberSelectedAxis = this.tableManager.getBodyLayerStack().getRowHideShowLayer().getRowCount();
                                resultCommand = this.getPasteCellsRowFromStringCommand(contextEditingDomain, tableEditingDomain, this.tableSelectionWrapper.getSelectedCells(), openDialog, progressMonitor, sharedMap, attachedMode);
                            }
                        }
                        if (resultCommand == null) {
                            resultCommand = new ErrorTransactionalCommand(contextEditingDomain, PASTE_COMMAND_NAME, null, canPasteStatus);
                        }
                    }
                } else {
                    Collection<PositionCoordinate> selectedCells = this.tableSelectionWrapper.getSelectedCells();
                    if (!selectedCells.isEmpty()) {
                        IStatus canPasteStatus = this.canPasteCells(selectedCells);
                        resultCommand = 4 != canPasteStatus.getSeverity() ? this.getPasteCellsRowFromStringCommand(contextEditingDomain, tableEditingDomain, selectedCells, openDialog, progressMonitor, sharedMap, attachedMode) : new ErrorTransactionalCommand(contextEditingDomain, PASTE_COMMAND_NAME, null, canPasteStatus);
                    }
                }
            }
        }
        return resultCommand;
    }

    protected IStatus canPasteWithoutSelection() {
        IStatus result = Status.OK_STATUS;
        RowIterator rowIter = this.parser.parse();
        int nbRowRead = -1;
        int nbColumnRead = 0;
        while (rowIter.hasNext()) {
            ArrayList<String> valuesByRow = new ArrayList<String>();
            CellIterator cellIter = (CellIterator)rowIter.next();
            int nbColumnReadByRow = 0;
            if (cellIter.hasNext()) {
                while (cellIter.hasNext()) {
                    valuesByRow.add((String)cellIter.next());
                    ++nbColumnReadByRow;
                }
            }
            nbColumnRead = nbColumnRead >= nbColumnReadByRow ? nbColumnRead : nbColumnReadByRow;
            ++nbRowRead;
            if (!rowIter.hasNext()) continue;
            this.pastedValues.put(nbRowRead, valuesByRow);
        }
        if (this.tableManager.getColumnCount() != nbColumnRead) {
            result = new Status(4, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteInSelectionNattableCommandProvider_readcolumnsexceedsexistingcolumns);
        }
        return result;
    }

    protected IStatus canPasteCells(Collection<PositionCoordinate> selectedCells) {
        IStatus result = Status.OK_STATUS;
        RowIterator rowIter = this.parser.parse();
        int nbRowRead = -1;
        int nbColumnRead = 0;
        while (rowIter.hasNext()) {
            ArrayList<String> valuesByRow = new ArrayList<String>();
            CellIterator cellIter = (CellIterator)rowIter.next();
            int nbColumnReadByRow = 0;
            if (cellIter.hasNext()) {
                while (cellIter.hasNext()) {
                    valuesByRow.add((String)cellIter.next());
                    ++nbColumnReadByRow;
                }
            }
            nbColumnRead = nbColumnRead >= nbColumnReadByRow ? nbColumnRead : nbColumnReadByRow;
            ++nbRowRead;
            if (!rowIter.hasNext()) continue;
            this.pastedValues.put(nbRowRead, valuesByRow);
        }
        if (selectedCells.size() > 1) {
            Iterator<PositionCoordinate> selectedCellsIterator = selectedCells.iterator();
            PositionCoordinate minCoordinate = null;
            PositionCoordinate maxCoordinate = null;
            while (selectedCellsIterator.hasNext()) {
                PositionCoordinate currentSelectedCell = selectedCellsIterator.next();
                if (minCoordinate == null || minCoordinate.getRowPosition() > currentSelectedCell.getRowPosition() || minCoordinate.getColumnPosition() > currentSelectedCell.getColumnPosition()) {
                    minCoordinate = currentSelectedCell;
                }
                if (maxCoordinate != null && maxCoordinate.getRowPosition() >= currentSelectedCell.getRowPosition() && maxCoordinate.getColumnPosition() >= currentSelectedCell.getColumnPosition()) continue;
                maxCoordinate = currentSelectedCell;
            }
            int nbRowSelected = maxCoordinate.getRowPosition() - minCoordinate.getRowPosition() + 1;
            int nbColumnSelected = maxCoordinate.getColumnPosition() - minCoordinate.getColumnPosition() + 1;
            if (nbRowRead > 1 && nbRowRead != nbRowSelected) {
                result = new Status(4, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteInSelectionNattableCommandProvider_readrowsexceedsexistingrows);
            } else if (nbColumnRead != nbColumnSelected) {
                result = new Status(4, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteInSelectionNattableCommandProvider_readcolumnsexceedsexistingcolumns);
            } else if (1 == nbRowRead) {
                this.isSingleAxisPasted = true;
                this.numberSelectedAxis = nbRowSelected;
            }
        }
        return result;
    }

    protected IStatus canPasteRows(Map<Integer, Object> rows) {
        IStatus result = Status.OK_STATUS;
        RowIterator rowIter = this.parser.parse();
        int nbRowRead = -1;
        int nbColumnRead = 0;
        while (rowIter.hasNext()) {
            ArrayList<String> valuesByRow = new ArrayList<String>();
            CellIterator cellIter = (CellIterator)rowIter.next();
            int nbColumnReadByRow = 0;
            if (cellIter.hasNext()) {
                while (cellIter.hasNext()) {
                    valuesByRow.add((String)cellIter.next());
                    ++nbColumnReadByRow;
                }
            }
            nbColumnRead = nbColumnRead >= nbColumnReadByRow ? nbColumnRead : nbColumnReadByRow;
            ++nbRowRead;
            if (!rowIter.hasNext()) continue;
            this.pastedValues.put(nbRowRead, valuesByRow);
        }
        int nbRowsSelected = rows.size();
        int nbColumnsSelected = this.tableManager.getBodyLayerStack().getRowHideShowLayer().getColumnCount();
        if (nbColumnsSelected != nbColumnRead) {
            result = new Status(4, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteInSelectionNattableCommandProvider_readcolumnsexceedsexistingcolumns);
        } else if (nbRowRead != nbRowsSelected) {
            result = new Status(4, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteInSelectionNattableCommandProvider_readrowsexceedsexistingrows);
        }
        return result;
    }

    protected IStatus canPasteColumns(Map<Integer, Object> columns) {
        IStatus result = Status.OK_STATUS;
        RowIterator rowIter = this.parser.parse();
        int nbRowRead = -1;
        int nbColumnRead = 0;
        while (rowIter.hasNext()) {
            CellIterator cellIter = (CellIterator)rowIter.next();
            int nbColumnReadByRow = 0;
            if (cellIter.hasNext()) {
                while (cellIter.hasNext()) {
                    if (this.pastedValues.get(nbColumnReadByRow) == null) {
                        this.pastedValues.put(nbColumnReadByRow, new ArrayList());
                    }
                    this.pastedValues.get(nbColumnReadByRow).add((String)cellIter.next());
                    ++nbColumnReadByRow;
                }
            }
            nbColumnRead = nbColumnRead >= nbColumnReadByRow ? nbColumnRead : nbColumnReadByRow;
            ++nbRowRead;
        }
        int nbRowsSelected = this.tableManager.getBodyLayerStack().getRowHideShowLayer().getRowCount();
        int nbColumnsSelected = columns.size();
        if (nbRowRead != nbRowsSelected) {
            result = new Status(4, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteInSelectionNattableCommandProvider_readrowsexceedsexistingrows);
        } else if (1 == nbColumnRead && 1 < nbColumnsSelected) {
            this.isSingleAxisPasted = true;
            this.numberSelectedAxis = nbColumnsSelected;
        } else if (nbColumnRead != nbColumnsSelected) {
            result = new Status(4, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteInSelectionNattableCommandProvider_readcolumnsexceedsexistingcolumns);
        }
        return result;
    }

    protected ICommand getPasteCellsRowFromStringCommand(TransactionalEditingDomain contextEditingDomain, final TransactionalEditingDomain tableEditingDomain, final Collection<PositionCoordinate> selectedCells, boolean openDialog, final IProgressMonitor progressMonitor, final Map<Object, Object> sharedMap, boolean attachedMode) {
        if (progressMonitor != null) {
            progressMonitor.beginTask(PASTE_ACTION_TASK_NAME, this.nbOperationsToDo);
        }
        AbstractTransactionalCommand pasteAllCommand = new AbstractTransactionalCommand(contextEditingDomain, PASTE_COMMAND_NAME, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                MultiStatus resultStatus = new MultiStatus("org.eclipse.papyrus.infra.nattable", 0, Messages.AbstractPasteInSelectionNattableCommandProvider_ThePasteHasBeenDoneWithSomeProblems, null);
                long readChar = 0L;
                long previousreadChar = 0L;
                PositionCoordinate firstpositionCoordinate = (PositionCoordinate)selectedCells.iterator().next();
                AbstractPasteInSelectionNattableCommandProvider.this.firstRowPosition = firstpositionCoordinate.getRowPosition();
                AbstractPasteInSelectionNattableCommandProvider.this.firstColumnPosition = firstpositionCoordinate.getColumnPosition();
                AbstractPasteInSelectionNattableCommandProvider.this.lastRowPosition = AbstractPasteInSelectionNattableCommandProvider.this.firstRowPosition;
                AbstractPasteInSelectionNattableCommandProvider.this.lastColumnPosition = AbstractPasteInSelectionNattableCommandProvider.this.firstColumnPosition;
                RowHideShowLayer rowHideShowLayer = AbstractPasteInSelectionNattableCommandProvider.this.tableManager.getBodyLayerStack().getRowHideShowLayer();
                ColumnHideShowLayer columnHideShowLayer = AbstractPasteInSelectionNattableCommandProvider.this.tableManager.getBodyLayerStack().getColumnHideShowLayer();
                CompoundCommand compoundCommand = new CompoundCommand("Paste action");
                Iterator<Object> rowIter = AbstractPasteInSelectionNattableCommandProvider.this.pastedValues.keySet().iterator();
                Collection rowValuesAsString = new ArrayList();
                while ((!AbstractPasteInSelectionNattableCommandProvider.this.isSingleAxisPasted && rowIter.hasNext() || AbstractPasteInSelectionNattableCommandProvider.this.isSingleAxisPasted && AbstractPasteInSelectionNattableCommandProvider.this.numberSelectedAxis > 0L) && AbstractPasteInSelectionNattableCommandProvider.this.canContinue((IStatus)resultStatus)) {
                    if (AbstractPasteInSelectionNattableCommandProvider.this.isSingleAxisPasted) {
                        --AbstractPasteInSelectionNattableCommandProvider.this.numberSelectedAxis;
                    }
                    if (!AbstractPasteInSelectionNattableCommandProvider.this.isSingleAxisPasted || AbstractPasteInSelectionNattableCommandProvider.this.firstRowPosition >= AbstractPasteInSelectionNattableCommandProvider.this.lastRowPosition) {
                        rowValuesAsString = AbstractPasteInSelectionNattableCommandProvider.this.pastedValues.get(rowIter.next());
                    }
                    if (!rowValuesAsString.isEmpty()) {
                        int realRowIndex;
                        Object rowElement;
                        int nbColmnRead = AbstractPasteInSelectionNattableCommandProvider.this.firstColumnPosition;
                        Iterator cellIter = rowValuesAsString.iterator();
                        if (progressMonitor != null && progressMonitor.isCanceled()) {
                            progressMonitor.done();
                            AbstractPasteInSelectionNattableCommandProvider.this.localDispose();
                            return CommandResult.newCancelledCommandResult();
                        }
                        previousreadChar = AbstractPasteInSelectionNattableCommandProvider.this.parser.getReadCharacters();
                        if (progressMonitor != null && (readChar += AbstractPasteInSelectionNattableCommandProvider.this.parser.getReadCharacters() - previousreadChar) > 1000L) {
                            readChar = 0L;
                            progressMonitor.worked(1000);
                        }
                        if (!((rowElement = AxisUtils.getRepresentedElement(AbstractPasteInSelectionNattableCommandProvider.this.tableManager.getRowElement(realRowIndex = rowHideShowLayer.getRowIndexByPosition(AbstractPasteInSelectionNattableCommandProvider.this.lastRowPosition)))) instanceof TreeFillingConfiguration)) {
                            while (cellIter.hasNext() && AbstractPasteInSelectionNattableCommandProvider.this.canContinue((IStatus)resultStatus)) {
                                String valueAsString = (String)cellIter.next();
                                int realColumnIndex = columnHideShowLayer.getColumnIndexByPosition(nbColmnRead);
                                Object columnElement = AxisUtils.getRepresentedElement(AbstractPasteInSelectionNattableCommandProvider.this.tableManager.getColumnElement(realColumnIndex));
                                boolean isEditable = CellManagerFactory.INSTANCE.isCellEditable(columnElement, rowElement, sharedMap);
                                if (isEditable) {
                                    AbstractStringValueConverter converter = CellManagerFactory.INSTANCE.getOrCreateStringValueConverterClass(columnElement, rowElement, AbstractPasteInSelectionNattableCommandProvider.this.tableManager, AbstractPasteInSelectionNattableCommandProvider.this.existingConverters, AbstractPasteInSelectionNattableCommandProvider.this.pasteHelper.getMultiValueSeparator());
                                    Command command = CellManagerFactory.INSTANCE.getSetStringValueCommand(tableEditingDomain, columnElement, rowElement, valueAsString, converter, AbstractPasteInSelectionNattableCommandProvider.this.tableManager);
                                    IStatus commandStatus = AbstractPasteInSelectionNattableCommandProvider.this.getStatusCommand(command);
                                    if (!commandStatus.isOK()) {
                                        resultStatus.add(commandStatus);
                                    } else {
                                        compoundCommand.append(command);
                                    }
                                } else if (AbstractPasteInSelectionNattableCommandProvider.this.isValidValue(valueAsString)) {
                                    resultStatus.add((IStatus)new Status(2, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteInSelectionNattableCommandProvider_NonEditableCellTriedToBeOverwrited));
                                }
                                ++nbColmnRead;
                            }
                            if (AbstractPasteInSelectionNattableCommandProvider.this.lastColumnPosition < nbColmnRead) {
                                AbstractPasteInSelectionNattableCommandProvider.this.lastColumnPosition = nbColmnRead;
                            }
                        }
                    }
                    AbstractPasteInSelectionNattableCommandProvider abstractPasteInSelectionNattableCommandProvider = AbstractPasteInSelectionNattableCommandProvider.this;
                    abstractPasteInSelectionNattableCommandProvider.lastRowPosition = abstractPasteInSelectionNattableCommandProvider.lastRowPosition + 1;
                }
                progressMonitor.done();
                AbstractPasteInSelectionNattableCommandProvider.this.localDispose();
                if (AbstractPasteInSelectionNattableCommandProvider.this.canContinue((IStatus)resultStatus) && compoundCommand != null && !compoundCommand.isEmpty() && compoundCommand.canExecute()) {
                    tableEditingDomain.getCommandStack().execute((Command)compoundCommand);
                    return new CommandResult((IStatus)resultStatus);
                }
                if (!resultStatus.isOK()) {
                    MultiStatus errorStatus = new MultiStatus("org.eclipse.papyrus.infra.nattable", 4, Messages.AbstractPasteInSelectionNattableCommandProvider_ThePasteHasNotBeenDoneBecauseOfSomeProblems, null);
                    if (resultStatus.isMultiStatus()) {
                        IStatus[] iStatusArray = resultStatus.getChildren();
                        int n = iStatusArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IStatus subStatus = iStatusArray[n2];
                            errorStatus.add(subStatus);
                            ++n2;
                        }
                    } else {
                        errorStatus.add((IStatus)resultStatus);
                    }
                    errorStatus.add((IStatus)new Status(4, "org.eclipse.papyrus.infra.nattable", null));
                    resultStatus = errorStatus;
                }
                return new CommandResult((IStatus)resultStatus);
            }
        };
        return pasteAllCommand;
    }

    protected ICommand getPasteRowsFromStringCommand(final TransactionalEditingDomain contextEditingDomain, final TransactionalEditingDomain tableEditingDomain, final Map<Integer, Object> rows, final boolean openDialog, final IProgressMonitor progressMonitor, final Map<Object, Object> sharedMap, final boolean attachedMode) {
        if (progressMonitor != null) {
            progressMonitor.beginTask(PASTE_ACTION_TASK_NAME, this.nbOperationsToDo);
        }
        AbstractTransactionalCommand pasteAllCommand = new AbstractTransactionalCommand(contextEditingDomain, PASTE_COMMAND_NAME, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                IStatus resultStatus = Status.OK_STATUS;
                int axisIdentifierIndex = AbstractPasteInSelectionNattableCommandProvider.this.getColumnIndexOfAxisIdentifier();
                if (-1 == axisIdentifierIndex) {
                    resultStatus = new Status(4, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteInSelectionNattableCommandProvider_TheAxisUsedAsIdentifierNotAvailable);
                }
                ExtendedCompoundCommand compoundCommand = new ExtendedCompoundCommand("Paste action");
                ArrayList<InsertedElementInNattable> objectsToAdd = new ArrayList<InsertedElementInNattable>();
                if (AbstractPasteInSelectionNattableCommandProvider.this.canContinue(resultStatus)) {
                    MultiStatus multiStatus = new MultiStatus("org.eclipse.papyrus.infra.nattable", 0, Messages.AbstractPasteInSelectionNattableCommandProvider_ThePasteHasBeenDoneWithSomeProblems, null);
                    long readChar = 0L;
                    long previousreadChar = 0L;
                    int initialFirstRowPosition = -1;
                    if (rows != null) {
                        Iterator iterator = rows.keySet().iterator();
                        while (iterator.hasNext()) {
                            int rowIndex = (Integer)iterator.next();
                            if (-1 != initialFirstRowPosition && rowIndex >= initialFirstRowPosition) continue;
                            initialFirstRowPosition = rowIndex;
                        }
                    }
                    AbstractPasteInSelectionNattableCommandProvider.this.firstRowPosition = AbstractPasteInSelectionNattableCommandProvider.this.tableManager.getBodyLayerStack().getRowHideShowLayer().getRowPositionByIndex(initialFirstRowPosition);
                    AbstractPasteInSelectionNattableCommandProvider.this.firstColumnPosition = 0;
                    AbstractPasteInSelectionNattableCommandProvider.this.lastRowPosition = AbstractPasteInSelectionNattableCommandProvider.this.firstRowPosition;
                    AbstractPasteInSelectionNattableCommandProvider.this.lastColumnPosition = AbstractPasteInSelectionNattableCommandProvider.this.firstColumnPosition;
                    int noIndex = 0;
                    if (-1 != AbstractPasteInSelectionNattableCommandProvider.this.firstRowPosition) {
                        noIndex = AbstractPasteInSelectionNattableCommandProvider.this.firstRowPosition;
                    }
                    EObject parentContext = AbstractPasteInSelectionNattableCommandProvider.this.getContentOfSelection(rows, noIndex);
                    Object firstRowElementSelected = AbstractPasteInSelectionNattableCommandProvider.this.tableManager.getRowElement(noIndex);
                    int parentDepth = AbstractPasteInSelectionNattableCommandProvider.this.getDepthFromObject(firstRowElementSelected);
                    String parentCategory = AbstractPasteInSelectionNattableCommandProvider.this.getCategoryFromObject(firstRowElementSelected);
                    int initialFirstIndexInParent = -1;
                    if (-1 != AbstractPasteInSelectionNattableCommandProvider.this.firstRowPosition) {
                        initialFirstIndexInParent = AbstractPasteInSelectionNattableCommandProvider.this.getFirstSelectedElementIndexOfTableContext(rows, AbstractPasteInSelectionNattableCommandProvider.this.firstRowPosition, parentContext);
                    }
                    ColumnHideShowLayer columnHideShowLayer = AbstractPasteInSelectionNattableCommandProvider.this.tableManager.getBodyLayerStack().getColumnHideShowLayer();
                    Iterator<Object> rowIter = AbstractPasteInSelectionNattableCommandProvider.this.pastedValues.keySet().iterator();
                    while (rowIter.hasNext() && AbstractPasteInSelectionNattableCommandProvider.this.canContinue((IStatus)multiStatus)) {
                        String identifierValue;
                        List<String> rowValuesAsString = AbstractPasteInSelectionNattableCommandProvider.this.pastedValues.get(rowIter.next());
                        if (!rowValuesAsString.isEmpty() && !(identifierValue = rowValuesAsString.get(axisIdentifierIndex)).isEmpty()) {
                            int rowIndexToModify = -1;
                            boolean sameMultipleIdentifier = false;
                            if (rows != null) {
                                Iterator selectedRowsIndex = rows.keySet().iterator();
                                while (selectedRowsIndex.hasNext() && AbstractPasteInSelectionNattableCommandProvider.this.canContinue((IStatus)multiStatus)) {
                                    int selectedRowIndex = (Integer)selectedRowsIndex.next();
                                    if (!identifierValue.equals(AbstractPasteInSelectionNattableCommandProvider.this.tableManager.getDataValue(axisIdentifierIndex, selectedRowIndex))) continue;
                                    if (-1 < rowIndexToModify) {
                                        sameMultipleIdentifier = true;
                                        continue;
                                    }
                                    rowIndexToModify = selectedRowIndex;
                                }
                            } else {
                                int counter = 0;
                                while (counter < AbstractPasteInSelectionNattableCommandProvider.this.tableManager.getRowCount() && AbstractPasteInSelectionNattableCommandProvider.this.canContinue((IStatus)multiStatus)) {
                                    if (identifierValue.equals(AbstractPasteInSelectionNattableCommandProvider.this.tableManager.getDataValue(axisIdentifierIndex, counter))) {
                                        if (-1 < rowIndexToModify) {
                                            sameMultipleIdentifier = true;
                                        } else {
                                            rowIndexToModify = counter;
                                        }
                                    }
                                    ++counter;
                                }
                            }
                            AbstractPasteInSelectionNattableCommandProvider.this.manageUserAction(rowIndexToModify, AbstractPasteInSelectionNattableCommandProvider.this.isInsert, openDialog, identifierValue, multiStatus);
                            if (sameMultipleIdentifier && AbstractPasteInSelectionNattableCommandProvider.this.currentUserAction == 0) {
                                multiStatus.add((IStatus)new Status(4, "org.eclipse.papyrus.infra.nattable", String.format(Messages.AbstractPasteInSelectionNattableCommandProvider_MultipleSelectedRowsCorrespondingForIdentifier, identifierValue)));
                            }
                            Object rowElement = null;
                            boolean createdElement = false;
                            if (3 == AbstractPasteInSelectionNattableCommandProvider.this.currentUserAction) {
                                throw new OperationCanceledException();
                            }
                            if (1 == AbstractPasteInSelectionNattableCommandProvider.this.currentUserAction && AbstractPasteInSelectionNattableCommandProvider.this.isInsert) {
                                int currentDepth = parentDepth;
                                String currentCategory = parentCategory;
                                EObject currentContext = parentContext;
                                if (-1 != rowIndexToModify) {
                                    Object object = AbstractPasteInSelectionNattableCommandProvider.this.tableManager.getRowElement(rowIndexToModify);
                                    currentDepth = AbstractPasteInSelectionNattableCommandProvider.this.getDepthFromObject(object);
                                    currentCategory = AbstractPasteInSelectionNattableCommandProvider.this.getCategoryFromObject(object);
                                    Object element = AxisUtils.getRepresentedElement(object);
                                    currentContext = ((EObject)element).eContainer();
                                }
                                PasteEObjectConfiguration currentPasteConfiguration = AbstractPasteInSelectionNattableCommandProvider.this.getPasteConfiguration(AbstractPasteInSelectionNattableCommandProvider.this.table, currentDepth, currentCategory);
                                EStructuralFeature containementFeature = currentPasteConfiguration.getPasteElementContainementFeature();
                                IElementType elementType = ElementTypeRegistry.getInstance().getType(currentPasteConfiguration.getPastedElementId());
                                rowElement = AbstractPasteInSelectionNattableCommandProvider.this.detachedMode ? AbstractPasteInSelectionNattableCommandProvider.this.getRowElementCreatedInDetachedMode(containementFeature, elementType, progressMonitor, info, compoundCommand) : AbstractPasteInSelectionNattableCommandProvider.this.getRowElementCreatedInAttachedMode(currentContext, containementFeature, elementType, progressMonitor, info, compoundCommand);
                                if (rowElement != null) {
                                    int indexInParent = -1;
                                    int indexInTable = -1;
                                    if (currentContext.equals(parentContext)) {
                                        indexInParent = initialFirstIndexInParent;
                                        indexInTable = initialFirstRowPosition;
                                    }
                                    InsertedElementInNattable foundInsertedElement = null;
                                    Iterator objectsToAddIterator = objectsToAdd.iterator();
                                    while (objectsToAddIterator.hasNext() && foundInsertedElement == null) {
                                        InsertedElementInNattable insertedElement = (InsertedElementInNattable)objectsToAddIterator.next();
                                        if (!insertedElement.equals(currentContext) || !insertedElement.getContainementFeature().equals(containementFeature)) continue;
                                        foundInsertedElement = insertedElement;
                                    }
                                    if (foundInsertedElement == null) {
                                        foundInsertedElement = new InsertedElementInNattable(currentContext, containementFeature, indexInParent, indexInTable);
                                        objectsToAdd.add(foundInsertedElement);
                                    }
                                    foundInsertedElement.addCreatedElement(rowElement);
                                    createdElement = true;
                                } else {
                                    multiStatus.add((IStatus)new Status(4, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteInSelectionNattableCommandProvider_ElementCantBeAdded));
                                }
                                AbstractPasteInSelectionNattableCommandProvider abstractPasteInSelectionNattableCommandProvider = AbstractPasteInSelectionNattableCommandProvider.this;
                                abstractPasteInSelectionNattableCommandProvider.lastRowPosition = abstractPasteInSelectionNattableCommandProvider.lastRowPosition + 1;
                            }
                            if (rowElement == null) {
                                rowElement = AxisUtils.getRepresentedElement(AbstractPasteInSelectionNattableCommandProvider.this.tableManager.getRowElement(rowIndexToModify));
                            }
                            if (AbstractPasteInSelectionNattableCommandProvider.this.currentUserAction == 0 || 1 == AbstractPasteInSelectionNattableCommandProvider.this.currentUserAction) {
                                int nbColmnRead = AbstractPasteInSelectionNattableCommandProvider.this.firstColumnPosition;
                                Iterator<String> cellIter = rowValuesAsString.iterator();
                                if (progressMonitor != null && progressMonitor.isCanceled()) {
                                    progressMonitor.done();
                                    AbstractPasteInSelectionNattableCommandProvider.this.localDispose();
                                    return CommandResult.newCancelledCommandResult();
                                }
                                previousreadChar = AbstractPasteInSelectionNattableCommandProvider.this.parser.getReadCharacters();
                                if (progressMonitor != null && (readChar += AbstractPasteInSelectionNattableCommandProvider.this.parser.getReadCharacters() - previousreadChar) > 1000L) {
                                    readChar = 0L;
                                    progressMonitor.worked(1000);
                                }
                                while (cellIter.hasNext() && AbstractPasteInSelectionNattableCommandProvider.this.canContinue((IStatus)multiStatus)) {
                                    boolean isEditable;
                                    String valueAsString = cellIter.next();
                                    int realColumnIndex = columnHideShowLayer.getColumnIndexByPosition(nbColmnRead);
                                    Object columnElement = AbstractPasteInSelectionNattableCommandProvider.this.getColumnElement(realColumnIndex);
                                    boolean bl = isEditable = sharedMap == null ? CellManagerFactory.INSTANCE.isCellEditable(columnElement, rowElement) : CellManagerFactory.INSTANCE.isCellEditable(columnElement, rowElement, sharedMap);
                                    if (isEditable) {
                                        AbstractStringValueConverter converter = CellManagerFactory.INSTANCE.getOrCreateStringValueConverterClass(columnElement, rowElement, AbstractPasteInSelectionNattableCommandProvider.this.tableManager, AbstractPasteInSelectionNattableCommandProvider.this.existingConverters, AbstractPasteInSelectionNattableCommandProvider.this.pasteHelper.getMultiValueSeparator());
                                        if (!createdElement || attachedMode) {
                                            Command command = CellManagerFactory.INSTANCE.getSetStringValueCommand(tableEditingDomain, columnElement, rowElement, valueAsString, converter, AbstractPasteInSelectionNattableCommandProvider.this.tableManager);
                                            IStatus commandStatus = AbstractPasteInSelectionNattableCommandProvider.this.getStatusCommand(command);
                                            if (!commandStatus.isOK()) {
                                                multiStatus.add(commandStatus);
                                            } else if (command != null) {
                                                compoundCommand.append(command);
                                            }
                                        } else {
                                            try {
                                                CellManagerFactory.INSTANCE.setStringValue(columnElement, rowElement, valueAsString, converter, AbstractPasteInSelectionNattableCommandProvider.this.tableManager, sharedMap);
                                            }
                                            catch (Exception e) {
                                                Activator.log.error("Cannot set value '" + valueAsString + "' for element '" + rowElement + "' and feature '" + columnElement + "'", (Throwable)e);
                                                multiStatus.add((IStatus)new Status(4, "org.eclipse.papyrus.infra.nattable", "Cannot set value '" + valueAsString + "' for element '" + rowElement + "' and feature '" + columnElement + "'"));
                                            }
                                        }
                                    } else if (AbstractPasteInSelectionNattableCommandProvider.this.isValidValue(valueAsString)) {
                                        multiStatus.add((IStatus)new Status(2, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteInSelectionNattableCommandProvider_NonEditableCellTriedToBeOverwrited));
                                    }
                                    ++nbColmnRead;
                                }
                                if (AbstractPasteInSelectionNattableCommandProvider.this.lastColumnPosition < nbColmnRead) {
                                    AbstractPasteInSelectionNattableCommandProvider.this.lastColumnPosition = nbColmnRead;
                                }
                            }
                        }
                        AbstractPasteInSelectionNattableCommandProvider abstractPasteInSelectionNattableCommandProvider = AbstractPasteInSelectionNattableCommandProvider.this;
                        abstractPasteInSelectionNattableCommandProvider.lastRowPosition = abstractPasteInSelectionNattableCommandProvider.lastRowPosition + 1;
                    }
                    if (AbstractPasteInSelectionNattableCommandProvider.this.canContinue((IStatus)multiStatus)) {
                        if (!objectsToAdd.isEmpty()) {
                            if (AbstractPasteInSelectionNattableCommandProvider.this.detachedMode) {
                                AbstractPasteInSelectionNattableCommandProvider.this.createTableRowInDetachedModeCommand(compoundCommand, objectsToAdd);
                            } else {
                                AbstractPasteInSelectionNattableCommandProvider.this.createTableRowInAttachedModeCommand(compoundCommand, objectsToAdd);
                            }
                        }
                        if (!attachedMode) {
                            List cells;
                            List valueToSet = (List)sharedMap.get("referencesToSet");
                            if (valueToSet.size() > 0) {
                                for (IValueSetter current : valueToSet) {
                                    current.doSetValue((EditingDomain)contextEditingDomain);
                                }
                            }
                            if ((cells = (List)sharedMap.get("cellsToAdd")) != null && !cells.isEmpty()) {
                                compoundCommand.append(AddCommand.create((EditingDomain)tableEditingDomain, (Object)AbstractPasteInSelectionNattableCommandProvider.this.table, (Object)NattablePackage.eINSTANCE.getTable_Cells(), (Collection)cells));
                            }
                        }
                    }
                    if (progressMonitor != null && progressMonitor.isCanceled()) {
                        progressMonitor.done();
                        AbstractPasteInSelectionNattableCommandProvider.this.localDispose();
                        return CommandResult.newCancelledCommandResult();
                    }
                    progressMonitor.done();
                    AbstractPasteInSelectionNattableCommandProvider.this.localDispose();
                    if (resultStatus.isOK()) {
                        resultStatus = multiStatus;
                    }
                }
                if (AbstractPasteInSelectionNattableCommandProvider.this.canContinue(resultStatus) && compoundCommand != null && !compoundCommand.isEmpty() && compoundCommand.canExecute()) {
                    tableEditingDomain.getCommandStack().execute((Command)compoundCommand);
                    if (!objectsToAdd.isEmpty() && !attachedMode) {
                        AbstractPasteInSelectionNattableCommandProvider.this.managePostActions(sharedMap);
                    }
                    return new CommandResult(resultStatus);
                }
                if (!resultStatus.isOK()) {
                    MultiStatus errorStatus = new MultiStatus("org.eclipse.papyrus.infra.nattable", 4, Messages.AbstractPasteInSelectionNattableCommandProvider_ThePasteHasNotBeenDoneBecauseOfSomeProblems, null);
                    if (resultStatus.isMultiStatus()) {
                        IStatus[] iStatusArray = resultStatus.getChildren();
                        int n = iStatusArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IStatus subStatus = iStatusArray[n2];
                            errorStatus.add(subStatus);
                            ++n2;
                        }
                    } else {
                        errorStatus.add(resultStatus);
                    }
                    if (4 != errorStatus.getSeverity()) {
                        errorStatus.add((IStatus)new Status(4, "org.eclipse.papyrus.infra.nattable", null));
                    }
                    resultStatus = errorStatus;
                }
                return new CommandResult(resultStatus);
            }
        };
        return pasteAllCommand;
    }

    protected ICommand getPasteColumnsFromStringCommand(TransactionalEditingDomain contextEditingDomain, final TransactionalEditingDomain tableEditingDomain, final Map<Integer, Object> columns, boolean openDialog, final IProgressMonitor progressMonitor, final Map<Object, Object> sharedMap, boolean attachedMode) {
        if (progressMonitor != null) {
            progressMonitor.beginTask(PASTE_ACTION_TASK_NAME, this.nbOperationsToDo);
        }
        AbstractTransactionalCommand pasteAllCommand = new AbstractTransactionalCommand(contextEditingDomain, PASTE_COMMAND_NAME, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                MultiStatus resultStatus = new MultiStatus("org.eclipse.papyrus.infra.nattable", 0, Messages.AbstractPasteInSelectionNattableCommandProvider_ThePasteHasBeenDoneWithSomeProblems, null);
                long readChar = 0L;
                long previousreadChar = 0L;
                AbstractPasteInSelectionNattableCommandProvider.this.firstRowPosition = 0;
                AbstractPasteInSelectionNattableCommandProvider.this.firstColumnPosition = -1;
                Iterator iterator = columns.keySet().iterator();
                while (iterator.hasNext()) {
                    int columnIndex = (Integer)iterator.next();
                    if (-1 == AbstractPasteInSelectionNattableCommandProvider.this.firstColumnPosition) {
                        AbstractPasteInSelectionNattableCommandProvider.this.firstColumnPosition = columnIndex;
                        continue;
                    }
                    if (columnIndex >= AbstractPasteInSelectionNattableCommandProvider.this.firstColumnPosition) continue;
                    AbstractPasteInSelectionNattableCommandProvider.this.firstColumnPosition = columnIndex;
                }
                AbstractPasteInSelectionNattableCommandProvider.this.lastRowPosition = AbstractPasteInSelectionNattableCommandProvider.this.firstRowPosition;
                AbstractPasteInSelectionNattableCommandProvider.this.lastColumnPosition = AbstractPasteInSelectionNattableCommandProvider.this.firstColumnPosition;
                RowHideShowLayer rowHideShowLayer = AbstractPasteInSelectionNattableCommandProvider.this.tableManager.getBodyLayerStack().getRowHideShowLayer();
                ColumnHideShowLayer columnHideShowLayer = AbstractPasteInSelectionNattableCommandProvider.this.tableManager.getBodyLayerStack().getColumnHideShowLayer();
                CompoundCommand compoundCommand = new CompoundCommand("Paste action");
                Iterator<Object> columnIter = AbstractPasteInSelectionNattableCommandProvider.this.pastedValues.keySet().iterator();
                Collection columnValuesAsString = new ArrayList();
                while ((!AbstractPasteInSelectionNattableCommandProvider.this.isSingleAxisPasted && columnIter.hasNext() || AbstractPasteInSelectionNattableCommandProvider.this.isSingleAxisPasted && AbstractPasteInSelectionNattableCommandProvider.this.numberSelectedAxis > 0L) && AbstractPasteInSelectionNattableCommandProvider.this.canContinue((IStatus)resultStatus)) {
                    if (AbstractPasteInSelectionNattableCommandProvider.this.isSingleAxisPasted) {
                        --AbstractPasteInSelectionNattableCommandProvider.this.numberSelectedAxis;
                    }
                    if (!AbstractPasteInSelectionNattableCommandProvider.this.isSingleAxisPasted || AbstractPasteInSelectionNattableCommandProvider.this.firstColumnPosition >= AbstractPasteInSelectionNattableCommandProvider.this.lastColumnPosition) {
                        columnValuesAsString = AbstractPasteInSelectionNattableCommandProvider.this.pastedValues.get(columnIter.next());
                    }
                    if (!columnValuesAsString.isEmpty()) {
                        int nbRowRead = AbstractPasteInSelectionNattableCommandProvider.this.firstRowPosition;
                        Iterator cellIter = columnValuesAsString.iterator();
                        if (progressMonitor != null && progressMonitor.isCanceled()) {
                            progressMonitor.done();
                            AbstractPasteInSelectionNattableCommandProvider.this.localDispose();
                            return CommandResult.newCancelledCommandResult();
                        }
                        previousreadChar = AbstractPasteInSelectionNattableCommandProvider.this.parser.getReadCharacters();
                        if (progressMonitor != null && (readChar += AbstractPasteInSelectionNattableCommandProvider.this.parser.getReadCharacters() - previousreadChar) > 1000L) {
                            readChar = 0L;
                            progressMonitor.worked(1000);
                        }
                        int realColumnIndex = columnHideShowLayer.getColumnIndexByPosition(AbstractPasteInSelectionNattableCommandProvider.this.lastColumnPosition);
                        Object columnElement = AxisUtils.getRepresentedElement(AbstractPasteInSelectionNattableCommandProvider.this.tableManager.getColumnElement(realColumnIndex));
                        while (cellIter.hasNext() && AbstractPasteInSelectionNattableCommandProvider.this.canContinue((IStatus)resultStatus)) {
                            String valueAsString = (String)cellIter.next();
                            int realRowIndex = rowHideShowLayer.getRowIndexByPosition(nbRowRead);
                            Object rowElement = AxisUtils.getRepresentedElement(AbstractPasteInSelectionNattableCommandProvider.this.tableManager.getRowElement(realRowIndex));
                            if (!(rowElement instanceof TreeFillingConfiguration)) {
                                boolean isEditable = CellManagerFactory.INSTANCE.isCellEditable(columnElement, rowElement, sharedMap);
                                if (isEditable) {
                                    AbstractStringValueConverter converter = CellManagerFactory.INSTANCE.getOrCreateStringValueConverterClass(columnElement, rowElement, AbstractPasteInSelectionNattableCommandProvider.this.tableManager, AbstractPasteInSelectionNattableCommandProvider.this.existingConverters, AbstractPasteInSelectionNattableCommandProvider.this.pasteHelper.getMultiValueSeparator());
                                    Command command = CellManagerFactory.INSTANCE.getSetStringValueCommand(tableEditingDomain, columnElement, rowElement, valueAsString, converter, AbstractPasteInSelectionNattableCommandProvider.this.tableManager);
                                    IStatus commandStatus = AbstractPasteInSelectionNattableCommandProvider.this.getStatusCommand(command);
                                    if (!commandStatus.isOK()) {
                                        resultStatus.add(commandStatus);
                                    } else {
                                        compoundCommand.append(command);
                                    }
                                } else if (AbstractPasteInSelectionNattableCommandProvider.this.isValidValue(valueAsString)) {
                                    resultStatus.add((IStatus)new Status(2, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteInSelectionNattableCommandProvider_NonEditableCellTriedToBeOverwrited));
                                }
                            }
                            ++nbRowRead;
                        }
                        if (AbstractPasteInSelectionNattableCommandProvider.this.lastRowPosition < nbRowRead) {
                            AbstractPasteInSelectionNattableCommandProvider.this.lastRowPosition = nbRowRead;
                        }
                    }
                    AbstractPasteInSelectionNattableCommandProvider abstractPasteInSelectionNattableCommandProvider = AbstractPasteInSelectionNattableCommandProvider.this;
                    abstractPasteInSelectionNattableCommandProvider.lastColumnPosition = abstractPasteInSelectionNattableCommandProvider.lastColumnPosition + 1;
                }
                progressMonitor.done();
                AbstractPasteInSelectionNattableCommandProvider.this.localDispose();
                if (AbstractPasteInSelectionNattableCommandProvider.this.canContinue((IStatus)resultStatus) && compoundCommand != null && !compoundCommand.isEmpty() && compoundCommand.canExecute()) {
                    tableEditingDomain.getCommandStack().execute((Command)compoundCommand);
                    return new CommandResult((IStatus)resultStatus);
                }
                if (!resultStatus.isOK()) {
                    MultiStatus errorStatus = new MultiStatus("org.eclipse.papyrus.infra.nattable", 4, Messages.AbstractPasteInSelectionNattableCommandProvider_ThePasteHasNotBeenDoneBecauseOfSomeProblems, null);
                    if (resultStatus.isMultiStatus()) {
                        IStatus[] iStatusArray = resultStatus.getChildren();
                        int n = iStatusArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IStatus subStatus = iStatusArray[n2];
                            errorStatus.add(subStatus);
                            ++n2;
                        }
                    } else {
                        errorStatus.add((IStatus)resultStatus);
                    }
                    errorStatus.add((IStatus)new Status(4, "org.eclipse.papyrus.infra.nattable", null));
                    resultStatus = errorStatus;
                }
                return new CommandResult((IStatus)resultStatus);
            }
        };
        return pasteAllCommand;
    }

    private boolean canContinue(IStatus status) {
        return 8 != status.getSeverity() && 4 != status.getSeverity();
    }

    protected boolean isValidValue(String value) {
        boolean result = true;
        if (value != null) {
            if ("null".equals(value) || "".equals(value) || "N/A".equals(value)) {
                result = false;
            }
        } else {
            result = false;
        }
        return result;
    }

    protected void manageUserAction(int rowIndexToModify, boolean isInsert, boolean openDialog, final String identifierValue, MultiStatus multiStatus) {
        this.currentUserAction = -1;
        if (-1 != rowIndexToModify) {
            if (isInsert) {
                if (-1 == this.userAction) {
                    if (openDialog) {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialogWithToggle messageDialog = new MessageDialogWithToggle(Display.getDefault().getActiveShell(), "Confirmation", org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("/icons/papyrus.png"), "The identifier '" + identifierValue + "' was found. What do you want to do ?", 6, new String[]{"Replace", "Add", "Skip", "Cancel"}, 0, "Apply to all", false){

                                    protected void createButtonsForButtonBar(Composite parent) {
                                        String[] buttonLabels = this.getButtonLabels();
                                        Button[] buttons = new Button[buttonLabels.length];
                                        int defaultButtonIndex = this.getDefaultButtonIndex();
                                        int i = 0;
                                        while (i < buttonLabels.length) {
                                            Button button;
                                            String label = buttonLabels[i];
                                            buttons[i] = button = this.createButton(parent, i, label, defaultButtonIndex == i);
                                            ++i;
                                        }
                                        this.setButtons(buttons);
                                    }
                                };
                                messageDialog.open();
                                AbstractPasteInSelectionNattableCommandProvider.this.currentUserAction = messageDialog.getReturnCode();
                                if (messageDialog.getToggleState()) {
                                    AbstractPasteInSelectionNattableCommandProvider.this.userAction = AbstractPasteInSelectionNattableCommandProvider.this.currentUserAction;
                                }
                            }
                        });
                    } else {
                        this.currentUserAction = 0;
                    }
                } else {
                    this.currentUserAction = this.userAction;
                }
            } else {
                this.currentUserAction = 0;
            }
        } else if (isInsert) {
            this.currentUserAction = 1;
            multiStatus.add((IStatus)new Status(2, "org.eclipse.papyrus.infra.nattable", String.format(Messages.AbstractPasteInSelectionNattableCommandProvider_identifierNotFoundInSelectionSoTheObjectWasCreated, identifierValue)));
        } else {
            multiStatus.add((IStatus)new Status(2, "org.eclipse.papyrus.infra.nattable", String.format(Messages.AbstractPasteInSelectionNattableCommandProvider_identifierNotFoundInSelection, identifierValue)));
        }
    }

    protected void managePostActions(Map<Object, Object> sharedMap) {
        Collection<String> postActions = this.getPostActions();
        Collection postActionsAddedByCellManagers = (Collection)sharedMap.get("additionnal_post_actions_to_conclude_paste");
        postActions.addAll(postActionsAddedByCellManagers);
        for (String currentPostActions : postActions) {
            PastePostActionRegistry.INSTANCE.concludePostAction(this.tableManager, currentPostActions, sharedMap);
        }
    }

    protected IStatus getStatusCommand(Command command) {
        ICommand gmfCommand;
        IStatus resultStatus = Status.OK_STATUS;
        if (command instanceof CompoundCommand) {
            Iterator subCommandIterator = ((CompoundCommand)command).getCommandList().iterator();
            while (subCommandIterator.hasNext() && resultStatus.isOK()) {
                IStatus subStatus;
                Command subCommand = (Command)subCommandIterator.next();
                if (!(command instanceof CompoundCommand) || (subStatus = this.getStatusCommand(subCommand)).isOK()) continue;
                resultStatus = subStatus;
            }
        } else if (command instanceof GMFtoEMFCommandWrapper && (gmfCommand = ((GMFtoEMFCommandWrapper)command).getGMFCommand()) instanceof ErrorTransactionalCommand) {
            resultStatus = ((ErrorTransactionalCommand)gmfCommand).getStatus();
        }
        return resultStatus;
    }

    protected int getColumnIndexOfAxisIdentifier() {
        PasteEObjectConfiguration pasteconfiguration = this.getPasteconfigurationTopLevel(this.table);
        int index = -1;
        EList axis = null;
        axis = !this.table.isInvertAxis() ? this.tableManager.getColumnAxisManager().getRepresentedContentProvider().getAxis() : this.tableManager.getRowAxisManager().getRepresentedContentProvider().getAxis();
        int axisIndex = 0;
        while (axisIndex < axis.size() && -1 == index) {
            if (((IAxis)axis.get(axisIndex)).getElement().equals(pasteconfiguration.getAxisIdentifier().getElement())) {
                index = axisIndex;
            }
            ++axisIndex;
        }
        return index;
    }

    protected int getFirstSelectedElementIndexOfTableContext(Map<Integer, Object> rows, int currentRowIndex, EObject cotext) {
        int initialFirstIndexInParent = -1;
        if (this.isInsert) {
            Object rowElement = this.tableManager.getRowElement(currentRowIndex);
            int depth = this.getDepthFromObject(rowElement);
            String categoryName = this.getCategoryFromObject(rowElement);
            PasteEObjectConfiguration pasteConfiguration = this.getPasteConfiguration(this.table, depth, categoryName);
            Object axis = rows.get(currentRowIndex);
            Object object = AxisUtils.getRepresentedElement(axis);
            if (object instanceof EObject) {
                while (object instanceof EObject && ((EObject)object).eContainer() != null) {
                    EStructuralFeature containmentFeature;
                    if (((EObject)object).eContainer().equals(cotext) && (containmentFeature = pasteConfiguration.getPasteElementContainementFeature()).isMany()) {
                        initialFirstIndexInParent = ((EObjectContainmentEList)cotext.eGet(containmentFeature)).indexOf(object);
                    }
                    object = ((EObject)object).eContainer();
                }
            }
        }
        return initialFirstIndexInParent;
    }

    protected EObject getContentOfSelection(Map<Integer, Object> rows, int currentRowIndex) {
        EObject context = null;
        if (currentRowIndex == 0) {
            context = this.table.getContext();
        } else {
            Object axis = rows.get(currentRowIndex);
            Object object = AxisUtils.getRepresentedElement(axis);
            if (object instanceof EObject) {
                context = ((EObject)object).eContainer();
            }
        }
        return context;
    }

    protected abstract PasteEObjectConfiguration getPasteconfigurationTopLevel(Table var1);

    protected abstract PasteEObjectConfiguration getPasteConfiguration(Table var1, int var2, String var3);

    protected abstract int getDepthFromObject(Object var1);

    protected abstract String getCategoryFromObject(Object var1);

    protected abstract Object getColumnElement(int var1);

    protected abstract Object getRowElementCreatedInAttachedMode(EObject var1, EStructuralFeature var2, IElementType var3, IProgressMonitor var4, IAdaptable var5, CompoundCommand var6);

    protected abstract Object getRowElementCreatedInDetachedMode(EStructuralFeature var1, IElementType var2, IProgressMonitor var3, IAdaptable var4, CompoundCommand var5);

    protected abstract void createTableRowInDetachedModeCommand(CompoundCommand var1, List<InsertedElementInNattable> var2) throws ExecutionException;

    protected abstract void createTableRowInAttachedModeCommand(CompoundCommand var1, List<InsertedElementInNattable> var2) throws ExecutionException;

    private Collection<String> getPostActions() {
        return this.postActions;
    }

    protected void localDispose() {
        this.isDisposed = true;
        for (AbstractStringValueConverter current : this.existingConverters.values()) {
            current.dispose();
        }
        this.existingConverters.clear();
        this.pastedValues.clear();
        this.numberSelectedAxis = 0L;
        this.isSingleAxisPasted = false;
        try {
            this.reader.close();
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
        }
    }
}

