/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.history;

import org.eclipse.emf.cdo.internal.ui.history.Branch;
import org.eclipse.emf.cdo.internal.ui.history.Net;
import org.eclipse.emf.cdo.internal.ui.history.Track;

public class Segment {
    private final Track track;
    private final Branch branch;
    private boolean complete;
    private long firstVisualTime;
    private long firstCommitTime;
    private long lastCommitTime;
    private Segment previousInTrack;
    private Segment nextInTrack;
    private Segment previousInBranch;
    private Segment nextInBranch;

    public Segment(Track track, Branch branch) {
        this.track = track;
        this.branch = branch;
    }

    public final Net getNet() {
        return this.track.getNet();
    }

    public final Track getTrack() {
        return this.track;
    }

    public final Branch getBranch() {
        return this.branch;
    }

    public final boolean isComplete() {
        return this.complete;
    }

    public final long getFirstVisualTime() {
        return this.firstVisualTime;
    }

    public final long getFirstCommitTime() {
        return this.firstCommitTime;
    }

    public final long getLastCommitTime() {
        return this.lastCommitTime;
    }

    public final Segment getPreviousInTrack() {
        return this.previousInTrack;
    }

    public final Segment getNextInTrack() {
        return this.nextInTrack;
    }

    public final Segment getPreviousInBranch() {
        return this.previousInBranch;
    }

    public final Segment getNextInBranch() {
        return this.nextInBranch;
    }

    public final boolean containsCommitTime(long time) {
        return time >= this.firstCommitTime && time <= this.lastCommitTime;
    }

    public final boolean containsVisualTime(long time) {
        return time >= this.getFirstVisualTime() && time <= this.lastCommitTime;
    }

    public String toString() {
        return "Segment[" + this.branch + " --> " + this.track + "]";
    }

    void adjustVisualTime(long time, boolean complete) {
        if (this.firstVisualTime == 0L || time < this.firstVisualTime) {
            this.firstVisualTime = time;
        }
        this.complete |= complete;
    }

    void adjustCommitTimes(long time) {
        this.adjustVisualTime(time, false);
        if (this.firstCommitTime == 0L) {
            this.firstCommitTime = time;
            this.lastCommitTime = time;
        } else if (time < this.firstCommitTime) {
            this.firstCommitTime = time;
        } else if (time > this.lastCommitTime) {
            this.lastCommitTime = time;
        }
    }

    void setPreviousInTrack(Segment previousInTrack) {
        this.previousInTrack = previousInTrack;
    }

    void setNextInTrack(Segment nextInTrack) {
        this.nextInTrack = nextInTrack;
    }

    void setPreviousInBranch(Segment previousInBranch) {
        this.previousInBranch = previousInBranch;
    }

    void setNextInBranch(Segment nextInBranch) {
        this.nextInBranch = nextInBranch;
    }
}

