/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.welcome.internal.widgets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResourceSet;
import org.eclipse.papyrus.infra.properties.ui.modelelement.DataSource;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.ui.emf.utils.ProviderHelper;
import org.eclipse.papyrus.infra.ui.providers.DelegatingPapyrusContentProvider;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class CreateNewNotationButton
extends Composite {
    private Button button;
    private DataSource input;

    public CreateNewNotationButton(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout(1, false);
        this.setLayout((Layout)layout);
        this.button = new Button((Composite)this, 0x800008);
        this.button.setText("Create View");
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateNewNotationButton.this.createDiagram();
            }
        });
    }

    public void setLabel(String label) {
        this.button.setText(label);
    }

    public String getLabel() {
        return this.button.getText();
    }

    public void dispose() {
        this.input = null;
        super.dispose();
    }

    public void setInput(DataSource input) {
        this.input = input;
    }

    public DataSource getInput() {
        return this.input;
    }

    protected EObject getModelElement() {
        return EMFHelper.getEObject((Object)this.input.getSelection().getFirstElement());
    }

    protected void createDiagram() {
        EObject object;
        Object[] result;
        final ArrayList<ViewPrototype> availablePrototypes = new ArrayList<ViewPrototype>();
        ModelSet modelSet = null;
        LabelProviderService labels = null;
        try {
            modelSet = ServiceUtilsForEObject.getInstance().getModelSet((Object)this.getModelElement());
            labels = (LabelProviderService)ServiceUtilsForResourceSet.getInstance().getService(LabelProviderService.class, (Object)modelSet);
        }
        catch (ServiceException e) {
            throw new IllegalStateException(e);
        }
        Object content = ProviderHelper.getContentProvider((ResourceSet)modelSet);
        content = new DelegatingPapyrusContentProvider((ITreeContentProvider)content){

            public boolean isValidValue(Object element) {
                EObject object;
                availablePrototypes.clear();
                if (element != null && (object = EMFHelper.getEObject((Object)element)) != null) {
                    for (ViewPrototype proto : PolicyChecker.getCurrent().getPrototypesFor(object)) {
                        availablePrototypes.add(proto);
                    }
                }
                return !availablePrototypes.isEmpty();
            }
        };
        TreeSelectorDialog dlg = new TreeSelectorDialog(this.getShell());
        dlg.setLabelProvider(labels.getLabelProvider());
        dlg.setContentProvider(content);
        dlg.setMessage("Select an element for which to create a new notation view.");
        dlg.setTitle("Select Notation Context");
        dlg.setInput((Object)modelSet);
        if (dlg.open() == 0 && (result = dlg.getResult()).length > 0 && (object = EMFHelper.getEObject((Object)result[0])) != null) {
            this.createDiagram(object, availablePrototypes);
        }
    }

    protected void createDiagram(EObject context, List<ViewPrototype> prototypes) {
        Object[] result;
        Collections.sort(prototypes, new ViewPrototype.Comp());
        LabelProvider labels = new LabelProvider(){

            public String getText(Object element) {
                return ((ViewPrototype)element).getLabel();
            }

            public Image getImage(Object element) {
                return ((ViewPrototype)element).getIcon();
            }
        };
        ElementListSelectionDialog dlg = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labels);
        dlg.setTitle("Create Notation View");
        dlg.setMessage("Select the notation view to create");
        dlg.setMultipleSelection(false);
        dlg.setElements(prototypes.toArray());
        if (dlg.open() == 0 && (result = dlg.getResult()).length > 0) {
            ViewPrototype prototype = (ViewPrototype)result[0];
            prototype.instantiateOn(context);
        }
    }
}

