/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence;

import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.infra.core.editor.BackboneException;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditor;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.sequence.util.FixGateViewOnOpening;
import org.eclipse.papyrus.uml.diagram.sequence.util.FixInteractionOperandsOnOpening;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;

public class UmlSequenceDiagramForMultiEditor
extends UMLDiagramEditor {
    private static final String DIAG_IMG_PATH = "icons/obj16/Diagram_Sequence.gif";
    private static final ImageDescriptor DIAG_IMG_DESC = UMLDiagramEditorPlugin.getBundledImageDescriptor("icons/obj16/Diagram_Sequence.gif");
    private Composite splitter;
    private Image titleImage;

    public UmlSequenceDiagramForMultiEditor(ServicesRegistry servicesRegistry, Diagram diagram) throws BackboneException, ServiceException {
        super(servicesRegistry, diagram);
        new FixInteractionOperandsOnOpening().fix(diagram);
        new FixGateViewOnOpening().fix(diagram);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.setPartName(this.getDiagram().getName());
        this.titleImage = DIAG_IMG_DESC.createImage();
        this.setTitleImage(this.titleImage);
    }

    @Override
    public void dispose() {
        if (this.titleImage != null) {
            this.titleImage.dispose();
            this.titleImage = null;
        }
        super.dispose();
    }

    public void setInput(IEditorInput input) {
        try {
            URIEditorInput uriInput = new URIEditorInput(EcoreUtil.getURI((EObject)this.getDiagram()));
            this.doSetInput((IEditorInput)uriInput, true);
        }
        catch (CoreException x) {
            String title = "Problem opening";
            String msg = "Cannot open input element:";
            Shell shell = this.getSite().getShell();
            ErrorDialog.openError((Shell)shell, (String)title, (String)msg, (IStatus)x.getStatus());
        }
    }

    protected void createGraphicalViewer(Composite parent) {
        this.splitter = parent;
        super.createGraphicalViewer(parent);
    }

    public void setFocus() {
        this.splitter.setFocus();
        super.setFocus();
    }

    public String getEditingDomainID() {
        return "org.eclipse.papyrus.uml.diagram.sequence.EditingDomain";
    }

    protected void applyCustomizationsToPalette(PaletteRoot paletteRoot) {
        Object nodes;
        super.applyCustomizationsToPalette(paletteRoot);
        List children = paletteRoot.getChildren();
        if (children.size() > 2 && (nodes = children.get(1)) instanceof PaletteContainer) {
            this.doSort((PaletteContainer)nodes);
        }
    }

    private void doSort(PaletteContainer nodes) {
        if (nodes == null) {
            return;
        }
        List children = nodes.getChildren();
        Collections.sort(children, new Comparator<PaletteEntry>(){

            @Override
            public int compare(PaletteEntry o1, PaletteEntry o2) {
                String l1 = o1.getLabel();
                String l2 = o2.getLabel();
                if (l1 != null && l2 != null) {
                    return Collator.getInstance().compare(l1, l2);
                }
                return 0;
            }
        });
    }
}

