/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.parsers;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.papyrus.uml.diagram.timing.custom.Messages;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.LifelineUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.StateDefinitionUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.ViewUtils;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.StateInvariant;

public class StateDefinitionParser
implements IParser {
    public static final String DEFAULT_EDIT_VALUE = "";

    public String getEditString(IAdaptable adaptable, int flags) {
        StateInvariant stateInvariant = (StateInvariant)adaptable.getAdapter(EObject.class);
        return stateInvariant != null ? stateInvariant.getName() : DEFAULT_EDIT_VALUE;
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        return ParserEditStatus.EDITABLE_STATUS;
    }

    public ICommand getParseCommand(IAdaptable adaptable, final String newString, int flags) {
        View stateDefinitionLabelView = (View)adaptable.getAdapter(View.class);
        final View stateDefinitionView = (View)stateDefinitionLabelView.eContainer();
        final View lifelineView = ViewUtils.findSuperViewWithId(stateDefinitionView, "Lifeline_FullShape");
        final Lifeline lifeline = (Lifeline)lifelineView.getElement();
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)lifeline);
        if (editingDomain == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return new AbstractTransactionalCommand(editingDomain, Messages.StateDefinitionParser_SetStateDefinitionName, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                StateDefinitionUtils.setStateDefinitionName(stateDefinitionView, newString);
                LifelineUtils.updateFragmentNames(lifeline, lifelineView);
                return CommandResult.newOKCommandResult();
            }
        };
    }

    public String getPrintString(IAdaptable adaptable, int flags) {
        String name;
        StateInvariant stateInvariant = (StateInvariant)adaptable.getAdapter(EObject.class);
        String string = name = stateInvariant != null ? stateInvariant.getName() : null;
        if (name == null || name.length() == 0) {
            return Messages.StateDefinitionParser_Unnamed;
        }
        return name;
    }

    public boolean isAffectingEvent(Object event, int flags) {
        return true;
    }

    public IContentAssistProcessor getCompletionProcessor(IAdaptable element) {
        return null;
    }
}

