/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.toolbox.notification.builders;

import org.eclipse.papyrus.infra.widgets.toolbox.notification.IBuilder;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.ICompositeCreator;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.INotification;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.Type;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.NotificationBuilder;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.PropertyWrapper;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.utils.PapyrusControlsFactory;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.view.AbstractInsideComposite;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.view.PapyrusNotificationView;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.view.ViewNotification;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ViewBuilder
implements IBuilder {
    @Override
    public INotification build(PropertyWrapper wrapper, FormToolkit toolkit) {
        try {
            IViewPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.papyrus.infra.widgets.toolbox.notification.view.PapyrusNotificationView");
            if (part instanceof PapyrusNotificationView) {
                PapyrusNotificationView view = (PapyrusNotificationView)part;
                AbstractInsideComposite viewCompo = null;
                if (wrapper.getComposite() != null) {
                    viewCompo = view.setComposite(wrapper.getComposite(), wrapper.getTitle(), wrapper.getActions(), wrapper.getType());
                } else if (wrapper.getType() != null || wrapper.getImage() != null || wrapper.isHtml()) {
                    final Image image = wrapper.getImage();
                    final Type type = wrapper.getType();
                    final boolean isHtml = wrapper.isHtml();
                    final String message = wrapper.getMessage();
                    viewCompo = view.setComposite(new ICompositeCreator(){

                        @Override
                        public Composite createComposite(Composite parent, FormToolkit toolkit) {
                            Composite created = PapyrusControlsFactory.createCompositeWithType(Display.getDefault().getActiveShell(), toolkit, parent, type, image, message, isHtml);
                            return created;
                        }
                    }, wrapper.getTitle(), wrapper.getActions());
                } else if (wrapper.getMessage() != null) {
                    viewCompo = view.setMessage(wrapper.getMessage(), wrapper.getTitle(), wrapper.getActions());
                }
                ViewNotification notification = new ViewNotification(viewCompo);
                viewCompo.setINotification(notification);
                return notification;
            }
        }
        catch (PartInitException partInitException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public boolean accept(String parameterName, Object value) {
        boolean found = false;
        IViewReference[] iViewReferenceArray = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getViewReferences();
        int n = iViewReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference ref = iViewReferenceArray[n2];
            if ("org.eclipse.papyrus.infra.widgets.toolbox.notification.view.PapyrusNotificationView".equals(ref.getId())) {
                found = true;
            }
            ++n2;
        }
        if (found) {
            if ("asynchronous".equals(parameterName)) {
                return value instanceof Boolean && (Boolean)value != false;
            }
            if ("temporary".equals(parameterName)) {
                return value instanceof Boolean && (Boolean)value == false;
            }
            if ("delay".equals(parameterName)) {
                return false;
            }
            if ("message".equals(parameterName)) {
                return true;
            }
            if (NotificationBuilder.COMPOSITE.equals(parameterName)) {
                return true;
            }
            if ("default_action".equals(parameterName)) {
                return true;
            }
            if ("type".equals(parameterName)) {
                return true;
            }
            if ("title".equals(parameterName)) {
                return true;
            }
            if ("html".equals(parameterName)) {
                return true;
            }
        }
        return false;
    }
}

