/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.properties.generation.extensionpoint;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.customization.properties.generation.Activator;
import org.eclipse.papyrus.customization.properties.generation.layout.ILayoutGenerator;
import org.eclipse.papyrus.infra.tools.util.ClassLoaderHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutExtensionPoint {
    private final String EXTENSION_ID = "org.eclipse.papyrus.customization.properties.generation.layout";
    private final List<ILayoutGenerator> generators;

    public LayoutExtensionPoint() {
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.customization.properties.generation.layout");
        ArrayList<ILayoutGenerator> generators = new ArrayList<ILayoutGenerator>(2);
        IConfigurationElement[] iConfigurationElementArray = config;
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            String generatorClassName = e.getAttribute("generator");
            ILayoutGenerator generator = (ILayoutGenerator)ClassLoaderHelper.newInstance((String)generatorClassName, ILayoutGenerator.class);
            if (generator == null) {
                Activator.log.warn("Cannot instantiate the layout generator : " + generatorClassName);
            } else {
                generators.add(generator);
            }
            ++n2;
        }
        this.generators = Collections.unmodifiableList(generators);
    }

    public List<ILayoutGenerator> getGenerators() {
        return this.generators;
    }
}

