/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.io;

import java.io.Closeable;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.net4j.util.io.ExtendedIOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ExtendedDataInput
extends DataInput {
    public byte[] readByteArray() throws IOException;

    public Object readObject() throws IOException;

    public Object readObject(ClassLoader var1) throws IOException;

    public Object readObject(ExtendedIOUtil.ClassResolver var1) throws IOException;

    public String readString() throws IOException;

    public <T extends Enum<?>> T readEnum(Class<T> var1) throws IOException;

    public Throwable readException() throws IOException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Delegating
    implements ExtendedDataInput,
    Closeable {
        private ExtendedDataInput delegate;

        public Delegating(ExtendedDataInput delegate) {
            this.delegate = delegate;
        }

        public ExtendedDataInput getDelegate() {
            return this.delegate;
        }

        @Override
        public boolean readBoolean() throws IOException {
            return this.delegate.readBoolean();
        }

        @Override
        public byte readByte() throws IOException {
            return this.delegate.readByte();
        }

        @Override
        public byte[] readByteArray() throws IOException {
            return this.delegate.readByteArray();
        }

        @Override
        public char readChar() throws IOException {
            return this.delegate.readChar();
        }

        @Override
        public double readDouble() throws IOException {
            return this.delegate.readDouble();
        }

        @Override
        public float readFloat() throws IOException {
            return this.delegate.readFloat();
        }

        @Override
        public void readFully(byte[] b, int off, int len) throws IOException {
            this.delegate.readFully(b, off, len);
        }

        @Override
        public void readFully(byte[] b) throws IOException {
            this.delegate.readFully(b);
        }

        @Override
        public int readInt() throws IOException {
            return this.delegate.readInt();
        }

        @Override
        public String readLine() throws IOException {
            return this.delegate.readLine();
        }

        @Override
        public long readLong() throws IOException {
            return this.delegate.readLong();
        }

        @Override
        public Object readObject() throws IOException {
            return this.delegate.readObject();
        }

        @Override
        public Object readObject(ClassLoader classLoader) throws IOException {
            return this.delegate.readObject(classLoader);
        }

        @Override
        public Object readObject(ExtendedIOUtil.ClassResolver classResolver) throws IOException {
            return this.delegate.readObject(classResolver);
        }

        @Override
        public short readShort() throws IOException {
            return this.delegate.readShort();
        }

        @Override
        public String readString() throws IOException {
            return this.delegate.readString();
        }

        @Override
        public <T extends Enum<?>> T readEnum(Class<T> type) throws IOException {
            return this.delegate.readEnum(type);
        }

        @Override
        public Throwable readException() throws IOException {
            return this.delegate.readException();
        }

        @Override
        public int readUnsignedByte() throws IOException {
            return this.delegate.readUnsignedByte();
        }

        @Override
        public int readUnsignedShort() throws IOException {
            return this.delegate.readUnsignedShort();
        }

        @Override
        public String readUTF() throws IOException {
            return this.delegate.readUTF();
        }

        @Override
        public int skipBytes(int n) throws IOException {
            return this.delegate.skipBytes(n);
        }

        @Override
        public void close() throws IOException {
            if (this.delegate instanceof Closeable) {
                ((Closeable)((Object)this.delegate)).close();
            }
        }
    }

    public static class Stream
    extends InputStream {
        private ExtendedDataInput delegate;

        public Stream(ExtendedDataInput delegate) {
            this.delegate = delegate;
        }

        public ExtendedDataInput getDelegate() {
            return this.delegate;
        }

        public int read() throws IOException {
            try {
                return this.delegate.readUnsignedByte();
            }
            catch (EOFException ex) {
                return -1;
            }
        }

        public void close() throws IOException {
            if (this.delegate instanceof Closeable) {
                ((Closeable)((Object)this.delegate)).close();
            }
            super.close();
        }
    }
}

