/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.vocabulary.importer.importWizards;

import java.io.File;
import java.util.List;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.opencert.vocabulary.importer.importWizards.CdoContainerContentProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CdoImportWizardPage
extends WizardPage {
    private static final String xmlSuffix = ".xml";
    private FileFieldEditor importFileEditor;
    private TreeViewer resourcesTreeViewer;
    private Text resourceNameText;
    private boolean importFileOkay = false;
    private boolean resourceNameOkay = false;
    private List<CDOResourceNode> nodeList;

    public CdoImportWizardPage(String pageName, List<CDOResourceNode> nodeList) {
        super(pageName);
        this.nodeList = nodeList;
        this.setTitle(pageName);
        this.setDescription("Import a vocabulary from the local file system");
    }

    public void createControl(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridData dialogData = new GridData(768);
        dialogArea.setLayoutData((Object)dialogData);
        GridLayout dialogAreaLayout = new GridLayout();
        dialogAreaLayout.numColumns = 1;
        dialogAreaLayout.makeColumnsEqualWidth = false;
        dialogAreaLayout.marginWidth = 0;
        dialogAreaLayout.marginHeight = 0;
        dialogArea.setLayout((Layout)dialogAreaLayout);
        this.createFileSelectionArea(dialogArea);
        this.createResourcesArea(dialogArea);
        this.setControl((Control)dialogArea);
        this.setPageComplete(false);
    }

    private void createResourcesArea(Composite dialogArea) {
        Composite resourcesArea = new Composite(dialogArea, 0);
        GridData resourcesData = new GridData(1808);
        resourcesArea.setLayoutData((Object)resourcesData);
        GridLayout resourcesLayout = new GridLayout();
        resourcesLayout.numColumns = 2;
        resourcesLayout.marginWidth = 0;
        resourcesLayout.marginHeight = 0;
        resourcesArea.setLayout((Layout)resourcesLayout);
        this.resourcesTreeViewer = new TreeViewer(resourcesArea, 4);
        GridData treeData = new GridData(1808);
        treeData.horizontalSpan = 2;
        this.resourcesTreeViewer.getControl().setLayoutData((Object)treeData);
        this.resourcesTreeViewer.setAutoExpandLevel(2);
        CdoContainerContentProvider cp = new CdoContainerContentProvider();
        this.resourcesTreeViewer.setContentProvider((IContentProvider)cp);
        this.resourcesTreeViewer.setLabelProvider((IBaseLabelProvider)new CdoContainerContentProvider.CdoLabelProvider());
        this.resourcesTreeViewer.setComparator(new ViewerComparator());
        this.resourcesTreeViewer.setUseHashlookup(true);
        this.resourcesTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                this.expand(selection);
            }

            private void expand(ISelection selection) {
                if (selection instanceof IStructuredSelection) {
                    Object item = ((IStructuredSelection)selection).getFirstElement();
                    if (item == null) {
                        return;
                    }
                    if (CdoImportWizardPage.this.resourcesTreeViewer.getExpandedState(item)) {
                        CdoImportWizardPage.this.resourcesTreeViewer.collapseToLevel(item, 1);
                    } else {
                        CdoImportWizardPage.this.resourcesTreeViewer.expandToLevel(item, 1);
                    }
                }
            }
        });
        this.resourcesTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (!selection.isEmpty()) {
                    this.setTextValue((TreeSelection)selection);
                }
            }

            private void setTextValue(TreeSelection selection) {
                StringBuilder sb = new StringBuilder();
                this.createString(selection.getPaths()[0], sb);
                CdoImportWizardPage.this.resourceNameText.setText(sb.toString());
            }

            private void createString(TreePath path, StringBuilder sb) {
                if (path.equals((Object)TreePath.EMPTY)) {
                    return;
                }
                this.createString(path.getParentPath(), sb);
                Object obj = path.getLastSegment();
                if (obj instanceof CdoContainerContentProvider.Root) {
                    sb.append(CdoContainerContentProvider.Root.displayString());
                } else if (obj instanceof CDOResourceNode) {
                    CDOResourceNode node = (CDOResourceNode)obj;
                    String nodeName = node.getName();
                    sb.append(nodeName);
                    if (node instanceof CDOResourceFolder) {
                        sb.append(CdoContainerContentProvider.Root.displayString());
                    }
                }
            }
        });
        this.resourcesTreeViewer.setInput(this.nodeList);
        Label resourceNameLabel = new Label(resourcesArea, 0);
        resourceNameLabel.setText("Path for the new Resource:  ");
        this.resourceNameText = new Text(resourcesArea, 2052);
        GridData resourceNameData = new GridData(768);
        this.resourceNameText.setLayoutData((Object)resourceNameData);
        this.resourceNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ((Text)e.getSource()).getText();
                CdoImportWizardPage.this.validateFolder(text);
            }
        });
    }

    private void createFileSelectionArea(Composite dialogArea) {
        Composite fileSelectionArea = new Composite(dialogArea, 0);
        GridData fileSelectionData = new GridData(768);
        fileSelectionArea.setLayoutData((Object)fileSelectionData);
        GridLayout fileSelectionLayout = new GridLayout();
        fileSelectionLayout.numColumns = 3;
        fileSelectionLayout.marginWidth = 0;
        fileSelectionLayout.marginHeight = 0;
        fileSelectionArea.setLayout((Layout)fileSelectionLayout);
        this.importFileEditor = new FileFieldEditor("fileSelect", "Select Vocabulary XML File: ", fileSelectionArea);
        this.importFileEditor.getTextControl(fileSelectionArea).addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CdoImportWizardPage.this.validateFileSelection();
            }
        });
        String[] extensions = new String[]{"*.xml"};
        this.importFileEditor.setFileExtensions(extensions);
    }

    private void validateFileSelection() {
        try {
            String filename = this.importFileEditor.getStringValue();
            if (filename.length() > 0) {
                File file = new File(filename);
                if (!file.exists()) {
                    this.setErrorMessage("The file does not exist.");
                    this.importFileOkay = false;
                    this.updatePageComplete();
                    return;
                }
                if (!file.toString().toLowerCase().endsWith(xmlSuffix)) {
                    this.setErrorMessage("The file is not an XML file.");
                    this.importFileOkay = false;
                    this.updatePageComplete();
                    return;
                }
            }
        }
        catch (Exception exception) {}
        this.importFileOkay = true;
        this.setErrorMessage(null);
        this.updatePageComplete();
    }

    private void validateFolder(String text) {
        if (!text.startsWith(CdoContainerContentProvider.Root.displayString())) {
            this.setErrorMessage("Specify a valid vocabulary resource name starting with a / character.");
            this.resourceNameOkay = false;
            return;
        }
        if (!text.toLowerCase().endsWith(".vocabulary")) {
            this.setErrorMessage("Specify a valid vocabulary resource name with the '.vocabulary' extension.");
            this.resourceNameOkay = false;
            return;
        }
        this.resourceNameOkay = true;
        this.setErrorMessage(null);
        this.updatePageComplete();
    }

    private void updatePageComplete() {
        this.setPageComplete(this.importFileOkay && this.resourceNameOkay);
    }

    public String getInputFilename() {
        return this.importFileEditor.getStringValue();
    }

    public String getResourceName() {
        return this.resourceNameText.getText();
    }
}

