/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.vocabulary.importer.importWizards;

import java.net.URL;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.opencert.vocabulary.importer.Activator;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public class CdoContainerContentProvider
implements ITreeContentProvider {
    Root root;

    public void dispose() {
    }

    public Object[] getChildren(Object element) {
        if (element instanceof Root) {
            return this.root.getNodes().toArray();
        }
        if (element instanceof CDOResourceFolder) {
            return ((CDOResourceFolder)element).getNodes().toArray();
        }
        return new Object[0];
    }

    public Object[] getElements(Object element) {
        return new Object[]{this.root};
    }

    public Object getParent(Object element) {
        CDOResourceNode node = (CDOResourceNode)element;
        CDOResourceFolder parent = node.getFolder();
        if (parent == null) {
            return this.root;
        }
        return parent;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.root = new Root();
        this.root.setNodes((List)newInput);
    }

    public static class CdoLabelProvider
    extends LabelProvider {
        private static Image folderImage;
        private static Image documentImage;

        public CdoLabelProvider() {
            if (folderImage == null) {
                folderImage = ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path("icons/famfamfam_silk_icons_v013/icons/folder_database.png"), null)).createImage();
            }
            if (documentImage == null) {
                documentImage = ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path("icons/famfamfam_silk_icons_v013/icons/page_white_database.png"), null)).createImage();
            }
        }

        public String getText(Object element) {
            String result = null;
            if (element instanceof Root) {
                return "/";
            }
            if (element instanceof CDOResourceNode) {
                result = ((CDOResourceNode)element).getName();
            }
            return result;
        }

        public Image getImage(Object element) {
            Image result = null;
            if (element instanceof Root) {
                result = folderImage;
            } else if (element instanceof CDOResourceFolder) {
                result = folderImage;
            } else if (element instanceof CDOResource) {
                result = documentImage;
            }
            return result;
        }
    }

    public static class Root {
        private List<CDOResourceNode> nodes;

        public List<CDOResourceNode> getNodes() {
            return this.nodes;
        }

        public void setNodes(List<CDOResourceNode> nodes) {
            this.nodes = nodes;
        }

        public static String displayString() {
            return "/";
        }
    }
}

