/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.spi.cdo;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.commit.CDOChangeSet;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.delta.CDOAddFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOListFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOMoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORemoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOSetFeatureDelta;
import org.eclipse.emf.cdo.internal.common.commit.CDOChangeSetDataImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOAddFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOListFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOMoveFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDORemoveFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDORevisionDeltaImpl;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDOFeatureDelta;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.transaction.CDOMerger;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.collection.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCDOMerger
implements CDOMerger {
    private final ResolutionPreference resolutionPreference;
    private CDOChangeSetData result;
    private Map<CDOID, Conflict> conflicts;
    private Map<CDOID, Object> targetMap;
    private Map<CDOID, Object> sourceMap;

    public DefaultCDOMerger() {
        this(ResolutionPreference.NONE);
    }

    public DefaultCDOMerger(ResolutionPreference resolutionPreference) {
        CheckUtil.checkArg((Object)((Object)resolutionPreference), (String)"resolutionPreference");
        this.resolutionPreference = resolutionPreference;
    }

    public final ResolutionPreference getResolutionPreference() {
        return this.resolutionPreference;
    }

    public CDOChangeSetData getResult() {
        return this.result;
    }

    public Map<CDOID, Conflict> getConflicts() {
        return this.conflicts;
    }

    @Override
    public synchronized CDOChangeSetData merge(CDOChangeSet target, CDOChangeSet source) throws CDOMerger.ConflictException {
        CDOID id;
        this.result = new CDOChangeSetDataImpl();
        this.conflicts = CDOIDUtil.createMap();
        this.targetMap = this.createMap((CDOChangeSetData)target);
        this.sourceMap = this.createMap((CDOChangeSetData)source);
        HashSet<CDOID> taken = new HashSet<CDOID>();
        for (Map.Entry<CDOID, Object> entry : this.targetMap.entrySet()) {
            Object sourceData;
            id = entry.getKey();
            Object targetData = entry.getValue();
            if (!this.merge(targetData, sourceData = this.sourceMap.get(id))) continue;
            taken.add(id);
        }
        for (Map.Entry<CDOID, Object> entry : this.sourceMap.entrySet()) {
            id = entry.getKey();
            if (!taken.add(id)) continue;
            Object sourceData = entry.getValue();
            Object targetData = this.targetMap.get(id);
            this.merge(targetData, sourceData);
        }
        if (!this.conflicts.isEmpty()) {
            throw new CDOMerger.ConflictException("Merger could not resolve all conflicts: " + this.conflicts, this, this.result);
        }
        return this.result;
    }

    protected boolean merge(Object targetData, Object sourceData) {
        Object data = null;
        if (sourceData == null) {
            if (targetData instanceof CDORevision) {
                data = this.addedInTarget((CDORevision)targetData);
            } else if (targetData instanceof CDORevisionDelta) {
                data = this.changedInTarget((CDORevisionDelta)targetData);
            } else if (targetData instanceof CDOID) {
                data = this.detachedInTarget((CDOID)targetData);
            }
        } else if (targetData == null) {
            if (sourceData instanceof CDORevision) {
                data = this.addedInSource((CDORevision)sourceData);
            } else if (sourceData instanceof CDORevisionDelta) {
                data = this.changedInSource((CDORevisionDelta)sourceData);
            } else if (sourceData instanceof CDOID) {
                data = this.detachedInSource((CDOID)sourceData);
            }
        } else if (sourceData instanceof CDOID && targetData instanceof CDOID) {
            data = this.detachedInSourceAndTarget((CDOID)sourceData);
        } else if (sourceData instanceof CDORevisionDelta && targetData instanceof CDORevisionDelta) {
            data = this.changedInSourceAndTarget((CDORevisionDelta)targetData, (CDORevisionDelta)sourceData);
        } else if (sourceData instanceof CDORevision && targetData instanceof CDORevision) {
            data = this.addedInSourceAndTarget((CDORevision)targetData, (CDORevision)sourceData);
        } else if (sourceData instanceof CDORevisionDelta && targetData instanceof CDOID) {
            data = this.changedInSourceAndDetachedInTarget((CDORevisionDelta)sourceData);
        } else if (targetData instanceof CDORevisionDelta && sourceData instanceof CDOID) {
            data = this.changedInTargetAndDetachedInSource((CDORevisionDelta)targetData);
        }
        return this.take(data);
    }

    protected Object addedInTarget(CDORevision revision) {
        return revision;
    }

    protected Object addedInSource(CDORevision revision) {
        return revision;
    }

    protected Object addedInSourceAndTarget(CDORevision targetRevision, CDORevision sourceRevision) {
        return targetRevision;
    }

    protected Object changedInTarget(CDORevisionDelta delta) {
        return delta;
    }

    protected Object detachedInTarget(CDOID id) {
        return id;
    }

    protected Object changedInSource(CDORevisionDelta delta) {
        return delta;
    }

    protected Object detachedInSource(CDOID id) {
        return id;
    }

    protected Object detachedInSourceAndTarget(CDOID id) {
        return id;
    }

    protected Object changedInSourceAndTarget(CDORevisionDelta targetDelta, CDORevisionDelta sourceDelta) {
        switch (this.resolutionPreference) {
            case SOURCE_OVER_TARGET: {
                return sourceDelta;
            }
            case TARGET_OVER_SOURCE: {
                return targetDelta;
            }
            case NONE: {
                return new ChangedInSourceAndTargetConflict(targetDelta, sourceDelta);
            }
        }
        throw new IllegalStateException("Illegal resolution preference: " + (Object)((Object)this.resolutionPreference));
    }

    protected Object changedInSourceAndDetachedInTarget(CDORevisionDelta sourceDelta) {
        switch (this.resolutionPreference) {
            case SOURCE_OVER_TARGET: {
                return sourceDelta;
            }
            case TARGET_OVER_SOURCE: {
                return sourceDelta.getID();
            }
            case NONE: {
                return new ChangedInSourceAndDetachedInTargetConflict(sourceDelta);
            }
        }
        throw new IllegalStateException("Illegal resolution preference: " + (Object)((Object)this.resolutionPreference));
    }

    protected Object changedInTargetAndDetachedInSource(CDORevisionDelta targetDelta) {
        switch (this.resolutionPreference) {
            case SOURCE_OVER_TARGET: {
                return targetDelta.getID();
            }
            case TARGET_OVER_SOURCE: {
                return targetDelta;
            }
            case NONE: {
                return new ChangedInTargetAndDetachedInSourceConflict(targetDelta);
            }
        }
        throw new IllegalStateException("Illegal resolution preference: " + (Object)((Object)this.resolutionPreference));
    }

    protected Map<CDOID, Object> getTargetMap() {
        return this.targetMap;
    }

    protected Map<CDOID, Object> getSourceMap() {
        return this.sourceMap;
    }

    private Map<CDOID, Object> createMap(CDOChangeSetData changeSetData) {
        Map map = CDOIDUtil.createMap();
        for (CDOIDAndVersion data : changeSetData.getNewObjects()) {
            map.put(data.getID(), data);
        }
        for (CDOIDAndVersion data : changeSetData.getChangedObjects()) {
            map.put(data.getID(), data);
        }
        for (CDOIDAndVersion data : changeSetData.getDetachedObjects()) {
            map.put(data.getID(), data.getID());
        }
        return map;
    }

    private boolean take(Object data) {
        if (data instanceof Pair) {
            Pair pair = (Pair)data;
            boolean taken = this.takeNoPair(pair.getElement1());
            return taken |= this.takeNoPair(pair.getElement2());
        }
        return this.takeNoPair(data);
    }

    private boolean takeNoPair(Object data) {
        if (data instanceof CDORevision) {
            this.result.getNewObjects().add((CDORevision)data);
        } else if (data instanceof CDORevisionDelta) {
            this.result.getChangedObjects().add((CDORevisionDelta)data);
        } else if (data instanceof CDOID) {
            this.result.getDetachedObjects().add(CDOIDUtil.createIDAndVersion((CDOID)((CDOID)data), (int)0));
        } else if (data instanceof Conflict) {
            Conflict conflict = (Conflict)data;
            this.conflicts.put(conflict.getID(), conflict);
        } else {
            if (data != null) {
                throw new IllegalArgumentException("Must be a CDORevision, a CDORevisionDelta, a CDOID, a Conflict or null: " + data);
            }
            return false;
        }
        return true;
    }

    public static class ChangedInSourceAndDetachedInTargetConflict
    extends Conflict {
        private CDORevisionDelta sourceDelta;

        public ChangedInSourceAndDetachedInTargetConflict(CDORevisionDelta sourceDelta) {
            this.sourceDelta = sourceDelta;
        }

        public CDOID getID() {
            return this.sourceDelta.getID();
        }

        public CDORevisionDelta getSourceDelta() {
            return this.sourceDelta;
        }

        public String toString() {
            return MessageFormat.format("ChangedInSourceAndDetachedInTarget[source={0}]", this.sourceDelta);
        }
    }

    public static class ChangedInSourceAndTargetConflict
    extends Conflict {
        private CDORevisionDelta targetDelta;
        private CDORevisionDelta sourceDelta;

        public ChangedInSourceAndTargetConflict(CDORevisionDelta targetDelta, CDORevisionDelta sourceDelta) {
            this.targetDelta = targetDelta;
            this.sourceDelta = sourceDelta;
        }

        public CDOID getID() {
            return this.targetDelta.getID();
        }

        public CDORevisionDelta getTargetDelta() {
            return this.targetDelta;
        }

        public CDORevisionDelta getSourceDelta() {
            return this.sourceDelta;
        }

        public String toString() {
            return MessageFormat.format("ChangedInSourceAndTarget[target={0}, source={1}]", this.targetDelta, this.sourceDelta);
        }
    }

    public static class ChangedInTargetAndDetachedInSourceConflict
    extends Conflict {
        private CDORevisionDelta targetDelta;

        public ChangedInTargetAndDetachedInSourceConflict(CDORevisionDelta targetDelta) {
            this.targetDelta = targetDelta;
        }

        public CDOID getID() {
            return this.targetDelta.getID();
        }

        public CDORevisionDelta getTargetDelta() {
            return this.targetDelta;
        }

        public String toString() {
            return MessageFormat.format("ChangedInTargetAndDetachedInSource[target={0}]", this.targetDelta);
        }
    }

    public static abstract class Conflict {
        public abstract CDOID getID();
    }

    public static class PerFeature
    extends DefaultCDOMerger {
        public PerFeature() {
        }

        public PerFeature(ResolutionPreference resolutionPreference) {
            super(resolutionPreference);
        }

        protected Object changedInSourceAndTarget(CDORevisionDelta targetDelta, CDORevisionDelta sourceDelta) {
            CDOFeatureDelta featureDelta;
            EStructuralFeature feature;
            CDORevisionDeltaImpl result = new CDORevisionDeltaImpl(targetDelta, false);
            ChangedInSourceAndTargetConflict conflict = null;
            Map targetMap = ((InternalCDORevisionDelta)targetDelta).getFeatureDeltaMap();
            Map sourceMap = ((InternalCDORevisionDelta)sourceDelta).getFeatureDeltaMap();
            for (CDOFeatureDelta targetFeatureDelta : targetMap.values()) {
                feature = targetFeatureDelta.getFeature();
                CDOFeatureDelta sourceFeatureDelta = (CDOFeatureDelta)sourceMap.get(feature);
                if (sourceFeatureDelta == null) {
                    featureDelta = this.changedInTarget(targetFeatureDelta);
                    if (featureDelta == null) continue;
                    result.addFeatureDelta(featureDelta, null);
                    continue;
                }
                featureDelta = this.changedInSourceAndTarget(targetFeatureDelta, sourceFeatureDelta);
                if (featureDelta != null) {
                    result.addFeatureDelta(featureDelta, null);
                    continue;
                }
                if (conflict == null) {
                    ResolutionPreference resolutionPreference = this.getResolutionPreference();
                    switch (resolutionPreference) {
                        case SOURCE_OVER_TARGET: {
                            throw new UnsupportedOperationException();
                        }
                        case TARGET_OVER_SOURCE: {
                            throw new UnsupportedOperationException();
                        }
                        case NONE: {
                            conflict = new ChangedInSourceAndTargetConflict((CDORevisionDelta)new CDORevisionDeltaImpl(targetDelta, false), (CDORevisionDelta)new CDORevisionDeltaImpl(sourceDelta, false));
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Illegal resolution preference: " + (Object)((Object)resolutionPreference));
                        }
                    }
                }
                ((InternalCDORevisionDelta)conflict.getTargetDelta()).addFeatureDelta(targetFeatureDelta, null);
                ((InternalCDORevisionDelta)conflict.getSourceDelta()).addFeatureDelta(sourceFeatureDelta, null);
            }
            for (CDOFeatureDelta sourceFeatureDelta : sourceMap.values()) {
                feature = sourceFeatureDelta.getFeature();
                CDOFeatureDelta targetFeatureDelta = (CDOFeatureDelta)targetMap.get(feature);
                if (targetFeatureDelta != null || (featureDelta = this.changedInSource(sourceFeatureDelta)) == null) continue;
                result.addFeatureDelta(featureDelta, null);
            }
            if (result.isEmpty()) {
                return conflict;
            }
            if (conflict != null) {
                return Pair.create((Object)result, conflict);
            }
            return result;
        }

        protected CDOFeatureDelta changedInTarget(CDOFeatureDelta featureDelta) {
            return featureDelta;
        }

        protected CDOFeatureDelta changedInSource(CDOFeatureDelta featureDelta) {
            return featureDelta;
        }

        protected CDOFeatureDelta changedInSourceAndTarget(CDOFeatureDelta targetFeatureDelta, CDOFeatureDelta sourceFeatureDelta) {
            EStructuralFeature feature = targetFeatureDelta.getFeature();
            if (feature.isMany()) {
                return this.changedInSourceAndTargetManyValued(feature, targetFeatureDelta, sourceFeatureDelta);
            }
            return this.changedInSourceAndTargetSingleValued(feature, targetFeatureDelta, sourceFeatureDelta);
        }

        protected CDOFeatureDelta changedInSourceAndTargetManyValued(EStructuralFeature feature, CDOFeatureDelta targetFeatureDelta, CDOFeatureDelta sourceFeatureDelta) {
            return null;
        }

        protected CDOFeatureDelta changedInSourceAndTargetSingleValued(EStructuralFeature feature, CDOFeatureDelta targetFeatureDelta, CDOFeatureDelta sourceFeatureDelta) {
            if (targetFeatureDelta.isStructurallyEqual((Object)sourceFeatureDelta)) {
                return targetFeatureDelta;
            }
            return null;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class ManyValued
        extends PerFeature {
            public ManyValued() {
            }

            public ManyValued(ResolutionPreference resolutionPreference) {
                super(resolutionPreference);
            }

            protected boolean treatAsUnique(EStructuralFeature feature) {
                return feature.isUnique();
            }

            @Override
            protected CDOFeatureDelta changedInSourceAndTargetManyValued(EStructuralFeature feature, CDOFeatureDelta targetFeatureDelta, CDOFeatureDelta sourceFeatureDelta) {
                if (targetFeatureDelta instanceof CDOListFeatureDelta && sourceFeatureDelta instanceof CDOListFeatureDelta) {
                    int originSize = ((CDOListFeatureDelta)sourceFeatureDelta.copy()).getOriginSize();
                    BasicEList ancestorList = new BasicEList(originSize);
                    PerSide<BasicEList<Element>> listPerSide = new PerSide<BasicEList<Element>>();
                    this.initWorkLists(originSize, (BasicEList<Element>)ancestorList, listPerSide);
                    PerSide<List<CDOFeatureDelta>> changesPerSide = new PerSide<List<CDOFeatureDelta>>(this.copyListChanges(sourceFeatureDelta), this.copyListChanges(targetFeatureDelta));
                    HashMap<Object, List<Element>> additions = new HashMap<Object, List<Element>>();
                    HashMap<CDOFeatureDelta, Element> allElements = new HashMap<CDOFeatureDelta, Element>();
                    this.applyChangesToWorkList(Side.SOURCE, listPerSide, changesPerSide, allElements, additions);
                    this.applyChangesToWorkList(Side.TARGET, listPerSide, changesPerSide, allElements, additions);
                    CDOListFeatureDeltaImpl result = new CDOListFeatureDeltaImpl(feature, originSize);
                    List resultChanges = result.getListChanges();
                    this.pickChangesIntoResult(Side.SOURCE, feature, (BasicEList<Element>)ancestorList, changesPerSide, allElements, additions, resultChanges);
                    this.pickChangesIntoResult(Side.TARGET, feature, (BasicEList<Element>)ancestorList, changesPerSide, allElements, additions, resultChanges);
                    return result;
                }
                return super.changedInSourceAndTargetManyValued(feature, targetFeatureDelta, sourceFeatureDelta);
            }

            private void initWorkLists(int originSize, BasicEList<Element> ancestorList, PerSide<BasicEList<Element>> listPerSide) {
                BasicEList sourceList = new BasicEList(originSize);
                BasicEList targetList = new BasicEList(originSize);
                int i = 0;
                while (i < originSize) {
                    Element element = new Element(i);
                    ancestorList.add((Object)element);
                    sourceList.add((Object)element);
                    targetList.add((Object)element);
                    ++i;
                }
                listPerSide.set(Side.SOURCE, (BasicEList<Element>)sourceList);
                listPerSide.set(Side.TARGET, (BasicEList<Element>)targetList);
            }

            private List<CDOFeatureDelta> copyListChanges(CDOFeatureDelta featureDelta) {
                CDOFeatureDelta.Type firstType;
                CDOListFeatureDelta listFeatureDelta = (CDOListFeatureDelta)featureDelta.copy();
                List copy = listFeatureDelta.getListChanges();
                if (!(copy.isEmpty() || (firstType = ((CDOFeatureDelta)copy.get(0)).getType()) != CDOFeatureDelta.Type.CLEAR && firstType != CDOFeatureDelta.Type.UNSET)) {
                    copy.remove(0);
                    List<CDOFeatureDelta> expandedDeltas = this.expandClearDelta(listFeatureDelta);
                    copy.addAll(0, expandedDeltas);
                }
                return copy;
            }

            private List<CDOFeatureDelta> expandClearDelta(CDOListFeatureDelta listFeatureDelta) {
                EStructuralFeature feature = listFeatureDelta.getFeature();
                int originSize = listFeatureDelta.getOriginSize();
                ArrayList<CDOFeatureDelta> expandedDeltas = new ArrayList<CDOFeatureDelta>(originSize);
                int i = 0;
                while (i < originSize) {
                    expandedDeltas.add((CDOFeatureDelta)new CDORemoveFeatureDeltaImpl(feature, 0));
                    ++i;
                }
                return expandedDeltas;
            }

            private void applyChangesToWorkList(Side side, PerSide<BasicEList<Element>> listPerSide, PerSide<List<CDOFeatureDelta>> changesPerSide, Map<CDOFeatureDelta, Element> allElements, Map<Object, List<Element>> additions) {
                BasicEList<Element> list = listPerSide.get(side);
                List<CDOFeatureDelta> changes = changesPerSide.get(side);
                for (CDOFeatureDelta change : changes) {
                    CDOFeatureDelta.Type changeType = change.getType();
                    switch (changeType) {
                        case ADD: {
                            CDOAddFeatureDelta addChange = (CDOAddFeatureDelta)change;
                            Element element = new Element(-1);
                            element.set(side, addChange);
                            allElements.put((CDOFeatureDelta)addChange, element);
                            list.add(addChange.getIndex(), (Object)element);
                            this.rememberAddition(addChange.getValue(), element, additions);
                            break;
                        }
                        case REMOVE: {
                            CDORemoveFeatureDelta removeChange = (CDORemoveFeatureDelta)change;
                            Element element = (Element)list.remove(removeChange.getIndex());
                            element.set(side, removeChange);
                            allElements.put((CDOFeatureDelta)removeChange, element);
                            break;
                        }
                        case SET: {
                            CDOSetFeatureDelta setChange = (CDOSetFeatureDelta)change;
                            Element newElement = new Element(-1);
                            newElement.set(side, setChange);
                            this.rememberAddition(setChange.getValue(), newElement, additions);
                            Element oldElement = (Element)list.set(setChange.getIndex(), (Object)newElement);
                            oldElement.set(side, setChange);
                            allElements.put((CDOFeatureDelta)setChange, oldElement);
                            break;
                        }
                        case MOVE: {
                            CDOMoveFeatureDelta moveChange = (CDOMoveFeatureDelta)change;
                            Element element = (Element)list.move(moveChange.getNewPosition(), moveChange.getOldPosition());
                            element.set(side, moveChange);
                            allElements.put((CDOFeatureDelta)moveChange, element);
                            break;
                        }
                        case CLEAR: 
                        case UNSET: {
                            throw new IllegalStateException("Unhandled change type: " + changeType);
                        }
                        default: {
                            throw new IllegalStateException("Illegal change type: " + changeType);
                        }
                    }
                }
            }

            private void rememberAddition(Object value, Element element, Map<Object, List<Element>> additions) {
                List<Element> additionsList = additions.get(value);
                if (additionsList == null) {
                    additionsList = new ArrayList<Element>(1);
                    additions.put(value, additionsList);
                }
                additionsList.add(element);
            }

            private void pickChangesIntoResult(Side side, EStructuralFeature feature, BasicEList<Element> ancestorList, PerSide<List<CDOFeatureDelta>> changesPerSide, Map<CDOFeatureDelta, Element> allElements, Map<Object, List<Element>> additions, List<CDOFeatureDelta> result) {
                List<CDOFeatureDelta> changes = changesPerSide.get(side);
                block14: for (CDOFeatureDelta change : changes) {
                    CDOFeatureDelta.Type changeType = change.getType();
                    block0 : switch (changeType) {
                        case ADD: {
                            Object value;
                            List<Element> elementsToAdd;
                            int sideIndex;
                            CDOAddFeatureDeltaImpl addChange = (CDOAddFeatureDeltaImpl)change;
                            result.add((CDOFeatureDelta)addChange);
                            int ancestorIndex = sideIndex = addChange.getIndex();
                            int ancestorEnd = ancestorList.size();
                            if (ancestorIndex > ancestorEnd) {
                                ancestorIndex = ancestorEnd;
                                addChange.setIndex(ancestorIndex);
                            }
                            Element newElement = allElements.get(addChange);
                            ancestorList.add(ancestorIndex, (Object)newElement);
                            if (!this.treatAsUnique(feature) || (elementsToAdd = additions.get(value = addChange.getValue())) == null) continue block14;
                            for (Element element : elementsToAdd) {
                                CDOAddFeatureDelta otherAdd = (CDOAddFeatureDelta)element.get(ManyValued.other(side));
                                if (otherAdd == null) continue;
                                element.set(ManyValued.other(side), null);
                                List<CDOFeatureDelta> otherChanges = changesPerSide.get(ManyValued.other(side));
                                int otherIndex = otherAdd.getIndex();
                                ManyValued.adjustAfterRemoval(otherChanges, otherIndex, (CDOFeatureDelta)addChange);
                            }
                            continue block14;
                        }
                        case REMOVE: {
                            CDORemoveFeatureDeltaImpl removeChange = (CDORemoveFeatureDeltaImpl)change;
                            result.add((CDOFeatureDelta)removeChange);
                            Element removedElement = allElements.get(removeChange);
                            int ancestorIndex = ancestorList.indexOf((Object)removedElement);
                            removeChange.setIndex(ancestorIndex);
                            ancestorList.remove(ancestorIndex);
                            CDOFeatureDelta otherChange = (CDOFeatureDelta)removedElement.get(ManyValued.other(side));
                            if (otherChange == null) continue block14;
                            CDOFeatureDelta.Type otherChangeType = otherChange.getType();
                            switch (otherChangeType) {
                                case REMOVE: {
                                    CDORemoveFeatureDelta otherRemove = (CDORemoveFeatureDelta)otherChange;
                                    removedElement.set(ManyValued.other(side), null);
                                    List<CDOFeatureDelta> otherChanges = changesPerSide.get(ManyValued.other(side));
                                    int otherIndex = otherRemove.getIndex();
                                    ManyValued.adjustAfterAddition(otherChanges, otherIndex, (CDOFeatureDelta)otherRemove);
                                    break block0;
                                }
                                case MOVE: {
                                    CDOMoveFeatureDelta otherMove = (CDOMoveFeatureDelta)otherChange;
                                    removedElement.set(ManyValued.other(side), null);
                                    List<CDOFeatureDelta> otherChanges = changesPerSide.get(ManyValued.other(side));
                                    int otherOldPosition = otherMove.getOldPosition();
                                    int otherNewPosition = otherMove.getNewPosition();
                                    ManyValued.adjustAfterMove(otherChanges, otherOldPosition, otherNewPosition, (CDOFeatureDelta)otherMove);
                                    break block0;
                                }
                            }
                            throw new IllegalStateException("Unexpected change type: " + otherChangeType);
                        }
                        case SET: {
                            throw new IllegalStateException("Unhandled change type: " + changeType);
                        }
                        case MOVE: {
                            int ancestorEnd;
                            CDOMoveFeatureDeltaImpl moveChange = (CDOMoveFeatureDeltaImpl)change;
                            int sideOldPosition = moveChange.getOldPosition();
                            int sideNewPosition = moveChange.getNewPosition();
                            Element movedElement = allElements.get(moveChange);
                            CDOFeatureDelta otherChange = (CDOFeatureDelta)movedElement.get(ManyValued.other(side));
                            if (otherChange != null) {
                                CDOFeatureDelta.Type otherChangeType = otherChange.getType();
                                switch (otherChangeType) {
                                    case REMOVE: {
                                        ManyValued.adjustAfterMove(changes, sideOldPosition, sideNewPosition, (CDOFeatureDelta)moveChange);
                                        movedElement.set(side, null);
                                        return;
                                    }
                                    case MOVE: {
                                        CDOMoveFeatureDelta otherMove = (CDOMoveFeatureDelta)otherChange;
                                        movedElement.set(ManyValued.other(side), null);
                                        List<CDOFeatureDelta> otherChanges = changesPerSide.get(ManyValued.other(side));
                                        int otherOldPosition = otherMove.getOldPosition();
                                        int otherNewPosition = otherMove.getNewPosition();
                                        ManyValued.adjustAfterMove(otherChanges, otherOldPosition, otherNewPosition, (CDOFeatureDelta)otherMove);
                                        movedElement.set(ManyValued.other(side), null);
                                        break;
                                    }
                                    default: {
                                        throw new IllegalStateException("Unexpected change type: " + otherChangeType);
                                    }
                                }
                            }
                            int positionDelta = sideNewPosition - sideOldPosition;
                            int ancestorOldPosition = ancestorList.indexOf((Object)movedElement);
                            int ancestorNewPosition = ancestorOldPosition + positionDelta;
                            if (ancestorNewPosition < 0) {
                                ancestorNewPosition = 0;
                            }
                            if (ancestorNewPosition > (ancestorEnd = ancestorList.size() - 1)) {
                                ancestorNewPosition = ancestorEnd;
                            }
                            moveChange.setOldPosition(ancestorOldPosition);
                            moveChange.setNewPosition(ancestorNewPosition);
                            result.add((CDOFeatureDelta)moveChange);
                            ancestorList.move(ancestorNewPosition, ancestorOldPosition);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Illegal change type: " + changeType);
                        }
                    }
                }
            }

            private static void adjustAfterAddition(List<CDOFeatureDelta> list, int index, CDOFeatureDelta deltaToRemove) {
                Iterator<CDOFeatureDelta> it = list.iterator();
                while (it.hasNext()) {
                    CDOFeatureDelta delta = it.next();
                    if (delta == deltaToRemove) {
                        it.remove();
                        continue;
                    }
                    if (!(delta instanceof InternalCDOFeatureDelta.WithIndex)) continue;
                    InternalCDOFeatureDelta.WithIndex withIndex = (InternalCDOFeatureDelta.WithIndex)delta;
                    withIndex.adjustAfterAddition(index);
                }
            }

            private static void adjustAfterRemoval(List<CDOFeatureDelta> list, int index, CDOFeatureDelta deltaToRemove) {
                Iterator<CDOFeatureDelta> it = list.iterator();
                while (it.hasNext()) {
                    CDOFeatureDelta delta = it.next();
                    if (delta == deltaToRemove) {
                        it.remove();
                        continue;
                    }
                    if (!(delta instanceof InternalCDOFeatureDelta.WithIndex)) continue;
                    InternalCDOFeatureDelta.WithIndex withIndex = (InternalCDOFeatureDelta.WithIndex)delta;
                    withIndex.adjustAfterRemoval(index);
                }
            }

            private static void adjustAfterMove(List<CDOFeatureDelta> list, int oldPosition, int newPosition, CDOFeatureDelta deltaToRemove) {
                Iterator<CDOFeatureDelta> it = list.iterator();
                while (it.hasNext()) {
                    CDOFeatureDelta delta = it.next();
                    if (delta == deltaToRemove) {
                        it.remove();
                        continue;
                    }
                    if (!(delta instanceof InternalCDOFeatureDelta.WithIndex)) continue;
                    InternalCDOFeatureDelta.WithIndex withIndex = (InternalCDOFeatureDelta.WithIndex)delta;
                    withIndex.adjustAfterRemoval(oldPosition);
                    withIndex.adjustAfterAddition(newPosition);
                }
            }

            protected static Side other(Side side) {
                if (side == Side.SOURCE) {
                    return Side.TARGET;
                }
                return Side.SOURCE;
            }

            @Deprecated
            protected CDOListFeatureDelta createResult(EStructuralFeature feature) {
                throw new UnsupportedOperationException();
            }

            @Deprecated
            protected void handleListDelta(List<CDOFeatureDelta> resultList, List<CDOFeatureDelta> listToHandle, List<CDOFeatureDelta> listToAdjust) {
                throw new UnsupportedOperationException();
            }

            @Deprecated
            protected boolean handleListDeltaAdd(List<CDOFeatureDelta> resultList, CDOAddFeatureDelta addDelta, List<CDOFeatureDelta> listToAdjust) {
                throw new UnsupportedOperationException();
            }

            @Deprecated
            protected boolean handleListDeltaRemove(List<CDOFeatureDelta> resultList, CDORemoveFeatureDelta removeDelta, List<CDOFeatureDelta> listToAdjust) {
                throw new UnsupportedOperationException();
            }

            @Deprecated
            protected boolean handleListDeltaMove(List<CDOFeatureDelta> resultList, CDOMoveFeatureDelta moveDelta, List<CDOFeatureDelta> listToAdjust) {
                throw new UnsupportedOperationException();
            }

            @Deprecated
            public static void adjustAfterAddition(List<CDOFeatureDelta> list, int index) {
                throw new UnsupportedOperationException();
            }

            @Deprecated
            public static void adjustAfterRemoval(List<CDOFeatureDelta> list, int index) {
                throw new UnsupportedOperationException();
            }

            @Deprecated
            public static void adjustAfterMove(List<CDOFeatureDelta> list, int oldPosition, int newPosition) {
                throw new UnsupportedOperationException();
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static final class Element
            extends PerSide<CDOFeatureDelta> {
                private final int ancestorIndex;

                public Element(int ancestorIndex) {
                    this.ancestorIndex = ancestorIndex;
                }

                public int getAncestorIndex() {
                    return this.ancestorIndex;
                }

                @Override
                public String toString() {
                    return String.valueOf(this.ancestorIndex);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static class PerSide<T> {
                private T source;
                private T target;

                public PerSide() {
                }

                public PerSide(T source, T target) {
                    this.source = source;
                    this.target = target;
                }

                public final T get(Side side) {
                    if (side == Side.SOURCE) {
                        return this.source;
                    }
                    return this.target;
                }

                public final void set(Side side, T value) {
                    if (side == Side.SOURCE) {
                        this.source = value;
                    } else {
                        this.target = value;
                    }
                }

                public String toString() {
                    return "source: " + this.source + "\ntarget: " + this.target;
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum Side {
                SOURCE,
                TARGET;

            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ResolutionPreference {
        NONE,
        SOURCE_OVER_TARGET,
        TARGET_OVER_SOURCE,
        DETACH_OVER_CHANGE,
        CHANGE_OVER_DETACH;

    }
}

