/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.query;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.util.CDOQueryInfo;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.util.ObjectNotFoundException;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.spi.cdo.AbstractQueryIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOQueryResultIteratorImpl<T>
extends AbstractQueryIterator<T> {
    private Map<CDOID, CDOObject> detachedObjects;

    public CDOQueryResultIteratorImpl(CDOView view, CDOQueryInfo queryInfo) {
        super(view, queryInfo);
    }

    @Override
    public void close() {
        this.detachedObjects = null;
        super.close();
    }

    public T next() {
        return this.adapt(super.next());
    }

    protected T adapt(Object object) {
        if (object instanceof CDOID) {
            CDOID id = (CDOID)object;
            if (id.isNull()) {
                return null;
            }
            CDOView view = this.getView();
            try {
                CDOObject cdoObject = view.getObject(id, true);
                return (T)CDOUtil.getEObject(cdoObject);
            }
            catch (ObjectNotFoundException ex) {
                if (view instanceof CDOTransaction) {
                    if (this.detachedObjects == null) {
                        CDOTransaction transaction = (CDOTransaction)view;
                        this.detachedObjects = transaction.getDetachedObjects();
                    }
                    CDOObject cdoObject = this.detachedObjects.get(id);
                    return (T)CDOUtil.getEObject(cdoObject);
                }
                return null;
            }
        }
        if (object instanceof Object[]) {
            Object[] objects = (Object[])object;
            Object[] resolvedObjects = new Object[objects.length];
            int i = 0;
            while (i < objects.length) {
                resolvedObjects[i] = objects[i] instanceof CDOID ? this.adapt(objects[i]) : objects[i];
                ++i;
            }
            return (T)resolvedObjects;
        }
        return (T)object;
    }

    @Override
    public List<T> asList() {
        ArrayList<Object> result = new ArrayList<Object>();
        while (super.hasNext()) {
            result.add(super.next());
        }
        return new QueryResultList(result);
    }

    @Override
    public T asValue() {
        if (this.hasNext()) {
            return this.next();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueryResultList
    extends AbstractList<T>
    implements EList<T> {
        private List<Object> objects;

        public QueryResultList(List<Object> objects) {
            this.objects = objects;
        }

        @Override
        public T get(int index) {
            return CDOQueryResultIteratorImpl.this.adapt(this.objects.get(index));
        }

        @Override
        public int size() {
            return this.objects.size();
        }

        @Override
        public String toString() {
            return "QueryResultList" + this.objects.toString();
        }

        public void move(int newPosition, T object) {
            throw new UnsupportedOperationException();
        }

        public T move(int newPosition, int oldPosition) {
            throw new UnsupportedOperationException();
        }
    }
}

