/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.infra.general.general.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.opencert.infra.general.general.ActivityRelKind;
import org.eclipse.opencert.infra.general.general.ApplicabilityKind;
import org.eclipse.opencert.infra.general.general.ChangeEffectKind;
import org.eclipse.opencert.infra.general.general.GeneralFactory;
import org.eclipse.opencert.infra.general.general.GeneralPackage;
import org.eclipse.opencert.infra.general.general.RequirementRelKind;

public class GeneralFactoryImpl
extends EFactoryImpl
implements GeneralFactory {
    public static GeneralFactory init() {
        try {
            GeneralFactory theGeneralFactory = (GeneralFactory)EPackage.Registry.INSTANCE.getEFactory("http://general/1.0");
            if (theGeneralFactory != null) {
                return theGeneralFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new GeneralFactoryImpl();
    }

    public EObject create(EClass eClass) {
        eClass.getClassifierID();
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 2: {
                return this.createRequirementRelKindFromString(eDataType, initialValue);
            }
            case 3: {
                return this.createChangeEffectKindFromString(eDataType, initialValue);
            }
            case 4: {
                return this.createActivityRelKindFromString(eDataType, initialValue);
            }
            case 5: {
                return this.createApplicabilityKindFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 2: {
                return this.convertRequirementRelKindToString(eDataType, instanceValue);
            }
            case 3: {
                return this.convertChangeEffectKindToString(eDataType, instanceValue);
            }
            case 4: {
                return this.convertActivityRelKindToString(eDataType, instanceValue);
            }
            case 5: {
                return this.convertApplicabilityKindToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public RequirementRelKind createRequirementRelKindFromString(EDataType eDataType, String initialValue) {
        RequirementRelKind result = RequirementRelKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertRequirementRelKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public ChangeEffectKind createChangeEffectKindFromString(EDataType eDataType, String initialValue) {
        ChangeEffectKind result = ChangeEffectKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertChangeEffectKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public ActivityRelKind createActivityRelKindFromString(EDataType eDataType, String initialValue) {
        ActivityRelKind result = ActivityRelKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertActivityRelKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public ApplicabilityKind createApplicabilityKindFromString(EDataType eDataType, String initialValue) {
        ApplicabilityKind result = ApplicabilityKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertApplicabilityKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public GeneralPackage getGeneralPackage() {
        return (GeneralPackage)this.getEPackage();
    }

    @Deprecated
    public static GeneralPackage getPackage() {
        return GeneralPackage.eINSTANCE;
    }
}

