/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.vocabulary.diagram.edit.parts;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.opencert.vocabulary.diagram.edit.parts.TermDefinitionsEditPart;
import org.eclipse.opencert.vocabulary.diagram.edit.parts.TermNameEditPart;
import org.eclipse.opencert.vocabulary.diagram.edit.policies.TermItemSemanticEditPolicy;
import org.eclipse.opencert.vocabulary.diagram.part.VocabularyVisualIDRegistry;
import org.eclipse.swt.graphics.Color;

public class TermEditPart
extends ShapeNodeEditPart {
    public static final int VISUAL_ID = 2001;
    protected IFigure contentPane;
    protected IFigure primaryShape;
    static final Color THIS_BACK = new Color(null, 245, 245, 245);

    public TermEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new TermItemSemanticEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy lep = new org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    protected IFigure createNodeShape() {
        this.primaryShape = new TermFigure();
        return this.primaryShape;
    }

    public TermFigure getPrimaryShape() {
        return (TermFigure)this.primaryShape;
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof TermNameEditPart) {
            ((TermNameEditPart)childEditPart).setLabel(this.getPrimaryShape().getFigureTermLabelFigure());
            return true;
        }
        if (childEditPart instanceof TermDefinitionsEditPart) {
            ((TermDefinitionsEditPart)childEditPart).setLabel(this.getPrimaryShape().getFigureTermDefinitionsLabelFigure());
            return true;
        }
        return false;
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof TermNameEditPart) {
            return true;
        }
        return childEditPart instanceof TermDefinitionsEditPart;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (this.removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
        return this.getContentPane();
    }

    protected NodeFigure createNodePlate() {
        DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(40, 40);
        return result;
    }

    protected NodeFigure createNodeFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(5);
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    protected void setForegroundColor(Color color) {
        if (this.primaryShape != null) {
            this.primaryShape.setForegroundColor(color);
        }
    }

    protected void setBackgroundColor(Color color) {
        if (this.primaryShape != null) {
            this.primaryShape.setBackgroundColor(color);
        }
    }

    protected void setLineWidth(int width) {
        if (this.primaryShape instanceof Shape) {
            ((Shape)this.primaryShape).setLineWidth(width);
        }
    }

    protected void setLineType(int style) {
        if (this.primaryShape instanceof Shape) {
            ((Shape)this.primaryShape).setLineStyle(style);
        }
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint(VocabularyVisualIDRegistry.getType(5001));
    }

    protected void handleNotificationEvent(Notification event) {
        if (event.getNotifier() == this.getModel() && EcorePackage.eINSTANCE.getEModelElement_EAnnotations().equals(event.getFeature())) {
            this.handleMajorSemanticChange();
        } else {
            super.handleNotificationEvent(event);
        }
    }

    public class TermFigure
    extends RoundedRectangle {
        private WrappingLabel fFigureTermLabelFigure;
        private WrappingLabel fFigureTermDefinitionsLabelFigure;

        public TermFigure() {
            this.setCornerDimensions(new Dimension(TermEditPart.this.getMapMode().DPtoLP(8), TermEditPart.this.getMapMode().DPtoLP(8)));
            this.setBackgroundColor(THIS_BACK);
            this.setBorder((Border)new MarginBorder(TermEditPart.this.getMapMode().DPtoLP(5), TermEditPart.this.getMapMode().DPtoLP(5), TermEditPart.this.getMapMode().DPtoLP(5), TermEditPart.this.getMapMode().DPtoLP(5)));
            this.createContents();
        }

        private void createContents() {
            this.fFigureTermLabelFigure = new WrappingLabel();
            this.fFigureTermLabelFigure.setText("Term");
            this.add((IFigure)this.fFigureTermLabelFigure);
            this.fFigureTermDefinitionsLabelFigure = new WrappingLabel();
            this.fFigureTermDefinitionsLabelFigure.setText("");
            this.add((IFigure)this.fFigureTermDefinitionsLabelFigure);
        }

        public WrappingLabel getFigureTermLabelFigure() {
            return this.fFigureTermLabelFigure;
        }

        public WrappingLabel getFigureTermDefinitionsLabelFigure() {
            return this.fFigureTermDefinitionsLabelFigure;
        }
    }
}

