/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.vocabulary.diagram.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;
import org.eclipse.opencert.vocabulary.SourceOfDefinition;
import org.eclipse.opencert.vocabulary.Term;
import org.eclipse.opencert.vocabulary.diagram.edit.policies.VocabularyBaseItemSemanticEditPolicy;

public class TermDefinedByReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject referenceOwner;
    private final EObject oldEnd;
    private final EObject newEnd;

    public TermDefinedByReorientCommand(ReorientReferenceRelationshipRequest request) {
        super(request.getLabel(), null, (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.referenceOwner = request.getReferenceOwner();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.referenceOwner instanceof Term)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof SourceOfDefinition) || !(this.newEnd instanceof Term)) {
            return false;
        }
        return VocabularyBaseItemSemanticEditPolicy.getLinkConstraints().canExistTermDefinedBy_4003(this.getNewSource(), this.getOldTarget());
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof SourceOfDefinition) || !(this.newEnd instanceof SourceOfDefinition)) {
            return false;
        }
        return VocabularyBaseItemSemanticEditPolicy.getLinkConstraints().canExistTermDefinedBy_4003(this.getOldSource(), this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getOldSource().setDefinedBy(null);
        this.getNewSource().setDefinedBy(this.getOldTarget());
        return CommandResult.newOKCommandResult((Object)this.referenceOwner);
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getOldSource().setDefinedBy(this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.referenceOwner);
    }

    protected Term getOldSource() {
        return (Term)this.referenceOwner;
    }

    protected Term getNewSource() {
        return (Term)this.newEnd;
    }

    protected SourceOfDefinition getOldTarget() {
        return (SourceOfDefinition)this.oldEnd;
    }

    protected SourceOfDefinition getNewTarget() {
        return (SourceOfDefinition)this.newEnd;
    }
}

