/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.userguidance.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.opencert.userguidance.util.CdoConnection;

public class CdoUtil {
    public static List<EObject> fetch(CdoConnection connection, EClass cl, boolean readonly) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        List<CDOResourceNode> nodes = CdoUtil.getResources(connection, readonly);
        EPackage pack = cl.getEPackage();
        String packageName = pack.getName();
        CdoUtil.getModels(nodes, result, "." + packageName);
        return result;
    }

    public static List<CDOResourceNode> getResources(CdoConnection connection, boolean readonly) {
        List<CDOResourceNode> result = null;
        if (readonly) {
            CDOView view = connection.getView("get CDO resources in a view");
            result = Arrays.asList((CDOResourceNode[])view.getElements());
        } else {
            CDOTransaction transaction = connection.getTransaction("get resources in a transaction");
            result = Arrays.asList((CDOResourceNode[])transaction.getElements());
        }
        return result;
    }

    private static void getModels(List<CDOResourceNode> nodes, List<EObject> result, String extension) {
        for (CDOResourceNode node : nodes) {
            CDOResource resource;
            String name;
            if (node instanceof CDOResourceFolder) {
                CDOResourceFolder folder = (CDOResourceFolder)node;
                CdoUtil.getModels((List<CDOResourceNode>)folder.getNodes(), result, extension);
                continue;
            }
            if (!(node instanceof CDOResource) || !(name = (resource = (CDOResource)node).getName()).endsWith(extension)) continue;
            result.addAll((Collection<EObject>)resource.eContents());
        }
    }
}

