/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.userguidance.labelparser.tokens;

import org.eclipse.opencert.userguidance.labelparser.tokens.Token;

public class HighlightItem
implements Token {
    private String rawString;
    private String body;
    private String representation;
    private ItemHeaderType headerType;
    private ItemBodyType bodyType;
    private int startIndex;

    public HighlightItem(String rawString, String body, String representation, ItemHeaderType headerType, ItemBodyType bodyType, int startIndex) {
        this.rawString = rawString;
        this.body = body;
        this.representation = representation;
        this.headerType = headerType;
        this.bodyType = bodyType;
        this.startIndex = startIndex;
    }

    public String getRawString() {
        return this.rawString;
    }

    public String getBody() {
        return this.body;
    }

    @Override
    public String getRepresentation() {
        return this.representation;
    }

    public ItemHeaderType getHeaderType() {
        return this.headerType;
    }

    public ItemBodyType getBodyType() {
        return this.bodyType;
    }

    @Override
    public int getStartIndex() {
        return this.startIndex;
    }

    public static enum ItemBodyType {
        unquoted,
        singlequoted,
        doublequoted;

    }

    public static enum ItemHeaderType {
        none,
        id,
        uri,
        path,
        var,
        voc;


        public static ItemHeaderType parse(String s) {
            ItemHeaderType result = null;
            try {
                try {
                    result = ItemHeaderType.valueOf(s.toLowerCase());
                }
                catch (Exception exception) {
                    if (result == null) {
                        result = none;
                    }
                }
            }
            finally {
                if (result == null) {
                    result = none;
                }
            }
            return result;
        }
    }
}

