/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.userguidance.autocomplete.proposalproviders;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.opencert.userguidance.autocomplete.ContentProposal2;
import org.eclipse.opencert.userguidance.autocomplete.proposalproviders.AbstractProposalProvider;
import org.eclipse.opencert.userguidance.util.ImageUtil;
import org.eclipse.opencert.userguidance.util.VocabFetcher;
import org.eclipse.opencert.vocabulary.Category;
import org.eclipse.opencert.vocabulary.Term;
import org.eclipse.opencert.vocabulary.Vocabulary;
import org.eclipse.opencert.vocabulary.VocabularyElement;
import org.eclipse.swt.graphics.Image;

public class VocabularyProposalProvider
extends AbstractProposalProvider {
    private static final String VOC = "voc";
    private static final String VAR = "var";
    private static final String path = "/icons/famfamfam/book_open.png";
    private static Image icon = null;

    public VocabularyProposalProvider(EObject eobj, int featureID) {
        super(eobj, featureID);
    }

    @Override
    protected List<ContentProposal2> createProposals(final String stringToComplete, EObject eobj, int featureID) {
        final ArrayList<ContentProposal2> result = new ArrayList<ContentProposal2>();
        VocabFetcher fetcher = new VocabFetcher(){

            @Override
            protected void readFromVocab(List<Vocabulary> vocabularies) {
                for (Vocabulary vocabulary : vocabularies) {
                    ContentProposal2 proposal;
                    String proposalDescription;
                    String proposalString;
                    MatchType matchType;
                    if (vocabulary == null) continue;
                    for (Category category : vocabulary.getCategories()) {
                        matchType = VocabularyProposalProvider.this.getMatchType(VocabularyProposalProvider.VAR, category.getName(), stringToComplete);
                        if (matchType == MatchType.noMatch) continue;
                        proposalString = VocabularyProposalProvider.this.createProposalString(VocabularyProposalProvider.VAR, (VocabularyElement)category, matchType);
                        proposalDescription = VocabularyProposalProvider.this.createProposalDescription((VocabularyElement)category);
                        proposal = new ContentProposal2(proposalString, proposalDescription, VocabularyProposalProvider.this.getImage());
                        result.add(proposal);
                    }
                    for (Term t : vocabulary.getTerms()) {
                        matchType = VocabularyProposalProvider.this.getMatchType(VocabularyProposalProvider.VOC, t.getName(), stringToComplete);
                        if (matchType == MatchType.noMatch) continue;
                        proposalString = VocabularyProposalProvider.this.createProposalString(VocabularyProposalProvider.VOC, (VocabularyElement)t, matchType);
                        proposalDescription = VocabularyProposalProvider.this.createProposalDescription((VocabularyElement)t);
                        proposal = new ContentProposal2(proposalString, proposalDescription, VocabularyProposalProvider.this.getImage());
                        result.add(proposal);
                    }
                }
            }
        };
        fetcher.execute();
        return result;
    }

    private MatchType getMatchType(String prefix, String elementName, String stringToComplete) {
        MatchType result = null;
        result = (String.valueOf(prefix) + ":" + elementName).toLowerCase().startsWith(stringToComplete.toLowerCase()) && !elementName.contains(" ") ? MatchType.match : ((String.valueOf(prefix) + ":\"" + elementName + "\"").toLowerCase().startsWith(stringToComplete.toLowerCase()) ? MatchType.doubleQuoteMatch : ((String.valueOf(prefix) + ":'" + elementName + "'").toLowerCase().startsWith(stringToComplete.toLowerCase()) ? MatchType.singleQuoteMatch : MatchType.noMatch));
        return result;
    }

    private String createProposalString(String prefix, VocabularyElement el, MatchType matchType) {
        StringBuilder result = new StringBuilder();
        result.append(prefix);
        result.append(":");
        switch (matchType) {
            case singleQuoteMatch: {
                result.append("'");
                break;
            }
            case doubleQuoteMatch: {
                result.append("\"");
                break;
            }
        }
        result.append(el.getName());
        switch (matchType) {
            case singleQuoteMatch: {
                result.append("'");
                break;
            }
            case doubleQuoteMatch: {
                result.append("\"");
                break;
            }
        }
        return result.toString();
    }

    private String createProposalDescription(VocabularyElement el) {
        if (el instanceof Term) {
            Term t = (Term)el;
            StringBuilder result = new StringBuilder();
            int i = 0;
            while (i < t.getDefinitions().size()) {
                if (i > 0) {
                    result.append("\n\n");
                }
                result.append((String)t.getDefinitions().get(i));
                ++i;
            }
            return result.toString();
        }
        return el.getDescription();
    }

    @Override
    protected Image createImage() {
        if (icon == null) {
            icon = ImageUtil.createImage(this, path);
        }
        return icon;
    }

    private static enum MatchType {
        noMatch,
        match,
        singleQuoteMatch,
        doubleQuoteMatch;

    }
}

