/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.utilities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.TemplateBinding;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.TemplateSignature;
import org.eclipse.ocl.pivot.TemplateableElement;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.resource.ICSI2ASMapping;
import org.eclipse.ocl.pivot.internal.scoping.Attribution;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.Pivotable;
import org.eclipse.ocl.xtext.base.attributes.RootCSAttribution;
import org.eclipse.ocl.xtext.base.cs2as.CS2AS;
import org.eclipse.ocl.xtext.base.cs2as.ImportDiagnostic;
import org.eclipse.ocl.xtext.base.cs2as.LibraryDiagnostic;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.xtext.base.utilities.CSI2ASMapping;
import org.eclipse.ocl.xtext.basecs.ElementCS;
import org.eclipse.ocl.xtext.basecs.ModelElementCS;
import org.eclipse.ocl.xtext.basecs.MultiplicityCS;
import org.eclipse.ocl.xtext.basecs.NamedElementCS;
import org.eclipse.ocl.xtext.basecs.OperationCS;
import org.eclipse.ocl.xtext.basecs.PathElementCS;
import org.eclipse.ocl.xtext.basecs.PathNameCS;
import org.eclipse.ocl.xtext.basecs.StructuredClassCS;
import org.eclipse.ocl.xtext.basecs.TemplateBindingCS;
import org.eclipse.ocl.xtext.basecs.TemplateParameterSubstitutionCS;
import org.eclipse.ocl.xtext.basecs.TypeRefCS;
import org.eclipse.ocl.xtext.basecs.TypedElementCS;
import org.eclipse.ocl.xtext.basecs.TypedRefCS;
import org.eclipse.ocl.xtext.basecs.TypedTypeRefCS;
import org.eclipse.ocl.xtext.basecs.WildcardTypeRefCS;
import org.eclipse.xtext.nodemodel.BidiTreeIterator;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.impl.AbstractNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextSyntaxDiagnostic;
import org.eclipse.xtext.util.ITextRegion;

public class ElementUtil {
    private static final String[] delegateExtensionPoints = new String[]{"invocation_delegate", "query_delegate", "setting_delegate", "validation_delegate"};
    private static String[][] delegationModes = null;

    public static void appendTextRegion(@NonNull StringBuilder s, @Nullable ITextRegion textRegion, boolean isSignificant) {
        s.append(isSignificant ? "[" : "(");
        if (textRegion != null) {
            s.append(String.valueOf(textRegion.getOffset()) + "," + textRegion.getLength());
        } else {
            s.append("null");
        }
        s.append(isSignificant ? "]" : ")");
    }

    public static @Nullable String getCollectionTypeName(@NonNull TypedElementCS csTypedElement) {
        TypedRefCS csTypeRef = csTypedElement.getOwnedType();
        if (csTypeRef == null) {
            return null;
        }
        MultiplicityCS csMultiplicity = csTypeRef.getOwnedMultiplicity();
        if (csMultiplicity == null) {
            return null;
        }
        int upper = csMultiplicity.getUpper();
        if (upper == 1) {
            return null;
        }
        EList<String> qualifiers = csTypedElement.getQualifiers();
        boolean isOrdered = true;
        boolean isUnique = true;
        if (qualifiers.contains("!ordered")) {
            isOrdered = false;
        } else if (qualifiers.contains("ordered")) {
            isOrdered = true;
        }
        if (qualifiers.contains("!unique")) {
            isUnique = false;
        } else if (qualifiers.contains("unique")) {
            isUnique = true;
        }
        return ElementUtil.getCollectionName(isOrdered, isUnique);
    }

    public static @NonNull String getCollectionName(boolean ordered, boolean unique) {
        if (ordered) {
            return unique ? "OrderedSet" : "Sequence";
        }
        return unique ? "Set" : "Bag";
    }

    public static @Nullable ModelElementCS getCsElement(@NonNull Element asElement) {
        Resource asResource = asElement.eResource();
        if (asResource == null) {
            return null;
        }
        ResourceSet asResourceSet = asResource.getResourceSet();
        if (asResourceSet == null) {
            return null;
        }
        PivotMetamodelManager metamodelManager = PivotMetamodelManager.findAdapter((ResourceSet)asResourceSet);
        if (metamodelManager == null) {
            return null;
        }
        EnvironmentFactoryInternal environmentFactory = metamodelManager.getEnvironmentFactory();
        ICSI2ASMapping csi2asMapping = environmentFactory.getCSI2ASMapping();
        if (csi2asMapping == null) {
            return null;
        }
        return ((CSI2ASMapping)csi2asMapping).getCSElement(asElement);
    }

    public static String[][] getDelegateURIs() {
        if (delegationModes == null) {
            HashSet<String> uris = new HashSet<String>();
            IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
            String pluginID = EcorePlugin.getPlugin().getBundle().getSymbolicName();
            String[] stringArray = delegateExtensionPoints;
            int n = delegateExtensionPoints.length;
            int n2 = 0;
            while (n2 < n) {
                String extensionPointID = stringArray[n2];
                IExtensionPoint point = pluginRegistry.getExtensionPoint(pluginID, extensionPointID);
                if (point != null) {
                    IConfigurationElement[] elements = point.getConfigurationElements();
                    int i = 0;
                    while (i < elements.length) {
                        String uri = elements[i].getAttribute("uri");
                        if (uri != null) {
                            uris.add(uri);
                        }
                        ++i;
                    }
                }
                ++n2;
            }
            ArrayList uriList = new ArrayList(uris);
            Collections.sort(uriList);
            delegationModes = new String[uriList.size()][2];
            int i = 0;
            while (i < uris.size()) {
                ElementUtil.delegationModes[i][0] = (String)uriList.get(i);
                ElementUtil.delegationModes[i][1] = (String)uriList.get(i);
                ++i;
            }
        }
        return delegationModes;
    }

    public static @Nullable RootCSAttribution getDocumentAttribution(@NonNull ElementCS context) {
        ElementCS parent;
        ElementCS target = context;
        while ((parent = target.getParent()) != null) {
            Attribution attribution = PivotUtilInternal.getAttribution((EObject)parent);
            if (attribution instanceof RootCSAttribution) {
                return (RootCSAttribution)attribution;
            }
            target = parent;
        }
        return null;
    }

    public static @NonNull String getExpressionText(@NonNull ElementCS csElement) {
        ICompositeNode parserNode = NodeModelUtils.getNode((EObject)csElement);
        if (parserNode != null) {
            String text = parserNode.getText().replace("\r", "");
            if (text.length() > 0 && text.charAt(0) == ' ') {
                text = text.substring(1);
            }
            INode nextNode = parserNode.getNextSibling();
            ICompositeNode parent = parserNode.getParent();
            while (parent != null) {
                nextNode = parent.getNextSibling();
                if (nextNode != null) {
                    String nextText = nextNode.getText().replace("\r", "");
                    int i = 0;
                    int iMax = nextText.length();
                    while (i < iMax) {
                        if (!Character.isWhitespace(nextText.charAt(i))) break;
                        ++i;
                    }
                    return String.valueOf(text) + nextText.substring(0, i);
                }
                parent = parent.getParent();
            }
            assert (text != null);
            return text;
        }
        return "null";
    }

    public static @Nullable ExpressionInOCL getFirstQuery(@NonNull PivotMetamodelManager metamodelManager, BaseCSResource csResource) throws ParserException {
        CS2AS cs2as = csResource.findCS2AS();
        if (cs2as != null) {
            ASResource asResource = cs2as.getASResource();
            for (EObject eRoot : asResource.getContents()) {
                if (!(eRoot instanceof Model)) continue;
                for (Package asPackage : ((Model)eRoot).getOwnedPackages()) {
                    for (Class asType : asPackage.getOwnedClasses()) {
                        LanguageExpression specification;
                        for (Constraint asConstraint : asType.getOwnedInvariants()) {
                            specification = asConstraint.getOwnedSpecification();
                            if (specification == null) continue;
                            return metamodelManager.parseSpecification(specification);
                        }
                        for (Operation asOperation : asType.getOwnedOperations()) {
                            specification = asOperation.getBodyExpression();
                            if (specification == null) continue;
                            return metamodelManager.parseSpecification(specification);
                        }
                    }
                }
            }
        }
        return null;
    }

    public static @Nullable TemplateParameter getFormalTemplateParameter(@NonNull TemplateParameterSubstitutionCS csTemplateParameterSubstitution) {
        TemplateBindingCS csTemplateBinding = csTemplateParameterSubstitution.getOwningBinding();
        int index = csTemplateBinding.getOwnedSubstitutions().indexOf((Object)csTemplateParameterSubstitution);
        if (index < 0) {
            return null;
        }
        TemplateBinding templateBinding = (TemplateBinding)csTemplateBinding.getPivot();
        TemplateSignature templateSignature = templateBinding.getTemplateSignature();
        List templateParameters = templateSignature.getOwnedParameters();
        if (templateParameters.size() <= index) {
            return null;
        }
        return (TemplateParameter)templateParameters.get(index);
    }

    public static @Nullable ILeafNode getLeafNode(@NonNull INode node) {
        ILeafNode leafNode = null;
        if (node instanceof ILeafNode) {
            return (ILeafNode)node;
        }
        for (ILeafNode lNode : node.getLeafNodes()) {
            if (lNode.isHidden()) continue;
            leafNode = lNode;
            return leafNode;
        }
        return null;
    }

    public static int getLower(@NonNull TypedElementCS csTypedElement) {
        TypedRefCS csTypeRef = csTypedElement.getOwnedType();
        if (csTypeRef == null) {
            return 0;
        }
        MultiplicityCS csMultiplicity = csTypeRef.getOwnedMultiplicity();
        if (csMultiplicity == null) {
            EObject esObject;
            Type type = (Type)PivotUtil.getPivot(Type.class, (Pivotable)csTypeRef);
            if (type instanceof CollectionType) {
                return 1;
            }
            if (type != null && (esObject = type.getESObject()) instanceof EDataType && ElementUtil.isPrimitiveInstanceClass((EDataType)esObject)) {
                return 1;
            }
            return 0;
        }
        return csMultiplicity.getLower();
    }

    public static <T extends NamedElementCS> @Nullable T getNamedElementCS(@NonNull Collection<T> namedElements, @NonNull String name) {
        for (NamedElementCS namedElement : namedElements) {
            if (!name.equals(namedElement.getName())) continue;
            return (T)namedElement;
        }
        return null;
    }

    public static int getEndOffset(@NonNull INode iNode) {
        if (!(iNode instanceof AbstractNode)) {
            return -1;
        }
        AbstractNode node = (AbstractNode)iNode;
        BidiTreeIterator iter = node.basicIterator();
        while (iter.hasPrevious()) {
            INode prev = (INode)iter.previous();
            if (!(prev instanceof ILeafNode) || ((ILeafNode)prev).isHidden()) continue;
            return prev.getTotalEndOffset();
        }
        return node.getTotalEndOffset();
    }

    public static boolean getQualifier(@NonNull List<String> qualifiers, @NonNull String trueString, @NonNull String falseString, boolean defaultValue) {
        if (qualifiers.contains(trueString)) {
            return true;
        }
        if (qualifiers.contains(falseString)) {
            return false;
        }
        return defaultValue;
    }

    public static @Nullable String getText(@NonNull ElementCS csElement) {
        ICompositeNode node = NodeModelUtils.getNode((EObject)csElement);
        return node != null ? NodeModelUtils.getTokenText((INode)node) : null;
    }

    public static @Nullable String getText(@NonNull ElementCS csElement, EReference feature) {
        @NonNull List nodes = NodeModelUtils.findNodesForFeature((EObject)csElement, (EStructuralFeature)feature);
        if (nodes.isEmpty()) {
            return null;
        }
        if (nodes.size() == 1) {
            return NodeModelUtils.getTokenText((INode)((INode)nodes.get(0)));
        }
        StringBuilder s = new StringBuilder();
        for (INode node : nodes) {
            s.append(NodeModelUtils.getTokenText((INode)node));
        }
        return s.toString();
    }

    public static @Nullable String getTextName(@NonNull ElementCS csElement) {
        String text = ElementUtil.getText(csElement);
        if (text == null) {
            return null;
        }
        int length = text.length();
        if (length >= 3 && text.startsWith("_'") && text.endsWith("'")) {
            return text.substring(2, length - 1);
        }
        return text;
    }

    public static int getUpper(@NonNull TypedElementCS csTypedElement) {
        TypedRefCS csTypeRef = csTypedElement.getOwnedType();
        if (csTypeRef == null) {
            return 1;
        }
        MultiplicityCS csMultiplicity = csTypeRef.getOwnedMultiplicity();
        if (csMultiplicity == null) {
            return 1;
        }
        return csMultiplicity.getUpper();
    }

    public static boolean hasSyntaxError(@NonNull List<// Could not load outer class - annotation placement on inner may be incorrect
    Resource.Diagnostic> diagnostics) {
        for (Resource.Diagnostic diagnostic : diagnostics) {
            if (diagnostic instanceof LibraryDiagnostic) {
                return true;
            }
            if (diagnostic instanceof XtextSyntaxDiagnostic) {
                return true;
            }
            if (diagnostic instanceof ImportDiagnostic) {
                return true;
            }
            if (!diagnostic.getClass().getName().equals("org.eclipse.ocl.xtext.essentialocl.utilities.EssentialOCLCSResource$RenamedDiagnostic")) continue;
            return true;
        }
        return false;
    }

    public static boolean isInOperation(@NonNull ElementCS csElement) {
        ElementCS eObject = csElement;
        while (eObject != null) {
            if (eObject instanceof OperationCS) {
                return true;
            }
            if (eObject instanceof StructuredClassCS) {
                return false;
            }
            eObject = eObject.eContainer();
        }
        return false;
    }

    public static boolean isOrdered(@NonNull TypedElementCS csTypedElement) {
        EList<String> qualifiers = csTypedElement.getQualifiers();
        assert (qualifiers != null);
        return ElementUtil.getQualifier(qualifiers, "ordered", "!ordered", false);
    }

    public static boolean isPrimitiveInstanceClass(@NonNull EDataType esObject) {
        java.lang.Class instanceClass = esObject.getInstanceClass();
        return instanceClass == Byte.TYPE || instanceClass == Character.TYPE || instanceClass == Double.TYPE || instanceClass == Float.TYPE || instanceClass == Integer.TYPE || instanceClass == Long.TYPE || instanceClass == Short.TYPE;
    }

    public static boolean isRequired(@Nullable TypedRefCS csTypeRef) {
        int lower;
        MultiplicityCS csMultiplicity;
        return csTypeRef != null && (csMultiplicity = csTypeRef.getOwnedMultiplicity()) != null && (lower = csMultiplicity.getLower()) > 0;
    }

    public static boolean isSpecialization(@NonNull TemplateBindingCS csTemplateBinding) {
        TypedTypeRefCS csTypedTypeRef = csTemplateBinding.getOwningElement();
        Element type = csTypedTypeRef.getPivot();
        for (TemplateParameterSubstitutionCS csTemplateParameterSubstitution : csTemplateBinding.getOwnedSubstitutions()) {
            TypeRefCS ownedActualParameter = csTemplateParameterSubstitution.getOwnedActualParameter();
            if (ownedActualParameter instanceof WildcardTypeRefCS) {
                return true;
            }
            Type actualParameterClass = (Type)ownedActualParameter.getPivot();
            TemplateParameter templateParameter = actualParameterClass.isTemplateParameter();
            if (templateParameter == null) {
                return true;
            }
            TemplateSignature signature = templateParameter.getOwningSignature();
            TemplateableElement template = signature.getOwningElement();
            if (template == type) continue;
            return true;
        }
        return false;
    }

    public static boolean isUnique(@NonNull TypedElementCS csTypedElement) {
        EList<String> qualifiers = csTypedElement.getQualifiers();
        assert (qualifiers != null);
        return ElementUtil.getQualifier(qualifiers, "unique", "!unique", true);
    }

    public static void setLastPathElement(@NonNull PathNameCS ownedPathName, @NonNull Element asElement) {
        EList<PathElementCS> ownedPathElements = ownedPathName.getOwnedPathElements();
        int size = ownedPathElements.size();
        if (size > 0) {
            PathElementCS pathElementCS = (PathElementCS)ownedPathElements.get(size - 1);
            pathElementCS.setReferredElement(asElement);
        }
    }
}

