/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.assistants.generator;

import java.util.ArrayList;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.papyrus.infra.filters.Filter;
import org.eclipse.papyrus.infra.gmfdiag.assistant.AssistantFactory;
import org.eclipse.papyrus.infra.gmfdiag.assistant.ConnectionAssistant;
import org.eclipse.papyrus.infra.gmfdiag.assistant.ElementTypeFilter;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.uml.profile.assistants.generator.FiltersUtil;
import org.eclipse.papyrus.uml.profile.types.generator.Identifiers;
import org.eclipse.papyrus.uml.profile.types.generator.ImpliedExtension;
import org.eclipse.papyrus.uml.profile.types.generator.UML;
import org.eclipse.papyrus.uml.profile.types.generator.UMLElementTypes;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

@Singleton
public class ConnectionAssistantRule {
    @Extension
    private static AssistantFactory assistantFactory = AssistantFactory.eINSTANCE;
    @Inject
    @Extension
    private Identifiers _identifiers;
    @Inject
    @Extension
    private UMLElementTypes _uMLElementTypes;
    @Inject
    @Extension
    private FiltersUtil _filtersUtil;
    @Inject
    @Extension
    private UML _uML;
    private final HashMap<ArrayList<?>, ConnectionAssistant> _createCache_toConnectionAssistant = CollectionLiterals.newHashMap((Pair[])new Pair[0]);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionAssistant toConnectionAssistant(ImpliedExtension umlExtension, ElementTypeConfiguration basetype) {
        ConnectionAssistant _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Object[]{umlExtension, basetype});
        HashMap<ArrayList<?>, ConnectionAssistant> hashMap = this._createCache_toConnectionAssistant;
        synchronized (hashMap) {
            ConnectionAssistant _createConnectionAssistant;
            if (this._createCache_toConnectionAssistant.containsKey(_cacheKey)) {
                return this._createCache_toConnectionAssistant.get(_cacheKey);
            }
            _result = _createConnectionAssistant = assistantFactory.createConnectionAssistant();
            this._createCache_toConnectionAssistant.put(_cacheKey, _result);
        }
        this._init_toConnectionAssistant(_result, umlExtension, basetype);
        return _result;
    }

    private void _init_toConnectionAssistant(ConnectionAssistant it, ImpliedExtension umlExtension, ElementTypeConfiguration basetype) {
        String _elementTypeID = this._identifiers.toElementTypeID(umlExtension, basetype);
        it.setElementTypeID(_elementTypeID);
        Filter _createPossibleSourcesFilter = this.createPossibleSourcesFilter(basetype, umlExtension);
        Filter _reduce = this._filtersUtil.reduce(_createPossibleSourcesFilter);
        Profile _profile = this._uML.getProfile((Object)umlExtension);
        Filter _andProfileApplied = this._filtersUtil.andProfileApplied(_reduce, _profile);
        it.setOwnedSourceFilter(_andProfileApplied);
        Filter _createPossibleTargetsFilter = this.createPossibleTargetsFilter(basetype, umlExtension);
        Filter _reduce_1 = this._filtersUtil.reduce(_createPossibleTargetsFilter);
        Profile _profile_1 = this._uML.getProfile((Object)umlExtension);
        Filter _andProfileApplied_1 = this._filtersUtil.andProfileApplied(_reduce_1, _profile_1);
        it.setOwnedTargetFilter(_andProfileApplied_1);
    }

    private Filter createPossibleSourcesFilter(final ElementTypeConfiguration basetype, final ImpliedExtension umlExtension) {
        Iterable _baseElementTypes = this._uMLElementTypes.getBaseElementTypes();
        Functions.Function1<ElementTypeConfiguration, Boolean> _function = new Functions.Function1<ElementTypeConfiguration, Boolean>(){

            public Boolean apply(ElementTypeConfiguration it) {
                boolean _isRelationship = ConnectionAssistantRule.this._uMLElementTypes.isRelationship(it);
                return !_isRelationship;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_baseElementTypes, (Functions.Function1)_function);
        Functions.Function2<Filter, ElementTypeConfiguration, Filter> _function_1 = new Functions.Function2<Filter, ElementTypeConfiguration, Filter>(){

            public Filter apply(Filter filter, ElementTypeConfiguration elementType) {
                Filter _xifexpression = null;
                boolean _canSourceToType = ConnectionAssistantRule.this._uMLElementTypes.canSourceToType(elementType, basetype);
                if (_canSourceToType) {
                    Profile _profile = ConnectionAssistantRule.this._uML.getProfile((Object)umlExtension);
                    ElementTypeFilter _filter = ConnectionAssistantRule.this._filtersUtil.toFilter(elementType, _profile);
                    _xifexpression = ConnectionAssistantRule.this._filtersUtil.operator_or(filter, (Filter)_filter);
                } else {
                    _xifexpression = filter;
                }
                return _xifexpression;
            }
        };
        return (Filter)IterableExtensions.fold((Iterable)_filter, null, (Functions.Function2)_function_1);
    }

    private Filter createPossibleTargetsFilter(final ElementTypeConfiguration basetype, final ImpliedExtension umlExtension) {
        Iterable _baseElementTypes = this._uMLElementTypes.getBaseElementTypes();
        Functions.Function1<ElementTypeConfiguration, Boolean> _function = new Functions.Function1<ElementTypeConfiguration, Boolean>(){

            public Boolean apply(ElementTypeConfiguration it) {
                boolean _isRelationship = ConnectionAssistantRule.this._uMLElementTypes.isRelationship(it);
                return !_isRelationship;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_baseElementTypes, (Functions.Function1)_function);
        Functions.Function2<Filter, ElementTypeConfiguration, Filter> _function_1 = new Functions.Function2<Filter, ElementTypeConfiguration, Filter>(){

            public Filter apply(Filter filter, ElementTypeConfiguration elementType) {
                Filter _xifexpression = null;
                boolean _canTargetFromType = ConnectionAssistantRule.this._uMLElementTypes.canTargetFromType(elementType, basetype);
                if (_canTargetFromType) {
                    Profile _profile = ConnectionAssistantRule.this._uML.getProfile((Object)umlExtension);
                    ElementTypeFilter _filter = ConnectionAssistantRule.this._filtersUtil.toFilter(elementType, _profile);
                    _xifexpression = ConnectionAssistantRule.this._filtersUtil.operator_or(filter, (Filter)_filter);
                } else {
                    _xifexpression = filter;
                }
                return _xifexpression;
            }
        };
        return (Filter)IterableExtensions.fold((Iterable)_filter, null, (Functions.Function2)_function_1);
    }
}

