/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.ui.IPackagesViewPart;
import org.eclipse.jdt.ui.wizards.NewJavaProjectWizardPageOne;
import org.eclipse.jdt.ui.wizards.NewJavaProjectWizardPageTwo;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class JavaProjectWizard
extends NewElementWizard
implements IExecutableExtension {
    private NewJavaProjectWizardPageOne fFirstPage;
    private NewJavaProjectWizardPageTwo fSecondPage;
    private IConfigurationElement fConfigElement;

    public JavaProjectWizard() {
        this(null, null);
    }

    public JavaProjectWizard(NewJavaProjectWizardPageOne pageOne, NewJavaProjectWizardPageTwo pageTwo) {
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_NEWJPRJ);
        this.setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(NewWizardMessages.JavaProjectWizard_title);
        this.fFirstPage = pageOne;
        this.fSecondPage = pageTwo;
    }

    public void addPages() {
        if (this.fFirstPage == null) {
            this.fFirstPage = new NewJavaProjectWizardPageOne();
        }
        this.addPage((IWizardPage)this.fFirstPage);
        if (this.fSecondPage == null) {
            this.fSecondPage = new NewJavaProjectWizardPageTwo(this.fFirstPage);
        }
        this.addPage((IWizardPage)this.fSecondPage);
        this.fFirstPage.init(this.getSelection(), this.getActivePart());
    }

    @Override
    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        this.fSecondPage.performFinish(monitor);
    }

    @Override
    public boolean performFinish() {
        boolean res = super.performFinish();
        if (res) {
            final IJavaElement newElement = this.getCreatedElement();
            IWorkingSet[] workingSets = this.fFirstPage.getWorkingSets();
            if (workingSets.length > 0) {
                PlatformUI.getWorkbench().getWorkingSetManager().addToWorkingSets((IAdaptable)newElement, workingSets);
            }
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
            this.selectAndReveal((IResource)this.fSecondPage.getJavaProject().getProject());
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPart activePart = JavaProjectWizard.this.getActivePart();
                    if (activePart instanceof IPackagesViewPart) {
                        PackageExplorerPart view = PackageExplorerPart.openInActivePerspective();
                        view.tryToReveal(newElement);
                    }
                }
            });
        }
        return res;
    }

    private IWorkbenchPart getActivePart() {
        IWorkbenchPage activePage;
        IWorkbenchWindow activeWindow = this.getWorkbench().getActiveWorkbenchWindow();
        if (activeWindow != null && (activePage = activeWindow.getActivePage()) != null) {
            return activePage.getActivePart();
        }
        return null;
    }

    @Override
    protected void handleFinishException(Shell shell, InvocationTargetException e) {
        String title = NewWizardMessages.JavaProjectWizard_op_error_title;
        String message = NewWizardMessages.JavaProjectWizard_op_error_create_message;
        ExceptionHandler.handle(e, this.getShell(), title, message);
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.fConfigElement = cfig;
    }

    public boolean performCancel() {
        this.fSecondPage.performCancel();
        return super.performCancel();
    }

    @Override
    public IJavaElement getCreatedElement() {
        return this.fSecondPage.getJavaProject();
    }
}

