/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.properties.modelelement;

import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class GenericAttributeObservable
extends AbstractObservableValue {
    private EObject source;
    private EditingDomain domain;
    private EStructuralFeature createIn;
    private EFactory createFrom;
    private EClass createAsValue;
    private EClass createAsReference;
    private String propertyPath;

    public GenericAttributeObservable(EObject source, EditingDomain domain, EStructuralFeature createIn, EFactory createFrom, EClass createAsValue, EClass createAsReference, String propertyPath) {
        this.source = source;
        this.domain = domain;
        this.createIn = createIn;
        this.createFrom = createFrom;
        this.createAsValue = createAsValue;
        this.createAsReference = createAsReference;
        this.propertyPath = propertyPath;
    }

    public Object getValueType() {
        return Object.class;
    }

    protected Object doGetValue() {
        EObject attribute = this.findAttribute();
        if (attribute == null) {
            return null;
        }
        Object result = attribute.eGet(attribute.eClass().getEStructuralFeature("value"));
        return result;
    }

    protected EObject findAttribute() {
        EList allAttributes = (EList)this.source.eGet(this.createIn);
        for (EObject attribute : allAttributes) {
            if (!this.createAsValue.isInstance((Object)attribute) && !this.createAsReference.isInstance((Object)attribute) || !attribute.eGet(attribute.eClass().getEStructuralFeature("name")).equals(this.propertyPath)) continue;
            return attribute;
        }
        return null;
    }

    public void doSetValue(final Object value) {
        final Object oldValue = this.doGetValue();
        if (value != null && value.equals(oldValue)) {
            return;
        }
        EObject attribute = this.findAttribute();
        EList collection = (EList)this.source.eGet(this.createIn);
        CompoundCommand command = new CompoundCommand(String.format("Set %s value", this.propertyPath)){

            public boolean prepare() {
                if (this.commandList.isEmpty()) {
                    return true;
                }
                return ((Command)this.commandList.get(0)).canExecute();
            }
        };
        if (value == null || value.equals("")) {
            if (attribute != null) {
                RemoveCommand rCommand = new RemoveCommand(this.domain, collection, (Object)attribute);
                command.append((Command)rCommand);
            }
        } else {
            if (attribute == null) {
                attribute = value instanceof String ? this.createFrom.create(this.createAsValue) : this.createFrom.create(this.createAsReference);
                CreateChildCommand crCommand = new CreateChildCommand(this.domain, this.source, this.createIn, (Object)attribute, null);
                command.append((Command)crCommand);
                EStructuralFeature feature = attribute.eClass().getEStructuralFeature("name");
                SetCommand setCommand = new SetCommand(this.domain, attribute, feature, (Object)this.propertyPath);
                command.append((Command)setCommand);
            }
            EStructuralFeature feature = attribute.eClass().getEStructuralFeature("value");
            SetCommand setCommand = new SetCommand(this.domain, attribute, feature, value);
            command.append((Command)setCommand);
        }
        this.domain.getCommandStack().execute((Command)command);
        ValueDiff diff = new ValueDiff(){

            public Object getOldValue() {
                return oldValue;
            }

            public Object getNewValue() {
                return value;
            }
        };
        this.fireValueChange(diff);
    }

    protected void fireValueChange(ValueDiff diff) {
        super.fireValueChange(diff);
    }

    protected void fireChange() {
        super.fireChange();
    }
}

