/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.conversion;

import java.text.Format;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.internal.databinding.conversion.StringToNumberParser;

public class IntegerToStringConverter
extends Converter<Object, String> {
    private final boolean primitive;
    private final Format numberFormat;
    private final Class<?> boxedType;

    private IntegerToStringConverter(Format numberFormat, Class<?> fromType, Class<?> boxedType) {
        super(fromType, String.class);
        this.primitive = fromType.isPrimitive();
        this.numberFormat = numberFormat;
        this.boxedType = boxedType;
    }

    @Override
    public String convert(Object fromObject) {
        if (fromObject == null && !this.primitive) {
            return "";
        }
        if (!this.boxedType.isInstance(fromObject)) {
            throw new IllegalArgumentException("'fromObject' is not of type [" + String.valueOf(this.boxedType) + "].");
        }
        return this.numberFormat.format(((Number)fromObject).longValue());
    }

    public static IntegerToStringConverter fromShort(boolean primitive) {
        return IntegerToStringConverter.fromShort(StringToNumberParser.getDefaultIntegerFormat(), primitive);
    }

    public static IntegerToStringConverter fromShort(Format numberFormat, boolean primitive) {
        return new IntegerToStringConverter(numberFormat, primitive ? Short.TYPE : Short.class, Short.class);
    }

    public static IntegerToStringConverter fromByte(boolean primitive) {
        return IntegerToStringConverter.fromByte(StringToNumberParser.getDefaultIntegerFormat(), primitive);
    }

    public static IntegerToStringConverter fromByte(Format numberFormat, boolean primitive) {
        return new IntegerToStringConverter(numberFormat, primitive ? Byte.TYPE : Byte.class, Byte.class);
    }
}

