/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.util;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.oomph.util.Predicate;

public final class Predicates {
    private Predicates() {
    }

    public static <T> Predicate<T> included(Set<T> inclusions) {
        return new IncludedPredicate<T>(inclusions);
    }

    public static <T> Predicate<T> excluded(Set<T> exclusions) {
        return new ExcludedPredicate<T>(exclusions);
    }

    public static <T> Predicate<T> unique() {
        return new UniquePredicate();
    }

    public static <T> Predicate<T> alwaysFalse() {
        return FalsePredicate.INSTANCE;
    }

    public static <T> Predicate<T> alwaysTrue() {
        return TruePredicate.INSTANCE;
    }

    public static final class ExcludedPredicate<T>
    implements Predicate<T> {
        private final Set<T> exclusions;

        public ExcludedPredicate(Set<T> exclusions) {
            this.exclusions = exclusions;
        }

        @Override
        public boolean apply(T element) {
            return !this.exclusions.contains(element);
        }
    }

    private static final class FalsePredicate
    implements Predicate<Object> {
        private static final Predicate<Object> INSTANCE = new FalsePredicate();

        private FalsePredicate() {
        }

        @Override
        public boolean apply(Object element) {
            return false;
        }
    }

    public static final class IncludedPredicate<T>
    implements Predicate<T> {
        private final Set<T> inclusions;

        public IncludedPredicate(Set<T> inclusions) {
            this.inclusions = inclusions;
        }

        @Override
        public boolean apply(T element) {
            return this.inclusions.contains(element);
        }
    }

    private static final class TruePredicate
    implements Predicate<Object> {
        private static final Predicate<Object> INSTANCE = new TruePredicate();

        private TruePredicate() {
        }

        @Override
        public boolean apply(Object element) {
            return true;
        }
    }

    public static final class UniquePredicate<T>
    implements Predicate<T> {
        private final Set<T> applied = new HashSet<T>();

        @Override
        public boolean apply(T element) {
            return this.applied.add(element);
        }
    }
}

