/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.eclipse.ui.internal.util.Util;

public final class CategoryActivityBindingDefinition {
    private static final int HASH_FACTOR = 89;
    private static final int HASH_INITIAL = CategoryActivityBindingDefinition.class.getName().hashCode();
    private final String activityId;
    private final String categoryId;
    private transient int hashCode = HASH_INITIAL;
    private final String sourceId;
    private transient String string;

    static Map<String, Collection<CategoryActivityBindingDefinition>> categoryActivityBindingDefinitionsByCategoryId(Collection<CategoryActivityBindingDefinition> categoryActivityBindingDefinitions) {
        if (categoryActivityBindingDefinitions == null) {
            throw new NullPointerException();
        }
        HashMap<String, Collection<CategoryActivityBindingDefinition>> map = new HashMap<String, Collection<CategoryActivityBindingDefinition>>();
        for (CategoryActivityBindingDefinition categoryActivityBindingDefinition : categoryActivityBindingDefinitions) {
            String categoryId = categoryActivityBindingDefinition.getCategoryId();
            if (categoryId == null) continue;
            HashSet<CategoryActivityBindingDefinition> categoryActivityBindingDefinitions2 = (HashSet<CategoryActivityBindingDefinition>)map.get(categoryId);
            if (categoryActivityBindingDefinitions2 == null) {
                categoryActivityBindingDefinitions2 = new HashSet<CategoryActivityBindingDefinition>();
                map.put(categoryId, categoryActivityBindingDefinitions2);
            }
            categoryActivityBindingDefinitions2.add(categoryActivityBindingDefinition);
        }
        return map;
    }

    public CategoryActivityBindingDefinition(String activityId, String categoryId, String sourceId) {
        this.activityId = activityId;
        this.categoryId = categoryId;
        this.sourceId = sourceId;
    }

    public int compareTo(Object object) {
        CategoryActivityBindingDefinition castedObject = (CategoryActivityBindingDefinition)object;
        int compareTo = Util.compare((Comparable)((Object)this.activityId), (Comparable)((Object)castedObject.activityId));
        if (compareTo == 0 && (compareTo = Util.compare((Comparable)((Object)this.categoryId), (Comparable)((Object)castedObject.categoryId))) == 0) {
            compareTo = Util.compare((Comparable)((Object)this.sourceId), (Comparable)((Object)castedObject.sourceId));
        }
        return compareTo;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object object) {
        void castedObject;
        if (!(object instanceof CategoryActivityBindingDefinition)) {
            return false;
        }
        CategoryActivityBindingDefinition categoryActivityBindingDefinition = (CategoryActivityBindingDefinition)object;
        return Objects.equals(this.activityId, castedObject.activityId) && Objects.equals(this.categoryId, castedObject.categoryId) && Objects.equals(this.sourceId, castedObject.sourceId);
    }

    public String getActivityId() {
        return this.activityId;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public int hashCode() {
        if (this.hashCode == HASH_INITIAL) {
            this.hashCode = this.hashCode * 89 + Objects.hashCode(this.activityId);
            this.hashCode = this.hashCode * 89 + Objects.hashCode(this.categoryId);
            this.hashCode = this.hashCode * 89 + Objects.hashCode(this.sourceId);
            if (this.hashCode == HASH_INITIAL) {
                ++this.hashCode;
            }
        }
        return this.hashCode;
    }

    public String toString() {
        if (this.string == null) {
            StringBuilder stringBuffer = new StringBuilder();
            stringBuffer.append('[');
            stringBuffer.append(this.activityId);
            stringBuffer.append(',');
            stringBuffer.append(this.categoryId);
            stringBuffer.append(',');
            stringBuffer.append(this.sourceId);
            stringBuffer.append(']');
            this.string = stringBuffer.toString();
        }
        return this.string;
    }
}

