/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.launches;

import java.text.NumberFormat;
import org.eclipse.jdt.junit.model.ITestElement;
import org.eclipse.jdt.junit.model.ITestElementContainer;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.swt.graphics.Image;

public class TestElementLabelDecorator
extends BaseLabelProvider
implements ILabelDecorator {
    private final NumberFormat timeFormat = NumberFormat.getNumberInstance();

    public TestElementLabelDecorator() {
        this.timeFormat.setGroupingUsed(true);
        this.timeFormat.setMinimumFractionDigits(3);
        this.timeFormat.setMaximumFractionDigits(3);
        this.timeFormat.setMinimumIntegerDigits(1);
    }

    public Image decorateImage(Image image, Object element) {
        return null;
    }

    public String decorateText(String text, Object element) {
        int count;
        ITestElementContainer container;
        double time;
        if (element instanceof ITestElementContainer && !Double.isNaN(time = (container = (ITestElementContainer)element).getElapsedTimeInSeconds()) && (count = this.countAllChildren(container)) > 1) {
            double average = time / (double)count;
            return String.valueOf(text) + " = " + count + " x " + this.timeFormat.format(average) + " s";
        }
        return null;
    }

    private int countAllChildren(ITestElementContainer container) {
        int count = 0;
        ITestElement[] iTestElementArray = container.getChildren();
        int n = iTestElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITestElement child = iTestElementArray[n2];
            count = child instanceof ITestElementContainer ? (count += this.countAllChildren((ITestElementContainer)child)) : ++count;
            ++n2;
        }
        return count;
    }
}

