/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.ui.storage;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.internal.security.storage.friends.IDeleteListener;
import org.eclipse.equinox.internal.security.storage.friends.InternalExchangeUtils;
import org.eclipse.equinox.internal.security.ui.Activator;
import org.eclipse.equinox.internal.security.ui.nls.SecUIMessages;
import org.eclipse.equinox.internal.security.ui.storage.view.ExportDialog;
import org.eclipse.equinox.internal.security.ui.storage.view.ISecurePreferencesSelection;
import org.eclipse.equinox.internal.security.ui.storage.view.NodesView;
import org.eclipse.equinox.internal.security.ui.storage.view.ValuesView;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;

public class TabContents
implements ISecurePreferencesSelection,
IDeleteListener {
    private Shell shell;
    protected NodesView nodesView = null;
    protected ValuesView valuesView = null;
    protected Button buttonSave = null;

    @Override
    public void setSelection(ISecurePreferences selectedNode) {
        this.valuesView.setInput(selectedNode);
    }

    public TabContents(TabFolder folder, int index, Shell shell) {
        this.shell = shell;
        TabItem tab = new TabItem(folder, 0, index);
        tab.setText(SecUIMessages.tabContents);
        Composite page = new Composite((Composite)folder, 0);
        tab.setControl((Control)page);
        SashForm sashForm = new SashForm(page, 256);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        Tree nodeTree = new Tree((Composite)sashForm, 2820);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.verticalSpan = 2;
        nodeTree.setLayoutData((Object)gridData);
        Composite rightPane = new Composite((Composite)sashForm, 0);
        GridLayout rightPaneLayout = new GridLayout();
        rightPaneLayout.marginHeight = 0;
        rightPaneLayout.marginWidth = 2;
        rightPane.setLayout((Layout)rightPaneLayout);
        new Label(rightPane, 0).setText(SecUIMessages.keysTable);
        Table tableOfValues = new Table(rightPane, 68354);
        tableOfValues.setLinesVisible(true);
        tableOfValues.setHeaderVisible(true);
        tableOfValues.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite buttonBar = new Composite(rightPane, 0);
        GridLayout buttonBarLayout = new GridLayout();
        buttonBarLayout.marginWidth = 0;
        buttonBar.setLayout((Layout)buttonBarLayout);
        buttonBar.setLayoutData((Object)new GridData(3, 1, false, false));
        this.buttonSave = new Button(buttonBar, 8);
        this.buttonSave.setText(SecUIMessages.saveButton);
        this.setButtonSize(this.buttonSave);
        this.buttonSave.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            ISecurePreferences root = SecurePreferencesFactory.getDefault();
            if (root == null) {
                return;
            }
            try {
                root.flush();
            }
            catch (IOException exception) {
                Activator.log(4, exception.getMessage(), null, exception);
            }
            this.validateSave();
        }));
        Button buttonDelete = new Button(buttonBar, 8);
        buttonDelete.setText(SecUIMessages.deleteButton);
        this.setButtonSize(buttonDelete);
        buttonDelete.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.deteleDefaultStorage()));
        URL location = InternalExchangeUtils.defaultStorageLocation();
        if (location != null) {
            new Label(page, 0).setText(SecUIMessages.locationButton);
            new Text(page, 8).setText(new Path(location.getFile()).toOSString());
        }
        sashForm.setWeights(new int[]{30, 70});
        this.nodesView = new NodesView(nodeTree, this);
        this.valuesView = new ValuesView(tableOfValues, this, shell);
        GridLayoutFactory.fillDefaults().margins(LayoutConstants.getSpacing()).generateLayout(page);
        this.validateSave();
    }

    @Override
    public void modified() {
        this.validateSave();
    }

    public void validateSave() {
        ISecurePreferences root = SecurePreferencesFactory.getDefault();
        if (root == null) {
            return;
        }
        boolean modified = root == null ? false : InternalExchangeUtils.isModified((ISecurePreferences)root);
        this.buttonSave.setEnabled(modified);
    }

    public void onDeleted() {
        if (this.nodesView != null) {
            this.nodesView.postDeleted();
        }
    }

    protected void export() {
        ISecurePreferences root = SecurePreferencesFactory.getDefault();
        if (root == null) {
            return;
        }
        ExportDialog dialog = new ExportDialog(this.shell);
        dialog.open();
        String fileName = dialog.getFileName();
        if (fileName == null) {
            return;
        }
        File outputFile = new File(fileName);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (PrintStream output = new PrintStream(new FileOutputStream(outputFile));){
                this.export(root, output);
                output.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            Activator.log(4, e.getMessage(), null, e);
            return;
        }
    }

    protected void export(ISecurePreferences node, PrintStream stream) {
        String[] children;
        int n;
        int n2;
        String[] stringArray;
        if ("/org.eclipse.equinox.secure.storage".equals(node.absolutePath())) {
            return;
        }
        String[] keys = node.keys();
        if (keys.length > 0) {
            String header = String.valueOf('[') + node.absolutePath() + ']';
            stream.println(header);
            stringArray = keys;
            n2 = keys.length;
            n = 0;
            while (n < n2) {
                String key = stringArray[n];
                try {
                    String data = String.valueOf(key) + " := " + node.get(key, "");
                    stream.println(data);
                }
                catch (StorageException e) {
                    Activator.log(4, SecUIMessages.failedDecrypt, null, e);
                }
                ++n;
            }
        }
        stringArray = children = node.childrenNames();
        n2 = children.length;
        n = 0;
        while (n < n2) {
            String child = stringArray[n];
            this.export(node.node(child), stream);
            ++n;
        }
    }

    protected void setButtonSize(Button button) {
        GridDataFactory.defaultsFor((Control)button).align(4, 1).grab(false, false).applyTo((Control)button);
    }

    protected void deteleDefaultStorage() {
        URL location = InternalExchangeUtils.defaultStorageLocation();
        if (location == null) {
            return;
        }
        MessageBox messageBox = new MessageBox(this.shell, 192);
        messageBox.setText(SecUIMessages.generalDialogTitle);
        messageBox.setMessage(SecUIMessages.confirmDeleteMsg);
        if (messageBox.open() != 64) {
            return;
        }
        ISecurePreferences defaultStorage = SecurePreferencesFactory.getDefault();
        defaultStorage.clear();
        defaultStorage.removeNode();
        InternalExchangeUtils.defaultStorageDelete();
        if (this.nodesView != null) {
            this.nodesView.postDeleted();
        }
        MessageBox postDeletionBox = new MessageBox(this.shell, 192);
        postDeletionBox.setText(SecUIMessages.generalDialogTitle);
        postDeletionBox.setMessage(SecUIMessages.postDeleteMsg);
        int result = postDeletionBox.open();
        if (result == 64) {
            PlatformUI.getWorkbench().restart();
        }
    }
}

