/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.targlets.tests;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.oomph.p2.P2Factory;
import org.eclipse.oomph.p2.Repository;
import org.eclipse.oomph.p2.RepositoryList;
import org.eclipse.oomph.p2.Requirement;
import org.eclipse.oomph.p2.tests.AbstractP2Test;
import org.eclipse.oomph.resources.ResourcesFactory;
import org.eclipse.oomph.resources.ResourcesUtil;
import org.eclipse.oomph.resources.SourceLocator;
import org.eclipse.oomph.targlets.Targlet;
import org.eclipse.oomph.targlets.TargletFactory;
import org.eclipse.oomph.targlets.core.ITargletContainer;
import org.eclipse.oomph.targlets.internal.core.TargletContainer;
import org.eclipse.oomph.targlets.tests.TargletsTestsPlugin;
import org.eclipse.oomph.util.pde.TargetPlatformRunnable;
import org.eclipse.oomph.util.pde.TargetPlatformUtil;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.core.target.TargetFeature;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FixMethodOrder(value=MethodSorters.JVM)
public class TargletTests
extends AbstractP2Test {
    private static final String TARGET_NAME = "Test Target";
    private static final String CONTAINER_ID = "Test Targlets";
    private static final String TARGLET_NAME = "Test Targlet";
    private ITargetDefinition target;
    private ITargletContainer targletContainer;

    private File getTestFolder() {
        return this.getTestFolder(TargletsTestsPlugin.INSTANCE, this.testName.getMethodName());
    }

    private Targlet setTarglet(EList<Repository> repositories, EList<Requirement> requirements) throws CoreException {
        File testFolder = this.getTestFolder();
        SourceLocator sourceLocator = ResourcesFactory.eINSTANCE.createSourceLocator(testFolder.getAbsolutePath());
        RepositoryList repositoryList = P2Factory.eINSTANCE.createRepositoryList();
        if (repositories != null) {
            repositoryList.getRepositories().addAll(repositories);
        }
        Targlet targlet = TargletFactory.eINSTANCE.createTarglet(TARGLET_NAME);
        targlet.getSourceLocators().add((Object)sourceLocator);
        targlet.getRepositoryLists().add((Object)repositoryList);
        if (requirements != null) {
            targlet.getRequirements().addAll(requirements);
        }
        this.setTarglet(targlet);
        return targlet;
    }

    private void setTarglet(Targlet targlet) throws CoreException {
        Set<Targlet> targlets = Collections.singleton(targlet);
        this.targletContainer.setTarglets(targlets);
        this.targletContainer.forceUpdate(true, false, LOGGER);
    }

    private static void assertImportedProjects(String ... names) {
        IProject[] projects;
        HashSet<String> expected = new HashSet<String>(Arrays.asList(names));
        HashSet<String> actual = new HashSet<String>();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            actual.add(project.getName());
            ++n2;
        }
        MatcherAssert.assertThat(actual, (Matcher)TargletTests.is(expected));
    }

    private void assertTargetPlatform(String ... ius) {
        TargetFeature[] features;
        int n;
        HashSet<String> expected = new HashSet<String>(Arrays.asList(ius));
        HashSet<String> actual = new HashSet<String>();
        TargetBundle[] bundles = this.target.getAllBundles();
        if (bundles != null) {
            TargetBundle[] targetBundleArray = bundles;
            n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                TargetBundle bundle = targetBundleArray[n2];
                BundleInfo bundleInfo = bundle.getBundleInfo();
                actual.add(String.valueOf(bundleInfo.getSymbolicName()) + "_" + bundleInfo.getVersion());
                ++n2;
            }
        }
        if ((features = this.target.getAllFeatures()) != null) {
            TargetFeature[] targetFeatureArray = features;
            int n3 = features.length;
            n = 0;
            while (n < n3) {
                TargetFeature feature = targetFeatureArray[n];
                actual.add(String.valueOf(feature.getId()) + ".feature.group_" + feature.getVersion());
                ++n;
            }
        }
        MatcherAssert.assertThat(actual, (Matcher)TargletTests.is(expected));
    }

    public void setUp() throws Exception {
        super.setUp();
        ResourcesUtil.clearWorkspace();
        TargetPlatformUtil.runWithTargetPlatformService((TargetPlatformRunnable)new TargetPlatformRunnable<Object>(){

            public Object run(ITargetPlatformService service) throws CoreException {
                ITargetLocation[] newLocations;
                ITargetHandle[] iTargetHandleArray = service.getTargets(LOGGER);
                int n = iTargetHandleArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITargetHandle targetHandle = iTargetHandleArray[n2];
                    ITargetDefinition target = targetHandle.getTargetDefinition();
                    if (TargletTests.TARGET_NAME.equals(target.getName())) {
                        service.deleteTarget(targetHandle);
                        break;
                    }
                    ++n2;
                }
                TargletTests.this.target = service.newTarget();
                TargletTests.this.target.setName(TargletTests.TARGET_NAME);
                TargletTests.this.targletContainer = (ITargletContainer)new TargletContainer(TargletTests.CONTAINER_ID);
                ITargetLocation[] oldLocations = TargletTests.this.target.getTargetLocations();
                if (oldLocations != null && oldLocations.length != 0) {
                    newLocations = new ITargetLocation[oldLocations.length + 1];
                    System.arraycopy(oldLocations, 0, newLocations, 0, oldLocations.length);
                    newLocations[oldLocations.length] = TargletTests.this.targletContainer;
                } else {
                    newLocations = new ITargetLocation[]{TargletTests.this.targletContainer};
                }
                TargletTests.this.target.setTargetLocations(newLocations);
                return null;
            }
        });
    }

    public void tearDown() throws Exception {
        this.targletContainer = null;
        this.target = null;
        super.tearDown();
    }

    @Test
    public void testOnlySources() throws Exception {
        this.assertTargetPlatform(new String[0]);
        TargletTests.assertImportedProjects(new String[0]);
        BasicEList requirements = new BasicEList();
        requirements.add((Object)P2Factory.eINSTANCE.createRequirement("com.foo.project1.feature.group"));
        Targlet targlet = this.setTarglet(null, (EList<Requirement>)requirements);
        this.assertTargetPlatform(new String[0]);
        TargletTests.assertImportedProjects("com.foo.project1-feature", "com.foo.project1", "com.foo.license-feature");
        targlet.getRequirements().add((Object)P2Factory.eINSTANCE.createRequirement("com.foo.releng"));
        this.setTarglet(targlet);
        this.assertTargetPlatform(new String[0]);
        TargletTests.assertImportedProjects("com.foo.project1-feature", "com.foo.project1", "com.foo.license-feature", "com.foo.releng");
    }
}

