/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.jreinfo;

import java.io.File;
import org.eclipse.oomph.jreinfo.JREFilter;
import org.eclipse.oomph.jreinfo.JREManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JRE
implements Comparable<JRE> {
    private static final String SEPARATOR = File.pathSeparator;
    private final File javaHome;
    private final int major;
    private final int minor;
    private final int micro;
    private final int bitness;
    private final boolean jdk;
    private final long lastModified;

    public JRE(File javaHome, int major, int minor, int micro, int bitness, boolean jdk, long lastModified) {
        this.javaHome = javaHome;
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.bitness = bitness;
        this.jdk = jdk;
        this.lastModified = lastModified;
    }

    JRE(File javaHome, JRE info) {
        this.javaHome = javaHome;
        this.major = info.major;
        this.minor = info.minor;
        this.micro = info.micro;
        this.bitness = info.bitness;
        this.jdk = info.jdk;
        this.lastModified = info.lastModified;
    }

    JRE(String line) {
        String[] tokens = line.split(SEPARATOR);
        this.javaHome = new File(tokens[0]);
        this.major = Integer.parseInt(tokens[1]);
        this.minor = Integer.parseInt(tokens[2]);
        this.micro = Integer.parseInt(tokens[3]);
        this.bitness = Integer.parseInt(tokens[4]);
        this.jdk = Boolean.parseBoolean(tokens[5]);
        this.lastModified = Long.parseLong(tokens[6]);
    }

    public File getJavaHome() {
        return this.javaHome;
    }

    public File getJavaExecutable() {
        return JRE.getExecutable(this.javaHome);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public int getBitness() {
        return this.bitness;
    }

    public boolean isJDK() {
        return this.jdk;
    }

    public boolean isValid() {
        File executable = this.getJavaExecutable();
        if (!executable.isFile()) {
            return false;
        }
        return executable.lastModified() == this.lastModified;
    }

    public boolean isCurrent() {
        String systemJavaHome = System.getProperty("java.home");
        return this.javaHome.getPath().equals(systemJavaHome);
    }

    public boolean isMatch(JREFilter filter) {
        Integer filterMajor = filter.getMajor();
        if (filterMajor != null && this.major < filterMajor) {
            return false;
        }
        Integer filterMinor = filter.getMinor();
        if (filterMinor != null && this.minor < filterMinor) {
            return false;
        }
        Integer filterMicro = filter.getMicro();
        if (filterMicro != null && this.micro < filterMicro) {
            return false;
        }
        Integer filterBitness = filter.getBitness();
        if (filterBitness != null && this.bitness != filterBitness) {
            return false;
        }
        Boolean filterJDK = filter.isJDK();
        return filterJDK == null || this.jdk == filterJDK;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.javaHome == null ? 0 : this.javaHome.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JRE other = (JRE)obj;
        return !(this.javaHome == null ? other.javaHome != null : !this.javaHome.equals(other.javaHome));
    }

    @Override
    public int compareTo(JRE o) {
        int result = o.major - this.major;
        if (result == 0 && (result = o.minor - this.minor) == 0 && (result = o.micro - this.micro) == 0 && (result = o.bitness - this.bitness) == 0) {
            result = (o.jdk ? 1 : 0) - (this.jdk ? 1 : 0);
        }
        return result;
    }

    public String toString() {
        return String.valueOf(this.javaHome.getPath()) + (this.isCurrent() ? " (Current)" : "");
    }

    String toLine() {
        return String.valueOf(this.javaHome.getAbsolutePath()) + SEPARATOR + this.major + SEPARATOR + this.minor + SEPARATOR + this.micro + SEPARATOR + this.bitness + SEPARATOR + this.jdk + SEPARATOR + this.lastModified;
    }

    static File getExecutable(File javaHome) {
        return new File(javaHome, "bin/" + JREManager.JAVA_EXECUTABLE);
    }
}

