/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.resources.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.oomph.base.impl.ModelElementImpl;
import org.eclipse.oomph.resources.ProjectFactory;
import org.eclipse.oomph.resources.ResourcesPackage;
import org.eclipse.oomph.resources.backend.BackendContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProjectFactoryImpl
extends ModelElementImpl
implements ProjectFactory {
    protected EList<String> excludedPaths;
    private Set<URI> excludedURIs;

    protected ProjectFactoryImpl() {
    }

    protected EClass eStaticClass() {
        return ResourcesPackage.Literals.PROJECT_FACTORY;
    }

    @Override
    public EList<String> getExcludedPaths() {
        if (this.excludedPaths == null) {
            this.excludedPaths = new EDataTypeUniqueEList<String>(String.class, (InternalEObject)this, 1){
                private static final long serialVersionUID = 1L;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void didChange() {
                    ProjectFactoryImpl projectFactoryImpl = ProjectFactoryImpl.this;
                    synchronized (projectFactoryImpl) {
                        ProjectFactoryImpl.this.excludedURIs = null;
                    }
                }
            };
        }
        return this.excludedPaths;
    }

    @Override
    public final IProject createProject(BackendContainer rootContainer, BackendContainer backendContainer, IProgressMonitor monitor) {
        if (this.isExcludedPath(rootContainer, backendContainer)) {
            return null;
        }
        return this.doCreateProject(rootContainer, backendContainer, monitor);
    }

    protected abstract IProject doCreateProject(BackendContainer var1, BackendContainer var2, IProgressMonitor var3);

    @Override
    public synchronized boolean isExcludedPath(BackendContainer rootContainer, BackendContainer backendContainer) {
        URI relativeURI;
        if (this.excludedURIs == null) {
            this.excludedURIs = new HashSet<URI>();
            for (String path : this.getExcludedPaths()) {
                while (path.startsWith("/")) {
                    path = path.substring(1);
                }
                this.excludedURIs.add(URI.createURI((String)path));
            }
        }
        return (relativeURI = backendContainer.getRelativeURI(rootContainer)) != null && this.excludedURIs.contains(relativeURI);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getExcludedPaths();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.getExcludedPaths().clear();
                this.getExcludedPaths().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.getExcludedPaths().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return this.excludedPaths != null && !this.excludedPaths.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 1: {
                return this.createProject((BackendContainer)arguments.get(0), (BackendContainer)arguments.get(1), (IProgressMonitor)arguments.get(2));
            }
            case 2: {
                return this.isExcludedPath((BackendContainer)arguments.get(0), (BackendContainer)arguments.get(1));
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (excludedPaths: ");
        result.append(this.excludedPaths);
        result.append(')');
        return result.toString();
    }
}

